/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test;

import docking.Tool;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import ghidra.app.plugin.core.codebrowser.CodeBrowserPlugin;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.test.AbstractGhidraHeadedIntegrationTest;
import ghidra.test.TestEnv;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import util.CollectionUtils;
import utility.function.ExceptionalConsumer;
import utility.function.ExceptionalFunction;

public abstract class AbstractProgramBasedTest
extends AbstractGhidraHeadedIntegrationTest {
    protected TestEnv env;
    protected PluginTool tool;
    protected Program program;
    protected CodeBrowserPlugin codeBrowser;

    protected String getProgramName() {
        throw new AssertException("You must override getProgramName() if you are not building your own program manually");
    }

    protected void initialize() throws Exception {
        this.env = new TestEnv();
        this.program = this.getProgram();
        this.tool = this.env.launchDefaultTool(this.program);
        this.codeBrowser = AbstractProgramBasedTest.getPlugin(this.tool, CodeBrowserPlugin.class);
    }

    protected Program getProgram() throws Exception {
        return this.env.getProgram(this.getProgramName());
    }

    @After
    public void tearDown() throws Exception {
        this.env.dispose();
    }

    public void assertCurrentAddress(Address expected) {
        this.codeBrowser.updateNow();
        AbstractProgramBasedTest.waitForSwing();
        ProgramLocation loc = this.codeBrowser.getCurrentLocation();
        Address actual = loc.getAddress();
        Assert.assertEquals((String)"Listing is not at the expected address", (Object)expected, (Object)actual);
    }

    public Address addr(long offset) {
        return this.addr(this.program, offset);
    }

    public Address addr(String offset) {
        return this.addr(this.program, offset);
    }

    public Address addr(Program p, long offset) {
        AddressFactory addrMap = this.program.getAddressFactory();
        AddressSpace space = addrMap.getDefaultAddressSpace();
        return space.getAddress(offset);
    }

    public Address addr(Program p, String offset) {
        AddressFactory addrMap = p.getAddressFactory();
        AddressSpace space = addrMap.getDefaultAddressSpace();
        try {
            return space.getAddress(offset);
        }
        catch (AddressFormatException e) {
            throw new AssertException("Unable to create address from String '" + offset + "'", (Throwable)e);
        }
    }

    public void goTo(long offset) {
        this.goTo(this.tool, this.program, this.addr(offset));
    }

    public void goTo(String offset) {
        this.goTo(this.tool, this.program, this.addr(offset));
    }

    public AddressRange range(long from, long to) {
        AddressRangeImpl range = new AddressRangeImpl(this.addr(from), this.addr(to));
        return range;
    }

    public void showProvider(String name) {
        this.showProvider((Tool)this.tool, name);
    }

    public Function function(Address addr) {
        FunctionManager fm = this.program.getFunctionManager();
        Function f = fm.getFunctionContaining(addr);
        return f;
    }

    public List<Address> addrs(long ... offsets) {
        ArrayList<Address> result = new ArrayList<Address>();
        for (long offset : offsets) {
            result.add(this.addr(offset));
        }
        return result;
    }

    public AddressSet toAddressSet(long ... offsets) {
        List<Address> list = this.addrs(offsets);
        AddressSet addrs = this.toAddressSet(list);
        return addrs;
    }

    public List<Address> addrs(Address ... addrs) {
        return CollectionUtils.asList((Object[])addrs);
    }

    public void goTo(Address a) {
        this.goTo(this.tool, this.program, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Exception> void modifyProgram(ExceptionalConsumer<Program, E> callback) {
        Assert.assertNotNull((String)"Program cannot be null", (Object)this.program);
        boolean commit = false;
        int tx = this.program.startTransaction("Test");
        try {
            callback.accept((Object)this.program);
            commit = true;
        }
        catch (Exception e) {
            AbstractProgramBasedTest.failWithException((String)("Exception modifying program '" + this.program.getName() + "'"), (Throwable)e);
        }
        finally {
            this.program.endTransaction(tx, commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, E extends Exception> R createInProgram(ExceptionalFunction<Program, R, E> f) {
        Assert.assertNotNull((String)"Program cannot be null", (Object)this.program);
        Object result = null;
        boolean commit = false;
        int tx = this.program.startTransaction("Test");
        try {
            result = f.apply((Object)this.program);
            commit = true;
        }
        catch (Exception e) {
            AbstractProgramBasedTest.failWithException((String)("Exception modifying program '" + this.program.getName() + "'"), (Throwable)e);
        }
        finally {
            this.program.endTransaction(tx, commit);
        }
        return (R)result;
    }

    protected ListingField getField(Address a, String fieldName) {
        ListingPanel panel = this.codeBrowser.getListingPanel();
        BigInteger index = panel.getAddressIndexMap().getIndex(a);
        FieldPanel fieldPanel = panel.getFieldPanel();
        ListingField field = this.getField(fieldName, 1, index, fieldPanel);
        return field;
    }

    protected ListingField getField(String fieldName, int occurrence, BigInteger index, FieldPanel fieldPanel) {
        if (fieldName == null) {
            return null;
        }
        LayoutModel model = fieldPanel.getLayoutModel();
        Layout layout = model.getLayout(index);
        if (layout == null) {
            return null;
        }
        int instanceNum = 1;
        for (int i = 0; i < layout.getNumFields(); ++i) {
            ListingField bf = (ListingField)layout.getField(i);
            if (!bf.getFieldFactory().getFieldName().equals(fieldName) || instanceNum++ != occurrence) continue;
            return bf;
        }
        return null;
    }
}

