/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.parse;

import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.collections4.IterableUtils;

public class AssemblyParseErrorResult
extends AssemblyParseResult {
    private static final int SUGGESTIONS_THRESHOLD = 10;
    private final String buffer;
    private final Set<String> suggestions;

    protected AssemblyParseErrorResult(String got, Set<String> suggestions) {
        this.buffer = got;
        this.suggestions = suggestions;
    }

    @Override
    public boolean isError() {
        return true;
    }

    public String describeError() {
        Collection<String> truncSuggestions;
        if (this.suggestions.size() <= 10) {
            truncSuggestions = this.suggestions;
        } else {
            truncSuggestions = new ArrayList();
            for (String s : IterableUtils.boundedIterable(this.suggestions, (long)10L)) {
                truncSuggestions.add(s);
            }
            truncSuggestions.add("...");
        }
        return "Syntax Error: Expected " + truncSuggestions + ". Got " + this.buffer;
    }

    public Set<String> getSuggestions() {
        return Collections.unmodifiableSet(this.suggestions);
    }

    public String getBuffer() {
        return this.buffer;
    }

    public String toString() {
        return this.describeError();
    }
}

