/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyState;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyTreeResolver;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AssemblyConstructState
extends AbstractAssemblyState {
    protected final AssemblyConstructorSemantic sem;
    protected final List<AbstractAssemblyState> children;

    protected static int computeEnd(List<AbstractAssemblyState> operands) {
        return operands.stream().map(s -> s.shift + s.length).reduce(0, Integer::max);
    }

    public AssemblyConstructState(AssemblyTreeResolver resolver, List<AssemblyConstructorSemantic> path, int shift, AssemblyConstructorSemantic sem, List<AbstractAssemblyState> children) {
        super(resolver, path, shift, Integer.max(AssemblyConstructState.computeEnd(children) - shift, sem.cons.getMinimumLength()));
        this.sem = sem;
        this.children = children;
    }

    @Override
    public int computeHash() {
        return Objects.hash(this.getClass(), this.shift, this.sem, this.children);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AssemblyConstructState)) {
            return false;
        }
        AssemblyConstructState that = (AssemblyConstructState)obj;
        if (this.resolver != that.resolver) {
            return false;
        }
        if (this.shift != that.shift) {
            return false;
        }
        if (!Objects.equals(this.sem, that.sem)) {
            return false;
        }
        return Objects.equals(this.children, that.children);
    }

    public String toString() {
        return this.sem.getLocation() + "[" + this.children.stream().map(s -> s.toString()).collect(Collectors.joining(",")) + "]";
    }

    @Override
    protected Stream<AssemblyResolvedPatterns> resolve(AssemblyResolvedPatterns fromRight, Collection<AssemblyResolvedError> errors) {
        String desc = "Resolving constructor: " + this.sem.getLocation();
        return this.resolveRemainingChildren(fromRight, errors, this.children).flatMap(fromChildren -> this.resolveMutations((AssemblyResolvedPatterns)fromChildren, errors)).flatMap(fromMutations -> this.resolvePatterns((AssemblyResolvedPatterns)fromMutations, errors)).map(pat -> pat.parent(desc, this.children.size()).withConstructor(this.sem.cons));
    }

    protected Stream<AssemblyResolvedPatterns> resolvePatterns(AssemblyResolvedPatterns fromMutations, Collection<AssemblyResolvedError> errors) {
        return this.sem.getPatterns().stream().map(pat -> {
            DBG.println(this.path + ": Constructor pattern: " + pat.lineToString());
            DBG.println(this.path + ": Current     pattern: " + fromMutations.lineToString());
            AssemblyResolvedPatterns combined = fromMutations.combine(pat.shift(this.shift));
            return combined;
        }).filter(ar -> {
            if (ar == null) {
                errors.add(AssemblyResolution.error("Pattern conflict", "Resolving " + this.sem.getLocation() + " in " + this.path));
                return false;
            }
            return true;
        });
    }

    protected Stream<AssemblyResolvedPatterns> resolveMutations(AssemblyResolvedPatterns fromChildren, Collection<AssemblyResolvedError> errors) {
        AssemblyResolution ar = this.sem.solveContextChanges(fromChildren, this.resolver.vals);
        if (ar.isError()) {
            errors.add((AssemblyResolvedError)ar);
            return Stream.of(new AssemblyResolvedPatterns[0]);
        }
        if (ar.isBackfill()) {
            throw new AssertionError();
        }
        AssemblyResolvedPatterns pat = (AssemblyResolvedPatterns)ar;
        return Stream.of(pat.solveContextChangesForForbids(this.sem, this.resolver.vals));
    }

    protected Stream<AssemblyResolvedPatterns> resolveRemainingChildren(AssemblyResolvedPatterns fromRight, Collection<AssemblyResolvedError> errors, List<AbstractAssemblyState> children) {
        if (children.isEmpty()) {
            return Stream.of(fromRight);
        }
        AbstractAssemblyState rightMost = children.get(children.size() - 1);
        return rightMost.resolve(fromRight, errors).flatMap(fromChild -> this.resolveRemainingChildren((AssemblyResolvedPatterns)fromChild, errors, children.subList(0, children.size() - 1)));
    }
}

