/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.semantics;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.HandleTpl;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.sleigh.grammar.Location;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.jdom.Element;

public class VarnodeTpl {
    public final Location location;
    private ConstTpl space;
    private ConstTpl offset;
    private ConstTpl size;
    boolean unnamed_flag;

    public void dispose() {
    }

    public ConstTpl getSpace() {
        return this.space;
    }

    public ConstTpl getOffset() {
        return this.offset;
    }

    public ConstTpl getSize() {
        return this.size;
    }

    public boolean isZeroSize() {
        return this.size.isZero();
    }

    public void setOffset(long constVal) {
        this.offset = new ConstTpl(ConstTpl.const_type.real, constVal);
    }

    public void setRelative(long constVal) {
        this.offset = new ConstTpl(ConstTpl.const_type.j_relative, constVal);
    }

    public void setSize(ConstTpl sz) {
        this.size = new ConstTpl(sz);
    }

    public boolean isUnnamed() {
        return this.unnamed_flag;
    }

    public void setUnnamed(boolean val) {
        this.unnamed_flag = val;
    }

    public boolean isRelative() {
        return this.offset.getType() == ConstTpl.const_type.j_relative;
    }

    public VarnodeTpl(Location location, int hand, boolean zerosize) {
        this.location = location;
        this.space = new ConstTpl(ConstTpl.const_type.handle, hand, ConstTpl.v_field.v_space);
        this.offset = new ConstTpl(ConstTpl.const_type.handle, hand, ConstTpl.v_field.v_offset);
        this.size = new ConstTpl(ConstTpl.const_type.handle, hand, ConstTpl.v_field.v_size);
        if (zerosize) {
            this.size = new ConstTpl(ConstTpl.const_type.real, 0L);
        }
        this.unnamed_flag = false;
    }

    public VarnodeTpl(Location location, ConstTpl sp, ConstTpl off, ConstTpl sz) {
        this.location = location;
        this.space = new ConstTpl(sp);
        this.offset = new ConstTpl(off);
        this.size = new ConstTpl(sz);
        this.unnamed_flag = false;
    }

    public VarnodeTpl(Location location, VarnodeTpl vn) {
        this.location = location;
        this.space = new ConstTpl(vn.space);
        this.offset = new ConstTpl(vn.offset);
        this.size = new ConstTpl(vn.size);
        this.unnamed_flag = vn.unnamed_flag;
    }

    public VarnodeTpl(Location location) {
        this.location = location;
        this.unnamed_flag = false;
        this.space = new ConstTpl();
        this.offset = new ConstTpl();
        this.size = new ConstTpl();
    }

    public boolean isLocalTemp() {
        if (this.space.getType() != ConstTpl.const_type.spaceid) {
            return false;
        }
        return this.space.getSpace().getType() == spacetype.IPTR_INTERNAL;
    }

    public int transfer(VectorSTL<HandleTpl> params) {
        boolean doesOffsetPlus = false;
        int handleIndex = 0;
        int plus = 0;
        if (this.offset.getType() == ConstTpl.const_type.handle && this.offset.getSelect() == ConstTpl.v_field.v_offset_plus) {
            handleIndex = this.offset.getHandleIndex();
            plus = (int)this.offset.getReal();
            doesOffsetPlus = true;
        }
        this.space.transfer(params);
        this.offset.transfer(params);
        this.size.transfer(params);
        if (doesOffsetPlus) {
            if (this.isLocalTemp()) {
                return plus;
            }
            if (((HandleTpl)params.get(handleIndex)).getSize().isZero()) {
                return plus;
            }
        }
        return -1;
    }

    public void changeHandleIndex(VectorSTL<Integer> handmap) {
        this.space.changeHandleIndex(handmap);
        this.offset.changeHandleIndex(handmap);
        this.size.changeHandleIndex(handmap);
    }

    public boolean adjustTruncation(int sz, boolean isbigendian) {
        int byteoffset;
        if (this.size.getType() != ConstTpl.const_type.real) {
            return false;
        }
        int numbytes = (int)this.size.getReal();
        if (numbytes + (byteoffset = (int)this.offset.getReal()) > sz) {
            return false;
        }
        long val = byteoffset;
        val <<= 16;
        val = isbigendian ? (val |= (long)(sz - (numbytes + byteoffset))) : (val |= (long)byteoffset);
        this.offset = new ConstTpl(ConstTpl.const_type.handle, this.offset.getHandleIndex(), ConstTpl.v_field.v_offset_plus, val);
        return true;
    }

    public void saveXml(PrintStream s) {
        s.append("<varnode_tpl>");
        this.space.saveXml(s);
        this.offset.saveXml(s);
        this.size.saveXml(s);
        s.append("</varnode_tpl>\n");
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos, true);
        this.saveXml(ps);
        ps.flush();
        String result = baos.toString();
        ps.close();
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public void restoreXml(Element el, Translate trans) {
        List list = el.getChildren();
        this.space.restoreXml((Element)list.get(0), trans);
        this.offset.restoreXml((Element)list.get(1), trans);
        this.size.restoreXml((Element)list.get(2), trans);
    }

    public int compareTo(VarnodeTpl op2) {
        int result = this.space.compareTo(op2.space);
        if (result != 0) {
            return result;
        }
        result = this.offset.compareTo(op2.offset);
        if (result != 0) {
            return result;
        }
        return this.size.compareTo(op2.size);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VarnodeTpl)) {
            return false;
        }
        VarnodeTpl o2 = (VarnodeTpl)obj;
        return this.space.equals(o2.space) && this.offset.equals(o2.offset) && this.size.equals(o2.size);
    }
}

