/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.xml;

import generic.stl.ComparableMapSTL;
import generic.stl.MapSTL;
import generic.stl.VectorSTL;
import ghidra.pcodeCPort.translate.XmlError;
import ghidra.util.xml.XmlUtilities;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class DocumentStorage {
    VectorSTL<Document> doclist = new VectorSTL();
    MapSTL<String, Element> tagmap = new ComparableMapSTL();

    public Document parseDocument(InputStream s) throws JDOMException, IOException {
        SAXBuilder builder = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
        Document document = builder.build(s);
        this.doclist.push_back((Object)document);
        return document;
    }

    public Document openDocument(String filename) throws XmlError {
        FileInputStream is = null;
        try {
            is = new FileInputStream(filename);
            Document document = this.parseDocument(is);
            return document;
        }
        catch (Exception e) {
            throw new XmlError("Unable to open xml document " + filename);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void registerTag(Element el) {
        this.tagmap.put((Object)el.getName(), (Object)el);
    }

    public Element getTag(String nm) {
        return (Element)this.tagmap.get((Object)nm);
    }
}

