/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.bookmark;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.bookmark.BookmarkDBAdapter;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.util.EmptyRecordIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.HashSet;

public class BookmarkDBAdapterV3
extends BookmarkDBAdapter {
    static final int TYPE_ID_OFFSET = 48;
    static final int V3_ADDRESS_COL = 0;
    static final int V3_CATEGORY_COL = 1;
    static final int V3_COMMENT_COL = 2;
    static final int VERSION = 3;
    static final Schema V3_SCHEMA = new Schema(3, "ID", new Field[]{LongField.INSTANCE, StringField.INSTANCE, StringField.INSTANCE}, new String[]{"Address", "Category", "Comment"});
    static int[] INDEXED_COLUMNS = new int[]{0, 1};
    private DBHandle dbHandle;
    private Table[] tables;
    private AddressMap addressMap;

    public BookmarkDBAdapterV3(DBHandle handle, boolean create, int[] typeIDs, AddressMap addrMap) throws VersionException, IOException {
        this.addressMap = addrMap;
        this.dbHandle = handle;
        this.tables = typeIDs.length > 0 ? new Table[typeIDs[typeIDs.length - 1] + 1] : new Table[0];
        if (create) {
            for (int i = 0; i < typeIDs.length; ++i) {
                int id = typeIDs[i];
                this.tables[id] = handle.createTable("Bookmarks" + id, V3_SCHEMA, INDEXED_COLUMNS);
            }
        } else {
            Table bmt = handle.getTable("Bookmarks");
            if (bmt != null && bmt.getRecordCount() != 0) {
                throw new VersionException(true);
            }
            if (handle.getTable("Bookmark Types") == null) {
                throw new VersionException(true);
            }
            if (typeIDs.length != 0) {
                for (int i = 0; i < typeIDs.length; ++i) {
                    int id = typeIDs[i];
                    this.tables[id] = handle.getTable("Bookmarks" + id);
                }
                boolean noTables = this.tables[typeIDs[0]] == null;
                int version = noTables ? -1 : this.tables[typeIDs[0]].getSchema().getVersion();
                for (int i = 1; i < typeIDs.length; ++i) {
                    int id = typeIDs[i];
                    if (noTables) {
                        if (this.tables[id] == null) continue;
                        throw new IOException("Missing bookmark table");
                    }
                    if (this.tables[id].getSchema().getVersion() == version) continue;
                    throw new IOException("Inconsistent bookmark table versions");
                }
                if (noTables) {
                    throw new VersionException(true);
                }
                if (version != 3) {
                    throw new VersionException(false);
                }
            }
        }
    }

    private Table getTable(long id) {
        int tableID = (int)(id >> 48);
        if (tableID >= this.tables.length) {
            return null;
        }
        return this.tables[tableID];
    }

    @Override
    DBRecord getRecord(long id) throws IOException {
        Table table = this.getTable(id);
        if (table == null) {
            return null;
        }
        return table.getRecord(id);
    }

    @Override
    RecordIterator getRecordsByTypeAndCategory(int typeID, String category) throws IOException {
        StringField field = new StringField(category);
        return this.getIndexIterator(typeID, 1, (Field)field, (Field)field);
    }

    private RecordIterator getAddressIndexIterator(int typeID, Field fieldStart, boolean forward) throws IOException {
        if (!this.hasTable(typeID)) {
            return new EmptyRecordIterator();
        }
        return forward ? this.tables[typeID].indexIteratorBefore(0, fieldStart) : this.tables[typeID].indexIteratorAfter(0, fieldStart);
    }

    private RecordIterator getIndexIterator(int typeID, int columnIndex, Field fieldStart, Field fieldEnd) throws IOException {
        if (!this.hasTable(typeID)) {
            return new EmptyRecordIterator();
        }
        return this.tables[typeID].indexIterator(columnIndex, fieldStart, fieldEnd, true);
    }

    private RecordIterator getIterator(int typeID) throws IOException {
        if (!this.hasTable(typeID)) {
            return new EmptyRecordIterator();
        }
        return this.tables[typeID].iterator();
    }

    @Override
    RecordIterator getRecordsByType(int typeID) throws IOException {
        return this.getIterator(typeID);
    }

    @Override
    String[] getCategories(int typeID) throws IOException {
        HashSet<String> set = new HashSet<String>();
        RecordIterator it = this.getIterator(typeID);
        while (it.hasNext()) {
            DBRecord rec = it.next();
            String cat = rec.getString(1);
            if (cat == null || cat.length() == 0) continue;
            set.add(cat);
        }
        String[] strings = new String[set.size()];
        return set.toArray(strings);
    }

    @Override
    AddressSetView getBookmarkAddresses(int typeID) throws IOException {
        AddressSet set = new AddressSet();
        RecordIterator recordIter = this.getRecordsByType(typeID);
        while (recordIter.hasNext()) {
            DBRecord rec = recordIter.next();
            Address addr = this.addressMap.decodeAddress(rec.getLongValue(0));
            set.addRange(addr, addr);
        }
        return set;
    }

    @Override
    int getBookmarkCount(int typeID) {
        if (!this.hasTable(typeID)) {
            return 0;
        }
        return this.tables[typeID].getRecordCount();
    }

    @Override
    int getBookmarkCount() {
        int cnt = 0;
        for (int i = 0; i < this.tables.length; ++i) {
            cnt += this.getBookmarkCount(i);
        }
        return cnt;
    }

    @Override
    DBRecord createBookmark(int typeID, String category, long index, String comment) throws IOException {
        if (!this.hasTable(typeID)) {
            return null;
        }
        Table table = this.tables[typeID];
        long nextId = table.getKey() + 1L;
        long id = (long)typeID << 48 | nextId;
        DBRecord rec = V3_SCHEMA.createRecord(id);
        rec.setLongValue(0, index);
        rec.setString(1, category);
        rec.setString(2, comment);
        table.putRecord(rec);
        return rec;
    }

    @Override
    void deleteRecord(long id) throws IOException {
        Table table = this.getTable(id);
        table.deleteRecord(id);
    }

    @Override
    void updateRecord(DBRecord rec) throws IOException {
        Table table = this.getTable(rec.getKey());
        table.putRecord(rec);
    }

    @Override
    RecordIterator getRecordsByTypeAtAddress(int typeID, long address) throws IOException {
        LongField field = new LongField(address);
        return this.getIndexIterator(typeID, 0, (Field)field, (Field)field);
    }

    @Override
    RecordIterator getRecordsByTypeStartingAtAddress(int typeID, long startAddress, boolean forward) throws IOException {
        LongField start = new LongField(startAddress);
        return this.getAddressIndexIterator(typeID, (Field)start, forward);
    }

    @Override
    RecordIterator getRecordsByTypeForAddressRange(int typeID, long startAddr, long endAddr) throws IOException {
        LongField start = new LongField(startAddr);
        LongField end = new LongField(endAddr);
        return this.getIndexIterator(typeID, 0, (Field)start, (Field)end);
    }

    @Override
    void addType(int typeID) throws IOException {
        if (typeID >= this.tables.length) {
            Table[] newTables = new Table[typeID + 1];
            System.arraycopy(this.tables, 0, newTables, 0, this.tables.length);
            this.tables = newTables;
        }
        if (this.tables[typeID] == null) {
            this.tables[typeID] = this.dbHandle.getTable("Bookmarks" + typeID);
            if (this.tables[typeID] == null) {
                this.tables[typeID] = this.dbHandle.createTable("Bookmarks" + typeID, V3_SCHEMA, INDEXED_COLUMNS);
            }
        }
    }

    @Override
    void deleteType(int typeID) throws IOException {
        if (this.tables[typeID] != null) {
            this.dbHandle.deleteTable("Bookmarks" + typeID);
            this.tables[typeID] = null;
        }
    }

    @Override
    public boolean hasTable(int typeID) {
        if (typeID < 0 || typeID >= this.tables.length) {
            return false;
        }
        return this.tables[typeID] != null;
    }

    @Override
    Table getTable(int typeID) {
        if (typeID < 0 || typeID >= this.tables.length) {
            return null;
        }
        return this.tables[typeID];
    }

    @Override
    void reloadTables() {
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i] = this.dbHandle.getTable("Bookmarks" + i);
        }
    }
}

