/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import java.util.Iterator;

public class CommentTypeFilterIterator
implements CodeUnitIterator {
    private CodeUnitIterator it;
    private int commentType;
    private CodeUnit nextCu;

    public CommentTypeFilterIterator(CodeUnitIterator it, int commentType) {
        this.it = it;
        this.commentType = commentType;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.nextCu == null) {
            this.findNext();
        }
        return this.nextCu != null;
    }

    @Override
    public CodeUnit next() {
        if (this.hasNext()) {
            CodeUnit ret = this.nextCu;
            this.nextCu = null;
            return ret;
        }
        return null;
    }

    private void findNext() {
        while (this.it.hasNext()) {
            CodeUnit cu = this.it.next();
            if (cu.getComment(this.commentType) == null) continue;
            this.nextCu = cu;
            break;
        }
    }

    @Override
    public Iterator<CodeUnit> iterator() {
        return this;
    }
}

