/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import ghidra.program.database.data.ParentChildDBAdapterNoTable;
import ghidra.program.database.data.ParentChildDBAdapterV0;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Set;

abstract class ParentChildAdapter {
    static final String PARENT_CHILD_TABLE_NAME = "DT_PARENT_CHILD";

    ParentChildAdapter() {
    }

    static ParentChildAdapter getAdapter(DBHandle handle, int openMode, String tablePrefix) throws VersionException, IOException {
        if (openMode == 0) {
            return new ParentChildDBAdapterV0(handle, tablePrefix, true);
        }
        try {
            return new ParentChildDBAdapterV0(handle, tablePrefix, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            ParentChildAdapter adapter = ParentChildAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = ParentChildAdapter.upgrade(handle, adapter, tablePrefix);
            }
            return adapter;
        }
    }

    private static ParentChildAdapter findReadOnlyAdapter(DBHandle handle) {
        return new ParentChildDBAdapterNoTable(handle);
    }

    private static ParentChildAdapter upgrade(DBHandle handle, ParentChildAdapter oldAdapter, String tablePrefix) throws VersionException, IOException {
        ParentChildDBAdapterV0 adapter = new ParentChildDBAdapterV0(handle, tablePrefix, true);
        adapter.setNeedsInitializing();
        return adapter;
    }

    abstract boolean needsInitializing();

    abstract void createRecord(long var1, long var3) throws IOException;

    abstract void removeRecord(long var1, long var3) throws IOException;

    abstract Set<Long> getParentIds(long var1) throws IOException;

    abstract void removeAllRecordsForParent(long var1) throws IOException;

    abstract void removeAllRecordsForChild(long var1) throws IOException;
}

