/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.RecordTranslator;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.data.PointerDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class PointerDBAdapterV0
extends PointerDBAdapter {
    static final int VERSION = 0;
    static final int V0_PTR_DTD_COL_ = 0;
    static final int V0_PTR_SIZE_COL = 1;
    private Table table;

    PointerDBAdapterV0(DBHandle handle) throws VersionException {
        this.table = handle.getTable("Pointers");
        if (this.table == null) {
            throw new VersionException("Missing Table: Pointers");
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException("Expected version 0 for table Pointers but got " + this.table.getSchema().getVersion());
        }
    }

    @Override
    DBRecord createRecord(long dataTypeID, long categoryID, int length) throws IOException {
        throw new UnsupportedOperationException("Cannot update Version 0");
    }

    @Override
    DBRecord getRecord(long pointerID) throws IOException {
        return this.translateRecord(this.table.getRecord(pointerID));
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.table.iterator(), (RecordTranslator)this);
    }

    @Override
    boolean removeRecord(long pointerID) throws IOException {
        throw new UnsupportedOperationException("Cannot update Version 0");
    }

    @Override
    void updateRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException("Cannot update Version 0");
    }

    @Override
    Field[] getRecordIdsInCategory(long categoryID) throws IOException {
        return Field.EMPTY_ARRAY;
    }

    public DBRecord translateRecord(DBRecord oldRec) {
        if (oldRec == null) {
            return null;
        }
        DBRecord rec = PointerDBAdapter.SCHEMA.createRecord(oldRec.getKey());
        rec.setLongValue(0, oldRec.getLongValue(0));
        rec.setLongValue(1, 0L);
        rec.setByteValue(2, (byte)-1);
        return rec;
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Pointers");
    }
}

