/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

public enum GenericCallingConvention {
    unknown(""),
    stdcall("__stdcall"),
    cdecl("__cdecl"),
    fastcall("__fastcall"),
    thiscall("__thiscall"),
    vectorcall("__vectorcall");

    private final String declarationName;

    private GenericCallingConvention(String declarationName) {
        this.declarationName = declarationName;
    }

    public String getDeclarationName() {
        return this.declarationName;
    }

    public String toString() {
        return this.declarationName;
    }

    public static GenericCallingConvention getGenericCallingConvention(String callingConvention) {
        for (GenericCallingConvention value : GenericCallingConvention.values()) {
            if (!value.name().equalsIgnoreCase(callingConvention)) continue;
            return value;
        }
        return unknown;
    }

    public static GenericCallingConvention get(int ordinal) {
        GenericCallingConvention[] values = GenericCallingConvention.values();
        if (ordinal >= 0 && ordinal < values.length) {
            return values[ordinal];
        }
        return unknown;
    }
}

