/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.AbstractDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.mem.MemBuffer;
import javax.help.UnsupportedOperationException;

public class PartialUnion
extends AbstractDataType {
    private DataType unionDataType;
    private int offset;
    private int size;

    PartialUnion(DataTypeManager dtm, DataType parent, int off, int sz) {
        super(CategoryPath.ROOT, "partialunion", dtm);
        this.unionDataType = parent;
        this.offset = off;
        this.size = sz;
    }

    public DataType getParent() {
        return this.unionDataType;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        throw new UnsupportedOperationException("may not be cloned");
    }

    @Override
    public int getLength() {
        return this.size;
    }

    @Override
    public int getAlignedLength() {
        return this.getLength();
    }

    @Override
    public String getDescription() {
        return "Partial Union (internal)";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return this.unionDataType.getSettingsDefinitions();
    }

    @Override
    public Settings getDefaultSettings() {
        return this.unionDataType.getDefaultSettings();
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        throw new UnsupportedOperationException("may not be copied");
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return this.unionDataType.getValueClass(settings);
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == null || !(dt instanceof PartialUnion)) {
            return false;
        }
        PartialUnion op = (PartialUnion)dt;
        if (this.offset != op.offset || this.size != op.size) {
            return false;
        }
        return this.unionDataType.isEquivalent(op.unionDataType);
    }

    @Override
    public int getAlignment() {
        return 0;
    }

    public DataType getStrippedDataType() {
        return Undefined.getUndefinedDataType(this.size);
    }
}

