/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.dbgeng;

import agent.dbgeng.dbgeng.DebugBreakpoint;
import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugExceptionRecord64;
import agent.dbgeng.dbgeng.DebugModuleInfo;
import agent.dbgeng.dbgeng.DebugProcessInfo;
import agent.dbgeng.dbgeng.DebugThreadInfo;
import ghidra.comm.util.BitmaskSet;
import ghidra.comm.util.BitmaskUniverse;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public interface DebugEventCallbacks {
    public BitmaskSet<DebugEvent> getInterestMask();

    @ForInterest(value=DebugEvent.BREAKPOINT)
    public DebugClient.DebugStatus breakpoint(DebugBreakpoint var1);

    @ForInterest(value=DebugEvent.EXCEPTION)
    public DebugClient.DebugStatus exception(DebugExceptionRecord64 var1, boolean var2);

    @ForInterest(value=DebugEvent.CREATE_THREAD)
    public DebugClient.DebugStatus createThread(DebugThreadInfo var1);

    @ForInterest(value=DebugEvent.EXIT_THREAD)
    public DebugClient.DebugStatus exitThread(int var1);

    @ForInterest(value=DebugEvent.CREATE_PROCESS)
    public DebugClient.DebugStatus createProcess(DebugProcessInfo var1);

    @ForInterest(value=DebugEvent.EXIT_PROCESS)
    public DebugClient.DebugStatus exitProcess(int var1);

    @ForInterest(value=DebugEvent.LOAD_MODULE)
    public DebugClient.DebugStatus loadModule(DebugModuleInfo var1);

    @ForInterest(value=DebugEvent.UNLOAD_MODULE)
    public DebugClient.DebugStatus unloadModule(String var1, long var2);

    @ForInterest(value=DebugEvent.SYSTEM_ERROR)
    public DebugClient.DebugStatus systemError(int var1, int var2);

    @ForInterest(value=DebugEvent.SESSION_STATUS)
    public DebugClient.DebugStatus sessionStatus(DebugClient.SessionStatus var1);

    @ForInterest(value=DebugEvent.CHANGE_DEBUGEE_STATE)
    public DebugClient.DebugStatus changeDebuggeeState(BitmaskSet<DebugClient.ChangeDebuggeeState> var1, long var2);

    @ForInterest(value=DebugEvent.CHANGE_ENGINE_STATE)
    public DebugClient.DebugStatus changeEngineState(BitmaskSet<DebugClient.ChangeEngineState> var1, long var2);

    @ForInterest(value=DebugEvent.CHANGE_SYMBOL_STATE)
    public DebugClient.DebugStatus changeSymbolState(BitmaskSet<DebugClient.ChangeSymbolState> var1, long var2);

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ForInterest {
        public DebugEvent value();
    }

    public static enum DebugEvent implements BitmaskUniverse
    {
        BREAKPOINT(1),
        EXCEPTION(2),
        CREATE_THREAD(4),
        EXIT_THREAD(8),
        CREATE_PROCESS(16),
        EXIT_PROCESS(32),
        LOAD_MODULE(64),
        UNLOAD_MODULE(128),
        SYSTEM_ERROR(256),
        SESSION_STATUS(512),
        CHANGE_DEBUGEE_STATE(1024),
        CHANGE_ENGINE_STATE(2048),
        CHANGE_SYMBOL_STATE(4096);

        private final int mask;

        private DebugEvent(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }
}

