/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.iface1;

import agent.dbgeng.model.iface1.DbgModelSelectableObject;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import ghidra.async.AsyncUtils;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface DbgModelTargetFocusScope
extends DbgModelTargetObject,
TargetFocusScope {
    public DbgModelSelectableObject getFocus();

    public boolean setFocus(DbgModelSelectableObject var1);

    default public CompletableFuture<Void> requestFocus(TargetObject obj) {
        return this.getModel().gateFuture(this.getManager().requestFocus(this, obj));
    }

    default public CompletableFuture<Void> doRequestFocus(TargetObject obj) {
        if (this.getManager().isWaiting()) {
            return AsyncUtils.NIL;
        }
        this.getModel().assertMine(TargetObject.class, obj);
        if (obj.equals((Object)this.getFocus())) {
            return AsyncUtils.NIL;
        }
        if (!PathUtils.isAncestor((List)this.getPath(), (List)obj.getPath())) {
            throw new DebuggerIllegalArgumentException("Can only focus a successor of the scope");
        }
        TargetObject cur = obj;
        while (cur != null) {
            if (cur instanceof DbgModelSelectableObject) {
                DbgModelSelectableObject sel = (DbgModelSelectableObject)cur;
                this.setFocus(sel);
                return AsyncUtils.NIL;
            }
            if (cur instanceof DbgModelTargetObject) {
                DbgModelTargetObject def = (DbgModelTargetObject)cur;
                cur = def.getParent();
                continue;
            }
            throw new AssertionError();
        }
        return AsyncUtils.NIL;
    }
}

