/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.duallisting;

import docking.dnd.DragGestureAdapter;
import docking.dnd.DragSrcAdapter;
import docking.dnd.Draggable;
import docking.dnd.DropTgtAdapter;
import docking.dnd.Droppable;
import ghidra.app.util.viewer.listingpanel.ListingCodeComparisonPanel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemDestinationAddressEditStatus;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.gui.duallisting.VTMarkupItemTransferable;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.task.ApplyMarkupAtDestinationAddressTask;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;

public class VTDualListingDragNDropHandler
implements Draggable,
Droppable {
    private final int SOURCE = 0;
    private final int DESTINATION = 1;
    private ListingPanel[] listingPanels = new ListingPanel[2];
    private VTController controller;
    ListingCodeComparisonPanel dualListingPanel;
    private DragSource dragSource;
    private DragGestureAdapter dragGestureAdapter;
    private DragSrcAdapter dragSourceAdapter;
    private int dragAction = 2;
    private DropTarget dropTarget;
    private DropTgtAdapter dropTargetAdapter;
    private DataFlavor[] acceptableFlavors;

    public VTDualListingDragNDropHandler(VTController controller, ListingCodeComparisonPanel dualListingPanel) {
        this.controller = controller;
        this.dualListingPanel = dualListingPanel;
        this.listingPanels[0] = dualListingPanel.getLeftPanel();
        this.listingPanels[1] = dualListingPanel.getRightPanel();
        this.setUpDragDrop();
    }

    private void setUpDragDrop() {
        this.setUpDrop();
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragGestureAdapter = new DragGestureAdapter((Draggable)this);
        this.dragSourceAdapter = new DragSrcAdapter((Draggable)this);
        this.dragSource.createDefaultDragGestureRecognizer((Component)this.listingPanels[0].getFieldPanel(), this.dragAction, (DragGestureListener)this.dragGestureAdapter);
    }

    private void setUpDrop() {
        this.setAcceptableFlavors();
        this.dropTargetAdapter = new DropTgtAdapter((Droppable)this, 3, this.acceptableFlavors);
        this.dropTarget = new DropTarget((Component)this.listingPanels[1].getFieldPanel(), 3, (DropTargetListener)this.dropTargetAdapter, true);
        this.dropTarget.setActive(true);
    }

    private void setAcceptableFlavors() {
        this.acceptableFlavors = new DataFlavor[]{VTMarkupItemTransferable.localMarkupItemFlavor};
    }

    public int getDragAction() {
        return this.dragAction;
    }

    public DragSourceListener getDragSourceListener() {
        return this.dragSourceAdapter;
    }

    public boolean isStartDragOk(DragGestureEvent e) {
        if (!this.listingPanels[0].isStartDragOk()) {
            return false;
        }
        Point p = e.getDragOrigin();
        ProgramLocation programLocation = this.listingPanels[0].getProgramLocation(p);
        VTMarkupItem markupItem = this.controller.getCurrentMarkupForLocation(programLocation, this.dualListingPanel.getLeftProgram());
        if (markupItem == null) {
            return false;
        }
        if (markupItem.canApply()) {
            return true;
        }
        VTMarkupItemDestinationAddressEditStatus status = markupItem.getDestinationAddressEditStatus();
        return status == VTMarkupItemDestinationAddressEditStatus.EDITABLE;
    }

    public void dragCanceled(DragSourceDropEvent event) {
    }

    public Transferable getTransferable(Point p) {
        if (!this.listingPanels[0].contains(p)) {
            return null;
        }
        ProgramLocation programLocation = this.listingPanels[0].getProgramLocation(p);
        VTMarkupItem markupItem = this.controller.getCurrentMarkupForLocation(programLocation, this.dualListingPanel.getLeftProgram());
        if (markupItem == null) {
            return null;
        }
        return new VTMarkupItemTransferable(markupItem);
    }

    public void dragUnderFeedback(boolean ok, DropTargetDragEvent e) {
    }

    public void undoDragUnderFeedback() {
    }

    public boolean isDropOk(DropTargetDragEvent e) {
        return true;
    }

    public void add(Object obj, DropTargetDropEvent event, DataFlavor f) {
        Point p;
        ProgramLocation loc;
        VTMarkupItem markupItem = (VTMarkupItem)obj;
        VTMarkupType markupType = markupItem.getMarkupType();
        Address newDestinationAddress = markupType.getAddress(loc = this.listingPanels[1].getProgramLocation(p = event.getLocation()), this.dualListingPanel.getRightProgram());
        if (newDestinationAddress == null) {
            Msg.showInfo(this.getClass(), (Component)this.dualListingPanel, (String)"Invalid Drop Location", (Object)(markupType.getDisplayName() + " was not dropped at a valid location."));
            return;
        }
        if (markupItem.getStatus() == VTMarkupItemStatus.SAME && SystemUtilities.isEqual((Object)markupItem.getDestinationAddress(), (Object)newDestinationAddress)) {
            Msg.showInfo(this.getClass(), (Component)this.dualListingPanel, (String)"Already The Same", (Object)(markupType.getDisplayName() + " was dropped at its expected\ndestination where the value is already the same."));
            return;
        }
        ArrayList<VTMarkupItem> arrayList = new ArrayList<VTMarkupItem>();
        arrayList.add(markupItem);
        ApplyMarkupAtDestinationAddressTask task = new ApplyMarkupAtDestinationAddressTask(this.controller.getSession(), arrayList, newDestinationAddress, this.controller.getOptions());
        this.controller.runVTTask(task);
    }

    public void move() {
    }
}

