/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.editors;

import docking.widgets.label.GDLabel;
import docking.widgets.list.GListCellRenderer;
import generic.theme.GIcon;
import ghidra.feature.vt.gui.editors.TagEditorDialog;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class TagEditorRenderer
extends GListCellRenderer<TagEditorDialog.TagState> {
    private static final Icon NEW_TAG_ICON = new GIcon("icon.version.tracking.tag.status.new");
    private static final Icon DELETED_TAG_ICON = new GIcon("icon.version.tracking.tag.status.deleted");
    private static final Icon EXISTING_TAG_ICON = new GIcon("icon.version.tracking.tag.status.existing");
    private static final Icon UNDO_ICON = new GIcon("icon.version.tracking.tag.button.undo");
    private final JList<TagEditorDialog.TagState> list;
    private final TagEditorDialog.TagStateListModel listModel;
    private JPanel panel;
    private JLabel tagIconLabel = new GDLabel();
    private RemoveStateButton undoButton;
    private MouseAdapter mouseForwarder;

    TagEditorRenderer(final JList<TagEditorDialog.TagState> list, TagEditorDialog.TagStateListModel listModel) {
        this.list = list;
        this.listModel = listModel;
        this.mouseForwarder = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                int x = event.getX();
                int y = event.getY();
                Component hoveredComponent = SwingUtilities.getDeepestComponentAt(event.getComponent(), x, y);
                if (hoveredComponent == null) {
                    return;
                }
                this.updateButton(hoveredComponent, true);
                list.repaint();
            }

            @Override
            public void mouseExited(MouseEvent event) {
                int x = event.getX();
                int y = event.getY();
                Component hoveredComponent = SwingUtilities.getDeepestComponentAt(event.getComponent(), x, y);
                this.updateButton(hoveredComponent, false);
                list.repaint();
            }

            @Override
            public void mousePressed(MouseEvent event) {
                int x = event.getX();
                int y = event.getY();
                Component componentSource = event.getComponent();
                Component clickedComponent = SwingUtilities.getDeepestComponentAt(componentSource, x, y);
                if (clickedComponent == null) {
                    return;
                }
                this.updateButton(clickedComponent, true);
                list.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                int x = event.getX();
                int y = event.getY();
                Component componentSource = event.getComponent();
                Component clickedComponent = SwingUtilities.getDeepestComponentAt(componentSource, x, y);
                if (clickedComponent == null) {
                    return;
                }
                this.updateButton(clickedComponent, false);
                list.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                int x = event.getX();
                int y = event.getY();
                Component componentSource = event.getComponent();
                Component clickedComponent = SwingUtilities.getDeepestComponentAt(componentSource, x, y);
                if (clickedComponent == null || componentSource == clickedComponent) {
                    return;
                }
                MouseEvent newEvent = new MouseEvent(clickedComponent, event.getID(), event.getWhen(), event.getModifiers(), x, y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), event.getButton());
                clickedComponent.dispatchEvent(newEvent);
                list.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                int x = event.getX();
                int y = event.getY();
                Component hoveredComponent = SwingUtilities.getDeepestComponentAt(event.getComponent(), x, y);
                if (hoveredComponent == null) {
                    return;
                }
                this.updateButton(hoveredComponent, false);
                list.repaint();
            }

            public void updateButton(Component mousedComponent, boolean pressed) {
                Component component = mousedComponent;
                if (component == TagEditorRenderer.this.undoButton) {
                    TagEditorRenderer.this.undoButton.getTagState().setMousePressed(pressed);
                    list.repaint();
                }
                if (component == null) {
                    TagEditorRenderer.this.undoButton.getTagState().setMousePressed(false);
                    list.repaint();
                }
            }
        };
    }

    protected String getItemText(TagEditorDialog.TagState value) {
        return value.getTagName();
    }

    public Component getListCellRendererComponent(JList<? extends TagEditorDialog.TagState> jList, TagEditorDialog.TagState state, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel renderer = (JLabel)super.getListCellRendererComponent(jList, (Object)state, index, isSelected, cellHasFocus);
        this.initializePanel(renderer);
        this.tagIconLabel.setIcon(this.getIcon(state));
        if (!isSelected) {
            state.setMousePressed(false);
        }
        this.panel.remove(this.undoButton);
        if (!state.isUnmodified()) {
            this.panel.add(this.undoButton);
            this.panel.validate();
        }
        this.undoButton.setTagState(state);
        return this.panel;
    }

    private Icon getIcon(TagEditorDialog.TagState tagState) {
        switch (tagState.getAction()) {
            case ADD: {
                return NEW_TAG_ICON;
            }
            case DELETE: {
                return DELETED_TAG_ICON;
            }
            case UNMODIFIED: {
                return EXISTING_TAG_ICON;
            }
        }
        throw new AssertException("Unexpected tag action: " + tagState.getAction());
    }

    private JPanel initializePanel(JLabel renderer) {
        if (this.panel == null) {
            JScrollPane scrollPane = new JScrollPane();
            this.panel = new JPanel(){

                @Override
                public String getToolTipText(MouseEvent event) {
                    int x = event.getX();
                    int y = event.getY();
                    Rectangle bounds = TagEditorRenderer.this.undoButton.getBounds();
                    if (x >= bounds.x && x <= bounds.x + bounds.width && y >= bounds.y && y <= bounds.y + bounds.height) {
                        return TagEditorRenderer.this.undoButton.getToolTipText();
                    }
                    return super.getToolTipText();
                }
            };
            this.undoButton = new RemoveStateButton();
            this.undoButton.setBackground(this.list.getBackground());
            this.panel.setBackground(scrollPane.getBackground());
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            this.panel.add(this.tagIconLabel);
            this.panel.add(Box.createHorizontalStrut(5));
            this.panel.add(renderer);
            this.panel.add(Box.createHorizontalGlue());
            this.panel.add(Box.createRigidArea(new Dimension(0, 20)));
            this.panel.add(this.undoButton);
            this.panel.addMouseListener(this.mouseForwarder);
            this.panel.addMouseMotionListener(this.mouseForwarder);
        }
        return this.panel;
    }

    private class RemoveStateButton
    extends JButton {
        private TagEditorDialog.TagState state;

        RemoveStateButton() {
            super(UNDO_ICON);
            this.putClientProperty("JButton.buttonType", "segmentedRoundRect");
            this.putClientProperty("JButton.segmentPosition", "only");
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TagEditorDialog.TagState.Action action = RemoveStateButton.this.state.getAction();
                    if (action == TagEditorDialog.TagState.Action.ADD) {
                        TagEditorRenderer.this.listModel.removeElement(RemoveStateButton.this.state);
                    } else {
                        RemoveStateButton.this.state.restoreState();
                    }
                    TagEditorRenderer.this.list.repaint();
                }
            });
        }

        private void setPressed(boolean hovered) {
            TagEditorRenderer.this.undoButton.getModel().setArmed(hovered);
            TagEditorRenderer.this.undoButton.getModel().setPressed(hovered);
        }

        void setTagState(TagEditorDialog.TagState state) {
            this.state = state;
            TagEditorDialog.TagState.Action action = state.getAction();
            if (action == TagEditorDialog.TagState.Action.ADD) {
                this.setToolTipText("Remove this newly added tag");
            } else {
                this.setToolTipText("Undo mark for deletion");
            }
            this.setPressed(state.isMousePressed());
        }

        TagEditorDialog.TagState getTagState() {
            return this.state;
        }
    }
}

