/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.widgets.conditiontestpanel.ConditionTestListener;
import docking.widgets.conditiontestpanel.ConditionTestPanel;
import docking.widgets.conditiontestpanel.ConditionTester;
import docking.wizard.AbstractMageJPanel;
import docking.wizard.WizardPanelDisplayability;
import docking.wizard.WizardState;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.validator.VTPreconditionValidator;
import ghidra.feature.vt.gui.wizard.VTNewSessionWizardManager;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class PreconditionsPanel
extends AbstractMageJPanel<VTWizardStateKey>
implements Scrollable {
    private static final Dimension DEFAULT_SIZE = new Dimension(650, 480);
    private ConditionTestPanel conditionsTestPanel;
    private boolean testsDone = false;
    private VTNewSessionWizardManager wizardManager;

    public PreconditionsPanel(VTNewSessionWizardManager panelManager) {
        this.wizardManager = panelManager;
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setLayout(new BorderLayout());
        JPanel runButtonPanel = new JPanel();
        runButtonPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        runButtonPanel.setLayout(new FlowLayout());
        JButton runTestsButton = new JButton("Run Precondition Checks");
        runTestsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreconditionsPanel.this.conditionsTestPanel.runTests();
            }
        });
        runButtonPanel.add(runTestsButton);
        JButton skipTestsButton = new JButton("Skip");
        skipTestsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreconditionsPanel.this.conditionsTestPanel.skipTests();
                PreconditionsPanel.this.wizardManager.getWizardManager().next();
            }
        });
        runButtonPanel.add(skipTestsButton);
        this.add(runButtonPanel, "South");
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("VersionTrackingPlugin", "Preconditions_Panel");
    }

    public void addDependencies(WizardState<VTWizardStateKey> state) {
        state.addDependency((Object)VTWizardStateKey.PRECONDITION_CHECKS_RUN, (Object)VTWizardStateKey.SOURCE_PROGRAM_FILE);
        state.addDependency((Object)VTWizardStateKey.PRECONDITION_CHECKS_RUN, (Object)VTWizardStateKey.DESTINATION_PROGRAM_FILE);
        state.addDependency((Object)VTWizardStateKey.HIGHEST_PRECONDITION_STATUS, (Object)VTWizardStateKey.PRECONDITION_CHECKS_RUN);
    }

    public void dispose() {
        if (this.conditionsTestPanel != null) {
            this.conditionsTestPanel.cancel();
        }
    }

    public void enterPanel(WizardState<VTWizardStateKey> state) {
        this.initializeRunState(state);
        if (!this.testsDone) {
            if (this.conditionsTestPanel != null) {
                this.remove((Component)this.conditionsTestPanel);
            }
            this.conditionsTestPanel = this.buildConditionPanel(state);
            this.add((Component)this.conditionsTestPanel, "Center");
        }
    }

    private void initializeRunState(WizardState<VTWizardStateKey> state) {
        Boolean b = (Boolean)state.get((Object)VTWizardStateKey.PRECONDITION_CHECKS_RUN);
        this.testsDone = b == null ? false : b;
    }

    private ConditionTestPanel buildConditionPanel(final WizardState<VTWizardStateKey> state) {
        Program sourceProgram = (Program)state.get((Object)VTWizardStateKey.SOURCE_PROGRAM);
        Program destinationProgram = (Program)state.get((Object)VTWizardStateKey.DESTINATION_PROGRAM);
        VTSession existingResults = (VTSession)state.get((Object)VTWizardStateKey.EXISTING_SESSION);
        List<ConditionTester> list = this.getConditionTests(sourceProgram, destinationProgram, existingResults);
        Collections.sort(list, new ConditionsComparator());
        ConditionTestPanel panel = new ConditionTestPanel(list);
        panel.addListener(new ConditionTestListener(){

            public void testsCompleted() {
                state.put((Object)VTWizardStateKey.PRECONDITION_CHECKS_RUN, (Object)PreconditionsPanel.this.testsDone);
                PreconditionsPanel.this.testsDone();
            }
        });
        return panel;
    }

    private void testsDone() {
        this.testsDone = true;
        this.notifyListenersOfValidityChanged();
        if (this.hasAnyErrorStatus().booleanValue()) {
            Msg.showError(this.getClass(), (Component)((Object)this), (String)"Warning - Serious Precondition failures", (Object)"The precondition checks discovered one or more serious problems. \n\nIf you continue, your version tracking results may be invalid.\nYou should review the errors, cancel this wizard, and correct the problems.");
        }
    }

    private List<ConditionTester> getConditionTests(Program sourceProgram, Program destinationProgram, VTSession existingResults) throws SecurityException {
        ArrayList<ConditionTester> list = new ArrayList<ConditionTester>();
        List vtValidatorClasses = ClassSearcher.getClasses(VTPreconditionValidator.class);
        for (Class validatorClass : vtValidatorClasses) {
            try {
                Constructor ctor = validatorClass.getConstructor(Program.class, Program.class, VTSession.class);
                VTPreconditionValidator validator = (VTPreconditionValidator)ctor.newInstance(sourceProgram, destinationProgram, existingResults);
                list.add(validator);
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("error including VTPreconditionValidator " + validatorClass), (Throwable)e);
            }
        }
        return list;
    }

    public WizardPanelDisplayability getPanelDisplayabilityAndUpdateState(WizardState<VTWizardStateKey> state) {
        this.initializeRunState(state);
        return this.testsDone ? WizardPanelDisplayability.CAN_BE_DISPLAYED : WizardPanelDisplayability.MUST_BE_DISPLAYED;
    }

    public void leavePanel(WizardState<VTWizardStateKey> state) {
        this.updateStateObjectWithPanelInfo(state);
    }

    public void updateStateObjectWithPanelInfo(WizardState<VTWizardStateKey> state) {
        state.put((Object)VTWizardStateKey.PRECONDITION_CHECKS_RUN, (Object)this.testsDone);
        state.put((Object)VTWizardStateKey.HIGHEST_PRECONDITION_STATUS, (Object)this.hasAnyErrorStatus());
    }

    private Boolean hasAnyErrorStatus() {
        return this.conditionsTestPanel.getErrorCount() > 0;
    }

    public String getTitle() {
        return "Precondition Checklist";
    }

    public void initialize() {
    }

    public boolean isValidInformation() {
        return this.testsDone;
    }

    public Dimension getPreferredSize() {
        Dimension superSize = super.getPreferredSize();
        if (superSize.width > PreconditionsPanel.DEFAULT_SIZE.width && superSize.height > PreconditionsPanel.DEFAULT_SIZE.height) {
            return superSize;
        }
        return DEFAULT_SIZE;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 25;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    private class ConditionsComparator
    implements Comparator<ConditionTester> {
        private ConditionsComparator() {
        }

        @Override
        public int compare(ConditionTester o1, ConditionTester o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

