/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.wizard.AbstractMagePanelManager;
import docking.wizard.MagePanel;
import docking.wizard.WizardState;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.wizard.CreateNewSessionTask;
import ghidra.feature.vt.gui.wizard.NewSessionPanel;
import ghidra.feature.vt.gui.wizard.PreconditionsPanel;
import ghidra.feature.vt.gui.wizard.SummaryPanel;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class VTNewSessionWizardManager
extends AbstractMagePanelManager<VTWizardStateKey> {
    private final VTController controller;

    public VTNewSessionWizardManager(VTController controller) {
        super(new WizardState());
        this.controller = controller;
        this.getState().put((Object)VTWizardStateKey.WIZARD_OP_DESCRIPTION, (Object)"New Version Tracking Session");
    }

    public VTNewSessionWizardManager(VTController controller, DomainFile sourceFile, DomainFile destinationFile) {
        this(controller);
        this.getState().put((Object)VTWizardStateKey.SOURCE_PROGRAM_FILE, (Object)sourceFile);
        this.getState().put((Object)VTWizardStateKey.DESTINATION_PROGRAM_FILE, (Object)destinationFile);
    }

    protected List<MagePanel<VTWizardStateKey>> createPanels() {
        ArrayList<MagePanel<VTWizardStateKey>> panels = new ArrayList<MagePanel<VTWizardStateKey>>();
        panels.add((MagePanel<VTWizardStateKey>)new NewSessionPanel(this.controller.getTool()));
        panels.add((MagePanel<VTWizardStateKey>)new PreconditionsPanel(this));
        panels.add((MagePanel<VTWizardStateKey>)new SummaryPanel());
        return panels;
    }

    protected void doFinish() {
        try {
            CreateNewSessionTask task = new CreateNewSessionTask(this.controller, (WizardState<VTWizardStateKey>)this.getState());
            new TaskLauncher((Task)task, (Component)this.getWizardManager().getComponent());
        }
        finally {
            this.getWizardManager().completed(true);
            this.cleanup();
        }
    }

    public void cancel() {
        this.cleanup();
    }

    private void cleanup() {
        List panels = this.getPanels();
        for (MagePanel magePanel : panels) {
            magePanel.dispose();
        }
    }

    public PluginTool getTool() {
        return this.controller.getTool();
    }
}

