/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph;

import ghidra.graph.viewer.PathHighlightMode;

public enum EdgeDisplayType {
    PathsToVertex,
    PathsFromVertex,
    PathsFromToVertex,
    Cycles,
    AllCycles,
    PathsFromVertexToVertex,
    ScopedFlowsFromVertex,
    ScopedFlowsToVertex,
    Off;


    public PathHighlightMode getAsPathHighlightHoverMode() {
        switch (this) {
            case PathsToVertex: {
                return PathHighlightMode.IN;
            }
            case PathsFromVertex: {
                return PathHighlightMode.OUT;
            }
            case PathsFromToVertex: {
                return PathHighlightMode.INOUT;
            }
            case Cycles: {
                return PathHighlightMode.CYCLE;
            }
            case AllCycles: {
                return PathHighlightMode.ALLCYCLE;
            }
            case PathsFromVertexToVertex: {
                return PathHighlightMode.PATH;
            }
            case ScopedFlowsFromVertex: {
                return PathHighlightMode.SCOPED_FORWARD;
            }
            case ScopedFlowsToVertex: {
                return PathHighlightMode.SCOPED_REVERSE;
            }
        }
        return PathHighlightMode.OFF;
    }
}

