/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.copying;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.copying.DebuggerCopyIntoProgramDialog;
import ghidra.app.plugin.core.exporter.ExporterDialog;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceVariableSnapProgramView;

@PluginInfo(shortDescription="Copy and export trace data", description="Provides tool actions for moving data from traces to various destinations.", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={}, eventsProduced={}, servicesRequired={DebuggerStaticMappingService.class, ProgramManager.class}, servicesProvided={})
public class DebuggerCopyActionsPlugin
extends AbstractDebuggerPlugin {
    protected DebuggerCopyIntoProgramDialog copyDialog;
    protected DockingAction actionExportView;
    protected DockingAction actionCopyIntoCurrentProgram;
    protected DockingAction actionCopyIntoNewProgram;
    @AutoServiceConsumed
    private ProgramManager programManager;
    @AutoServiceConsumed
    private DebuggerStaticMappingService mappingService;
    @AutoServiceConsumed
    private DebuggerModelService modelService;

    protected static ProgramSelection getSelectionFromContext(ActionContext context) {
        if (!(context instanceof ProgramLocationActionContext)) {
            return null;
        }
        ProgramLocationActionContext ctx = (ProgramLocationActionContext)context;
        return ctx.hasSelection() ? ctx.getSelection() : null;
    }

    public DebuggerCopyActionsPlugin(PluginTool tool) {
        super(tool);
        this.copyDialog = new DebuggerCopyIntoProgramDialog(tool);
        this.createActions();
    }

    protected void dispose() {
        super.dispose();
        this.copyDialog.dispose();
    }

    protected void createActions() {
        this.actionExportView = (DockingAction)((ActionBuilder)DebuggerResources.ExportTraceViewAction.builder(this).enabled(false)).withContext(ProgramLocationActionContext.class).enabledWhen(this::checkTrace).onAction(this::activatedExportView).buildAndInstall((Tool)this.tool);
        this.actionCopyIntoCurrentProgram = (DockingAction)((ActionBuilder)DebuggerResources.CopyIntoCurrentProgramAction.builder(this).enabled(false)).withContext(ProgramLocationActionContext.class).enabledWhen(ctx -> this.checkTraceSelection((ProgramLocationActionContext)ctx) && this.programManager.getCurrentProgram() != null).onAction(this::activatedCopyIntoCurrentProgram).buildAndInstall((Tool)this.tool);
        this.actionCopyIntoNewProgram = (DockingAction)((ActionBuilder)DebuggerResources.CopyIntoNewProgramAction.builder(this).enabled(false)).withContext(ProgramLocationActionContext.class).enabledWhen(this::checkTraceSelection).onAction(this::activatedCopyIntoNewProgram).buildAndInstall((Tool)this.tool);
    }

    protected boolean checkTrace(ProgramLocationActionContext context) {
        return context.getProgram() instanceof TraceProgramView;
    }

    protected boolean checkTraceSelection(ProgramLocationActionContext context) {
        return this.checkTrace(context) && context.hasSelection();
    }

    protected void activatedExportView(ProgramLocationActionContext context) {
        if (!this.checkTrace(context)) {
            return;
        }
        TraceProgramView view = (TraceProgramView)context.getProgram();
        TraceProgramView fixed = view instanceof TraceVariableSnapProgramView ? view.getTrace().getFixedProgramView(view.getSnap()) : view;
        ExporterDialog dialog = new ExporterDialog(this.tool, fixed.getDomainFile(), (DomainObject)fixed, DebuggerCopyActionsPlugin.getSelectionFromContext((ActionContext)context));
        this.tool.showDialog((DialogComponentProvider)dialog);
    }

    protected void activatedCopyIntoCurrentProgram(ProgramLocationActionContext context) {
        if (!this.checkTraceSelection(context)) {
            return;
        }
        this.copyDialog.setSource((TraceProgramView)context.getProgram(), (AddressSetView)context.getSelection());
        this.copyDialog.setProgramManager(this.programManager);
        this.copyDialog.setStaticMappingService(this.mappingService);
        this.copyDialog.setModelService(this.modelService);
        this.copyDialog.setDestination(this.programManager.getCurrentProgram());
        this.copyDialog.reset();
        this.copyDialog.setStatusText("");
        this.tool.showDialog((DialogComponentProvider)this.copyDialog);
    }

    protected void activatedCopyIntoNewProgram(ProgramLocationActionContext context) {
        if (!this.checkTraceSelection(context)) {
            return;
        }
        this.copyDialog.setSource((TraceProgramView)context.getProgram(), (AddressSetView)context.getSelection());
        this.copyDialog.setProgramManager(this.programManager);
        this.copyDialog.setStaticMappingService(this.mappingService);
        this.copyDialog.setModelService(this.modelService);
        this.copyDialog.setDestination(this.copyDialog.NEW_PROGRAM);
        this.copyDialog.reset();
        this.copyDialog.setStatusText("");
        this.tool.showDialog((DialogComponentProvider)this.copyDialog);
    }
}

