/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import db.Transaction;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.memory.TraceMemoryRegion;

public class RegionRow {
    private final TraceMemoryRegion region;

    public RegionRow(TraceMemoryRegion region) {
        this.region = region;
    }

    public TraceMemoryRegion getRegion() {
        return this.region;
    }

    public void setName(String name) {
        try (Transaction tx = this.region.getTrace().openTransaction("Rename region");){
            this.region.setName(name);
        }
    }

    public String getName() {
        return this.region.getName();
    }

    public Lifespan getLifespan() {
        return this.region.getLifespan();
    }

    public long getCreatedSnap() {
        return this.region.getCreationSnap();
    }

    public String getDestroyedSnap() {
        long snap = this.region.getDestructionSnap();
        return snap == Long.MAX_VALUE ? "" : Long.toString(snap);
    }

    public AddressRange getRange() {
        return this.region.getRange();
    }

    public Address getMaxAddress() {
        return this.region.getMaxAddress();
    }

    public Address getMinAddress() {
        return this.region.getMinAddress();
    }

    public long getLength() {
        return this.region.getLength();
    }

    public void setRead(boolean read) {
        try (Transaction tx = this.region.getTrace().openTransaction("Toggle region read flag");){
            this.region.setRead(read);
        }
    }

    public boolean isRead() {
        return this.region.isRead();
    }

    public void setWrite(boolean write) {
        try (Transaction tx = this.region.getTrace().openTransaction("Toggle region write flag");){
            this.region.setWrite(write);
        }
    }

    public boolean isWrite() {
        return this.region.isWrite();
    }

    public void setExecute(boolean execute) {
        try (Transaction tx = this.region.getTrace().openTransaction("Toggle region execute flag");){
            this.region.setExecute(execute);
        }
    }

    public boolean isExecute() {
        return this.region.isExecute();
    }

    public void setVolatile(boolean vol) {
        try (Transaction tx = this.region.getTrace().openTransaction("Toggle region volatile flag");){
            this.region.setVolatile(vol);
        }
    }

    public boolean isVolatile() {
        return this.region.isVolatile();
    }
}

