/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memview;

import docking.ComponentProvider;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.gui.memview.DebuggerMemviewTraceListener;
import ghidra.app.plugin.core.debug.gui.memview.MemoryBox;
import ghidra.app.plugin.core.debug.gui.memview.MemviewProvider;
import ghidra.app.plugin.core.debug.gui.memview.MemviewService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import java.util.List;

@PluginInfo(shortDescription="Displays memory vs time", description="Provides visualiztion/navigation across time/address axes", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class}, servicesProvided={MemviewService.class})
public class DebuggerMemviewPlugin
extends AbstractDebuggerPlugin
implements MemviewService {
    protected MemviewProvider provider;
    private DebuggerMemviewTraceListener listener;

    public DebuggerMemviewPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected void init() {
        this.provider = new MemviewProvider(this.getTool(), this);
        this.listener = new DebuggerMemviewTraceListener(this.provider);
        super.init();
    }

    protected void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this.provider);
        super.dispose();
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
            this.listener.coordinatesActivated(ev.getActiveCoordinates());
        }
    }

    @Override
    public MemviewProvider getProvider() {
        return this.provider;
    }

    public void toggleTrackTrace() {
        this.listener.toggleTrackTrace();
    }

    @Override
    public void setBoxes(List<MemoryBox> boxList) {
        this.provider.setBoxes(boxList);
    }

    @Override
    public void initViews() {
        this.provider.initViews();
    }

    @Override
    public void setProgram(Program program) {
        this.provider.setProgram(program);
    }
}

