/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectPropertyColumn;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.trace.model.target.TraceObject;

public class TraceValueObjectAttributeColumn<T>
extends TraceValueObjectPropertyColumn<T> {
    protected final String attributeName;

    public static Class<?> computeAttributeType(SchemaContext ctx, TargetObjectSchema.AttributeSchema attributeSchema) {
        TargetObjectSchema schema = ctx.getSchema(attributeSchema.getSchema());
        Class type = schema.getType();
        if (type == TargetObject.class) {
            return TraceObject.class;
        }
        if (type == TargetExecutionStateful.TargetExecutionState.class) {
            return String.class;
        }
        if (type == TargetMethod.TargetParameterMap.class) {
            return String.class;
        }
        if (type == TargetAttacher.TargetAttachKindSet.class) {
            return String.class;
        }
        if (type == TargetBreakpointSpecContainer.TargetBreakpointKindSet.class) {
            return String.class;
        }
        if (type == TargetSteppable.TargetStepKindSet.class) {
            return String.class;
        }
        return type;
    }

    public TraceValueObjectAttributeColumn(String attributeName, Class<T> attributeType) {
        super(attributeType);
        this.attributeName = attributeName;
    }

    public String getColumnName() {
        return this.attributeName;
    }

    @Override
    public ObjectTableModel.ValueProperty<T> getProperty(ObjectTableModel.ValueRow row) {
        return row.getAttribute(this.attributeName, this.propertyType);
    }
}

