/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.watch;

import ghidra.docking.settings.BooleanSettingsDefinition;
import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.NumberSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.StringSettingsDefinition;
import ghidra.framework.options.SaveState;
import ghidra.program.model.data.TypeDefSettingsDefinition;

public class SavedSettings {
    private final Settings settings;
    private SaveState state;

    public SavedSettings(Settings settings) {
        this.settings = settings;
        this.setState(this.state);
    }

    public void setState(SaveState state) {
        if (state == null) {
            state = new SaveState("Settings");
        }
        this.state = state;
    }

    public SaveState getState() {
        return this.state;
    }

    public void write(SettingsDefinition[] definitions, Settings defaultSettings) {
        for (SettingsDefinition sd : definitions) {
            if (sd.hasSameValue(this.settings, defaultSettings)) continue;
            if (sd instanceof BooleanSettingsDefinition) {
                BooleanSettingsDefinition bsd = (BooleanSettingsDefinition)sd;
                this.state.putBoolean(sd.getStorageKey(), bsd.getValue(this.settings));
                continue;
            }
            if (sd instanceof EnumSettingsDefinition) {
                EnumSettingsDefinition esd = (EnumSettingsDefinition)sd;
                this.state.putInt(sd.getStorageKey(), esd.getChoice(this.settings));
                continue;
            }
            if (sd instanceof NumberSettingsDefinition) {
                NumberSettingsDefinition nsd = (NumberSettingsDefinition)sd;
                this.state.putLong(sd.getStorageKey(), nsd.getValue(this.settings));
                continue;
            }
            if (sd instanceof StringSettingsDefinition) {
                StringSettingsDefinition ssd = (StringSettingsDefinition)sd;
                this.state.putString(sd.getStorageKey(), ssd.getValue(this.settings));
                continue;
            }
            if (sd instanceof TypeDefSettingsDefinition) {
                TypeDefSettingsDefinition tdsd = (TypeDefSettingsDefinition)sd;
                continue;
            }
            throw new AssertionError();
        }
    }

    public void read(SettingsDefinition[] definitions, Settings defaultSettings) {
        for (SettingsDefinition sd : definitions) {
            if (!this.state.hasValue(sd.getStorageKey())) continue;
            if (sd instanceof BooleanSettingsDefinition) {
                BooleanSettingsDefinition bsd = (BooleanSettingsDefinition)sd;
                bsd.setValue(this.settings, this.state.getBoolean(sd.getStorageKey(), false));
                continue;
            }
            if (sd instanceof EnumSettingsDefinition) {
                EnumSettingsDefinition esd = (EnumSettingsDefinition)sd;
                esd.setChoice(this.settings, this.state.getInt(sd.getStorageKey(), 0));
                continue;
            }
            if (sd instanceof NumberSettingsDefinition) {
                NumberSettingsDefinition nsd = (NumberSettingsDefinition)sd;
                nsd.setValue(this.settings, this.state.getLong(sd.getStorageKey(), 0L));
                continue;
            }
            if (sd instanceof StringSettingsDefinition) {
                StringSettingsDefinition ssd = (StringSettingsDefinition)sd;
                ssd.setValue(this.settings, this.state.getString(sd.getStorageKey(), null));
                continue;
            }
            if (sd instanceof TypeDefSettingsDefinition) {
                TypeDefSettingsDefinition tdsd = (TypeDefSettingsDefinition)sd;
                continue;
            }
            throw new AssertionError();
        }
    }
}

