/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.gdb;

import ghidra.app.plugin.core.debug.service.model.launch.AbstractDebuggerProgramLaunchOffer;
import ghidra.app.plugin.core.debug.service.model.launch.AbstractDebuggerProgramLaunchOpinion;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOffer;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GdbDebuggerProgramLaunchOpinion
extends AbstractDebuggerProgramLaunchOpinion {
    protected static final List<Class<? extends DebuggerProgramLaunchOffer>> OFFER_CLASSES = List.of(InVmGdbDebuggerProgramLaunchOffer.class, GadpGdbDebuggerProgramLaunchOffer.class, SshGdbDebuggerProgramLaunchOffer.class);

    @Override
    protected Collection<Class<? extends DebuggerProgramLaunchOffer>> getOfferClasses() {
        return OFFER_CLASSES;
    }

    @AbstractDebuggerProgramLaunchOpinion.FactoryClass(value="agent.gdb.GdbInJvmDebuggerModelFactory")
    protected static class InVmGdbDebuggerProgramLaunchOffer
    extends AbstractGdbDebuggerProgramLaunchOffer {
        public InVmGdbDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "IN-VM GDB";
        }

        @Override
        public String getMenuTitle() {
            return "in GDB locally IN-VM";
        }
    }

    @AbstractDebuggerProgramLaunchOpinion.FactoryClass(value="agent.gdb.gadp.GdbGadpDebuggerModelFactory")
    protected static class GadpGdbDebuggerProgramLaunchOffer
    extends AbstractGdbDebuggerProgramLaunchOffer {
        public GadpGdbDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "GADP GDB";
        }

        @Override
        public String getMenuTitle() {
            return "in GDB locally via GADP";
        }
    }

    @AbstractDebuggerProgramLaunchOpinion.FactoryClass(value="agent.gdb.GdbOverSshDebuggerModelFactory")
    protected static class SshGdbDebuggerProgramLaunchOffer
    extends AbstractGdbDebuggerProgramLaunchOffer {
        public SshGdbDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "SSH GDB";
        }

        @Override
        public String getQuickTitle() {
            Map opts = this.factory.getOptions();
            return String.format("in GDB via ssh:%s@%s", ((ConfigurableFactory.Property)opts.get("SSH username")).getValue(), ((ConfigurableFactory.Property)opts.get("SSH hostname")).getValue());
        }

        @Override
        public String getMenuTitle() {
            return "in GDB via ssh";
        }
    }

    protected static abstract class AbstractGdbDebuggerProgramLaunchOffer
    extends AbstractDebuggerProgramLaunchOffer {
        public AbstractGdbDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        protected List<String> getLauncherPath() {
            return PathUtils.parse((String)"Inferiors[1]");
        }
    }
}

