/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.workflow;

import db.Transaction;
import docking.DockingWindowManager;
import docking.Tool;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformMapper;
import ghidra.app.plugin.core.debug.mapping.DisassemblyResult;
import ghidra.app.plugin.core.debug.service.workflow.AbstractMultiToolTraceListener;
import ghidra.app.plugin.core.debug.service.workflow.DebuggerWorkflowServicePlugin;
import ghidra.app.plugin.core.debug.service.workflow.MultiToolTraceListenerManager;
import ghidra.app.plugin.core.debug.workflow.DisassemblyInject;
import ghidra.app.services.DebuggerBot;
import ghidra.app.services.DebuggerBotInfo;
import ghidra.app.services.DebuggerPlatformService;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.listing.TraceCodeManager;
import ghidra.trace.model.listing.TraceCodeSpace;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.stack.TraceStackManager;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeType;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.trace.util.TraceViewportSpanIterator;
import ghidra.util.IntersectionAddressSetView;
import ghidra.util.Msg;
import ghidra.util.UnionAddressSetView;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;

@DebuggerBotInfo(description="Disassemble memory at the program counter", details="Listens for changes in memory or pc (stack or registers) and disassembles", help=@HelpInfo(anchor="disassemble_at_pc"), enabledByDefault=true)
public class DisassembleAtPcDebuggerBot
implements DebuggerBot {
    private DebuggerWorkflowServicePlugin plugin;
    private final MultiToolTraceListenerManager<ForDisassemblyTraceListener> listeners = new MultiToolTraceListenerManager<ForDisassemblyTraceListener>(x$0 -> new ForDisassemblyTraceListener((Trace)x$0));

    protected void reportError(String error) {
        this.reportError(error, null);
    }

    protected void reportError(String error, Throwable t) {
        for (PluginTool tool : this.plugin.getProxyingPluginTools()) {
            Msg.error((Object)this, (Object)error, (Throwable)t);
            tool.setStatusInfo(error, true);
        }
    }

    protected <T> T findService(Class<T> cls) {
        Collection<PluginTool> proxied = this.plugin.getProxyingPluginTools();
        List all = DockingWindowManager.getAllDockingWindowManagers();
        Collections.reverse(all);
        for (DockingWindowManager dwm : all) {
            Object t;
            Tool tool = dwm.getTool();
            if (!proxied.contains(tool) || (t = tool.getService(cls)) == null) continue;
            return (T)t;
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.plugin != null;
    }

    @Override
    public void enable(DebuggerWorkflowServicePlugin wp) {
        this.plugin = wp;
        this.listeners.enable(wp);
    }

    @Override
    public void disable() {
        this.plugin = null;
        this.listeners.disable();
    }

    @Override
    public void traceOpened(PluginTool tool, Trace trace) {
        this.listeners.traceOpened(tool, trace);
    }

    @Override
    public void traceClosed(PluginTool tool, Trace trace) {
        this.listeners.traceClosed(tool, trace);
    }

    protected class ForDisassemblyTraceListener
    extends AbstractMultiToolTraceListener {
        private final TraceStackManager stackManager;
        private final TraceMemoryManager memoryManager;
        private final TraceCodeManager codeManager;
        private final TraceTimeViewport viewport;
        private final Register pc;
        private final AddressRange pcRange;
        private final Set<DisassemblyInject> injects;
        private final ChangeListener injectsChangeListener;
        private final Deque<Runnable> runQueue;
        private final AsyncDebouncer<Void> runDebouncer;

        public ForDisassemblyTraceListener(Trace trace) {
            super(trace);
            this.injects = new LinkedHashSet<DisassemblyInject>();
            this.injectsChangeListener = e -> this.updateInjects();
            this.runQueue = new LinkedList<Runnable>();
            this.runDebouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 100L);
            this.stackManager = trace.getStackManager();
            this.memoryManager = trace.getMemoryManager();
            this.codeManager = trace.getCodeManager();
            this.viewport = trace.getProgramView().getViewport();
            this.pc = trace.getBaseLanguage().getProgramCounter();
            this.pcRange = this.pc == null ? null : TraceRegisterUtils.rangeForRegister((Register)this.pc);
            ClassSearcher.addChangeListener((ChangeListener)this.injectsChangeListener);
            this.updateInjects();
            this.runDebouncer.addListener(this::processQueue);
            this.listenFor((TraceChangeType)Trace.TraceMemoryBytesChangeType.CHANGED, this::valuesChanged);
            this.listenFor((TraceChangeType)Trace.TraceStackChangeType.CHANGED, this::stackChanged);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateInjects() {
            Set<DisassemblyInject> set = this.injects;
            synchronized (set) {
                this.injects.clear();
                ClassSearcher.getInstances(DisassemblyInject.class).stream().filter(i -> i.isApplicable(this.trace)).sorted(Comparator.comparing(i -> i.getPriority())).forEach(this.injects::add);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queueRunnable(Runnable r) {
            Deque<Runnable> deque = this.runQueue;
            synchronized (deque) {
                this.runQueue.add(r);
            }
            this.runDebouncer.contact(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueue(Void __) {
            try {
                List<Runnable> copy;
                Deque<Runnable> deque = this.runQueue;
                synchronized (deque) {
                    copy = List.copyOf(this.runQueue);
                    this.runQueue.clear();
                }
                for (Runnable r : copy) {
                    r.run();
                }
            }
            catch (Throwable e) {
                Msg.error((Object)((Object)this), (Object)"Error processing queue", (Throwable)e);
            }
        }

        private void valuesChanged(TraceAddressSpace space, TraceAddressSnapRange range, byte[] oldValue, byte[] newValue) {
            if (space.getAddressSpace().isRegisterSpace()) {
                this.registersChanged(space, range);
            } else {
                this.memoryChanged(range);
            }
        }

        private void stackChanged(TraceStack stack, long zero, long snap) {
            this.queueRunnable(() -> this.disassembleStackPcVals(stack, snap, null));
        }

        private long findNonScratchSnap(long snap) {
            if (snap >= 0L) {
                return snap;
            }
            TraceViewportSpanIterator spit = new TraceViewportSpanIterator(this.trace, snap);
            while (spit.hasNext()) {
                Lifespan span = (Lifespan)spit.next();
                if (span.lmax() < 0L) continue;
                return span.lmax();
            }
            return snap;
        }

        private void memoryChanged(TraceAddressSnapRange range) {
            if (!this.viewport.containsAnyUpper(range.getLifespan())) {
                return;
            }
            long pcSnap = this.trace.getProgramView().getSnap();
            long memSnap = range.getY1();
            this.queueRunnable(() -> {
                for (TraceThread thread : this.trace.getThreadManager().getLiveThreads(this.findNonScratchSnap(pcSnap))) {
                    TraceStack stack = this.stackManager.getLatestStack(thread, pcSnap);
                    if (stack != null) {
                        this.disassembleStackPcVals(stack, memSnap, range.getRange());
                        continue;
                    }
                    this.disassembleRegPcVal(thread, 0, pcSnap, memSnap);
                }
            });
        }

        private void registersChanged(TraceAddressSpace space, TraceAddressSnapRange range) {
            this.queueRunnable(() -> {
                long snap;
                if (space.getFrameLevel() != 0) {
                    return;
                }
                if (this.pcRange == null || !range.getRange().intersects(this.pcRange)) {
                    return;
                }
                TraceThread thread = space.getThread();
                if (this.stackManager.getLatestStack(thread, snap = range.getY1().longValue()) != null) {
                    return;
                }
                this.disassembleRegPcVal(thread, space.getFrameLevel(), snap, snap);
            });
        }

        protected void disassembleStackPcVals(TraceStack stack, long snap, AddressRange range) {
            TraceStackFrame frame = stack.getFrame(0, false);
            if (frame == null) {
                return;
            }
            Address pcVal = frame.getProgramCounter(snap);
            if (pcVal == null) {
                return;
            }
            if (range != null && !range.contains(pcVal)) {
                return;
            }
            this.disassemble(pcVal, stack.getThread(), snap);
        }

        protected void disassembleRegPcVal(TraceThread thread, int frameLevel, long pcSnap, long memSnap) {
            Object object;
            if (this.pc == null) {
                return;
            }
            TraceData pcUnit = null;
            try (Transaction tx = this.trace.openTransaction("Disassemble: PC is code pointer");){
                TraceCodeSpace regCode = this.pc.getAddressSpace().isRegisterSpace() ? this.codeManager.getCodeRegisterSpace(thread, frameLevel, true) : this.codeManager.getCodeSpace(this.pc.getAddressSpace(), true);
                AddressSpace space = this.trace.getBaseAddressFactory().getDefaultAddressSpace();
                PointerTypedef type = new PointerTypedef(null, (DataType)VoidDataType.dataType, this.pc.getMinimumByteSize(), null, space);
                try {
                    pcUnit = regCode.definedData().create(Lifespan.nowOn((long)pcSnap), this.pc, (DataType)type);
                }
                catch (CodeUnitInsertionException e) {
                    pcUnit = (TraceData)regCode.definedData().getForRegister(pcSnap, this.pc);
                }
            }
            if (pcUnit != null && (object = pcUnit.getValue()) instanceof Address) {
                Address pcVal = (Address)object;
                this.disassemble(pcVal, thread, memSnap);
            }
        }

        protected Long isKnownRWOrEverKnownRO(Address start, long snap) {
            Map.Entry kent = this.memoryManager.getViewState(snap, start);
            if (kent != null && kent.getValue() == TraceMemoryState.KNOWN) {
                return (Long)kent.getKey();
            }
            Map.Entry mrent = this.memoryManager.getViewMostRecentStateEntry(snap, start);
            if (mrent == null || mrent.getValue() != TraceMemoryState.KNOWN) {
                return null;
            }
            TraceMemoryRegion region = this.memoryManager.getRegionContaining(((TraceAddressSnapRange)mrent.getKey()).getY1().longValue(), start);
            if (region == null || region.isWrite()) {
                return null;
            }
            return ((TraceAddressSnapRange)mrent.getKey()).getY1();
        }

        protected TraceObject getObject(TraceThread thread) {
            if (!(thread instanceof TraceObjectThread)) {
                return null;
            }
            return ((TraceObjectThread)thread).getObject();
        }

        protected void disassemble(final Address start, final TraceThread thread, final long snap) {
            Long knownSnap = this.isKnownRWOrEverKnownRO(start, snap);
            if (knownSnap == null) {
                return;
            }
            long ks = knownSnap;
            if (this.codeManager.definedUnits().containsAddress(ks, start)) {
                return;
            }
            AddressSetView readOnly = this.memoryManager.getRegionsAddressSetWith(ks, r -> !r.isWrite());
            AddressSetView everKnown = this.memoryManager.getAddressesWithState(Lifespan.since((long)ks), s -> s == TraceMemoryState.KNOWN);
            IntersectionAddressSetView roEverKnown = new IntersectionAddressSetView(readOnly, everKnown);
            AddressSetView known = this.memoryManager.getAddressesWithState(ks, s -> s == TraceMemoryState.KNOWN);
            AddressSet disassemblable = new AddressSet((AddressSetView)new UnionAddressSetView(new AddressSetView[]{known, roEverKnown}));
            TraceProgramView view = this.trace.getFixedProgramView(ks);
            BackgroundCommand cmd = new BackgroundCommand("Auto-disassemble", true, true, false, (AddressSetView)disassemblable){
                final /* synthetic */ AddressSetView val$disassemblable;
                {
                    this.val$disassemblable = addressSetView;
                    super(arg0, arg1, arg2, arg3);
                }

                public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
                    try {
                        DebuggerPlatformService platformService = DisassembleAtPcDebuggerBot.this.findService(DebuggerPlatformService.class);
                        if (platformService == null) {
                            DisassembleAtPcDebuggerBot.this.reportError("Cannot disassemble without the platform service");
                            return true;
                        }
                        TraceObject object = ForDisassemblyTraceListener.this.getObject(thread);
                        DebuggerPlatformMapper mapper = platformService.getMapper(ForDisassemblyTraceListener.this.trace, object, snap);
                        if (mapper == null) {
                            DisassembleAtPcDebuggerBot.this.reportError("Cannot disassemble without a platform mapper");
                            return true;
                        }
                        DisassemblyResult result = mapper.disassemble(thread, object, start, this.val$disassemblable, snap, monitor);
                        if (result.isAtLeastOne() || result.isSuccess()) {
                            return true;
                        }
                        DisassembleAtPcDebuggerBot.this.reportError("Auto-disassembly error: " + result.getErrorMessage());
                    }
                    catch (Exception e) {
                        DisassembleAtPcDebuggerBot.this.reportError("Auto-disassembly error: " + e, e);
                    }
                    return true;
                }
            };
            DisassembleAtPcDebuggerBot.this.plugin.getTool().executeBackgroundCommand(cmd, (UndoableDomainObject)view);
        }
    }
}

