/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.format.ByteBlock;
import java.math.BigInteger;

public class ByteBlockInfo {
    private ByteBlock block;
    private BigInteger offset;
    private int column;

    public ByteBlockInfo(ByteBlock block, BigInteger offset) {
        this(block, offset, 0);
    }

    public ByteBlockInfo(ByteBlock block, BigInteger offset, int column) {
        this.block = block;
        this.offset = offset;
        this.column = column;
    }

    public ByteBlock getBlock() {
        return this.block;
    }

    public BigInteger getOffset() {
        return this.offset;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        return "ByteBlockInfo: block start=" + this.block.getLocationRepresentation(BigInteger.ZERO) + ", offset=" + this.offset + ", column=" + this.column;
    }

    public int hashCode() {
        return this.block.hashCode() + this.offset.hashCode() + this.column;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ByteBlockInfo info = (ByteBlockInfo)other;
        return this.block == info.block && this.offset.equals(info.offset) && this.column == info.column;
    }
}

