/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.generic;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;

public class iOS_KextStubFixupAnalyzer
extends FileFormatAnalyzer {
    public String getName() {
        return "iOS Kext STUB Section Fixup";
    }

    @Override
    public AnalyzerType getAnalysisType() {
        return AnalyzerType.BYTE_ANALYZER;
    }

    public boolean getDefaultEnablement(Program program) {
        return false;
    }

    public String getDescription() {
        return "Attempts to locate symbol names for addresses in the STUB section of iOS kext files by scanning all kext files in the current project. The entire iOS kernel should be loaded into the project for this to operate optimally.";
    }

    @Override
    public AnalysisPriority getPriority() {
        return AnalysisPriority.LOW_PRIORITY;
    }

    public boolean canAnalyze(Program program) {
        return false;
    }

    public boolean isPrototype() {
        return true;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        Data data;
        PluginTool tool;
        ProgramManager programManager = null;
        AutoAnalysisManager autoAnalysisManager = AutoAnalysisManager.getAnalysisManager((Program)program);
        if (autoAnalysisManager != null && (tool = autoAnalysisManager.getAnalysisTool()) != null) {
            programManager = (ProgramManager)tool.getService(ProgramManager.class);
        }
        Listing listing = program.getListing();
        SymbolTable symbolTable = program.getSymbolTable();
        Memory memory = program.getMemory();
        ReferenceManager referenceManager = program.getReferenceManager();
        ExternalManager externalManager = program.getExternalManager();
        MemoryBlock stubBlock = memory.getBlock("__stub");
        if (stubBlock == null) {
            stubBlock = memory.getBlock("__stubs");
        }
        if (stubBlock == null) {
            return true;
        }
        this.disassembleStubSection(program, stubBlock, monitor);
        Namespace stubNameSpace = this.getOrCreateNameSpace(program, stubBlock);
        MemoryBlock destinationBlock = memory.getBlock("__nl_symbol_ptr");
        if (destinationBlock == null) {
            destinationBlock = memory.getBlock("__got");
        }
        if (destinationBlock == null) {
            return true;
        }
        this.markupNonLazySymbolPointerSection(program, destinationBlock, monitor);
        Namespace nlSymbolPtrNameSpace = this.getOrCreateNameSpace(program, destinationBlock);
        DataIterator dataIterator = program.getListing().getData((AddressSetView)this.toAddressSet(destinationBlock), true);
        while (dataIterator.hasNext() && !monitor.isCancelled() && (data = dataIterator.next()).getMinAddress().compareTo((Object)destinationBlock.getEnd()) <= 0) {
            DestinationProgramInfo destinationProgramInfo;
            Address destinationAddress;
            monitor.setMessage("Fixing STUB section at " + data.getMinAddress());
            Object value = data.getValue();
            if (!(value instanceof Address) || memory.contains(destinationAddress = (Address)value)) continue;
            if (destinationAddress.getOffset() % 2L != 0L) {
                destinationAddress = destinationAddress.getNewAddress(destinationAddress.getOffset() - 1L);
            }
            if ((destinationProgramInfo = this.findDestinationProgram(program, programManager, destinationAddress, monitor)) == null) continue;
            this.createSymbolInNonLazySymbolPointerSection(symbolTable, nlSymbolPtrNameSpace, data, destinationProgramInfo);
            this.createExternalReferenceInNonLazySymbolPointerSection(referenceManager, externalManager, data, destinationAddress, destinationProgramInfo);
            this.createSymbolInStubSection(listing, symbolTable, referenceManager, stubNameSpace, data, destinationProgramInfo, monitor);
        }
        return true;
    }

    private void createSymbolInStubSection(Listing listing, SymbolTable symbolTable, ReferenceManager referenceManager, Namespace stubNameSpace, Data data, DestinationProgramInfo destinationProgramInfo, TaskMonitor monitor) {
        ReferenceIterator referencesTo = referenceManager.getReferencesTo(data.getMinAddress());
        while (referencesTo.hasNext() && !monitor.isCancelled()) {
            Reference reference = referencesTo.next();
            Function function = listing.getFunctionContaining(reference.getFromAddress());
            try {
                symbolTable.createLabel(function.getEntryPoint(), destinationProgramInfo.symbolName, stubNameSpace, SourceType.ANALYSIS);
            }
            catch (Exception exception) {}
        }
    }

    private void createExternalReferenceInNonLazySymbolPointerSection(ReferenceManager referenceManager, ExternalManager externalManager, Data data, Address destinationAddress, DestinationProgramInfo destinationProgramInfo) {
        try {
            referenceManager.addExternalReference(data.getMinAddress(), destinationProgramInfo.programName, destinationProgramInfo.symbolName, destinationAddress, SourceType.ANALYSIS, 0, RefType.DATA);
            externalManager.setExternalPath(destinationProgramInfo.programName, destinationProgramInfo.programPath, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createSymbolInNonLazySymbolPointerSection(SymbolTable symbolTable, Namespace nlSymbolPtrNameSpace, Data data, DestinationProgramInfo destinationProgramInfo) {
        try {
            symbolTable.createLabel(data.getMinAddress(), destinationProgramInfo.symbolName, nlSymbolPtrNameSpace, SourceType.ANALYSIS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void markupNonLazySymbolPointerSection(Program program, MemoryBlock block, TaskMonitor monitor) {
        ReferenceManager referenceManager = program.getReferenceManager();
        Listing listing = program.getListing();
        listing.clearCodeUnits(block.getStart(), block.getEnd(), false);
        Address address = block.getStart();
        while (!monitor.isCancelled() && address.compareTo((Object)block.getEnd()) <= 0) {
            int length;
            try {
                Reference[] references;
                Data data = listing.createData(address, (DataType)new PointerDataType());
                for (Reference reference : references = data.getReferencesFrom()) {
                    if (monitor.isCancelled()) break;
                    referenceManager.delete(reference);
                }
                length = data.getLength();
            }
            catch (Exception e) {
                return;
            }
            address = address.add((long)length);
        }
    }

    private void disassembleStubSection(Program program, MemoryBlock block, TaskMonitor monitor) {
    }

    private Namespace getOrCreateNameSpace(Program program, MemoryBlock block) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace parent = program.getGlobalNamespace();
        Namespace namespace = symbolTable.getNamespace(block.getName(), parent);
        if (namespace != null) {
            return namespace;
        }
        return symbolTable.createNameSpace(parent, block.getName(), SourceType.ANALYSIS);
    }

    private AddressSet toAddressSet(MemoryBlock block) {
        return new AddressSet(block.getStart(), block.getEnd());
    }

    private DestinationProgramInfo findDestinationProgram(Program sourceProgram, ProgramManager programManager, Address destinationAddress, TaskMonitor monitor) {
        Program alreadyOpenProgram;
        if (programManager != null && (alreadyOpenProgram = programManager.getProgram(destinationAddress)) != null && alreadyOpenProgram.getMemory().contains(destinationAddress)) {
            SymbolTable symbolTable = alreadyOpenProgram.getSymbolTable();
            Symbol symbol = symbolTable.getPrimarySymbol(destinationAddress);
            return new DestinationProgramInfo(alreadyOpenProgram.getName(), alreadyOpenProgram.getDomainFile().getPathname(), symbol == null ? null : symbol.getName());
        }
        String[] parts = sourceProgram.getDomainFile().getPathname().split("/");
        String firmwareVersion = parts[1];
        Project project = AppInfo.getActiveProject();
        ProjectData projectData = project.getProjectData();
        DomainFolder rootFolder = projectData.getRootFolder();
        DomainFolder folder = rootFolder.getFolder(firmwareVersion);
        if (folder == null) {
            return null;
        }
        return this.recurseFolder(folder, destinationAddress, programManager, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DestinationProgramInfo recurseFolder(DomainFolder folder, Address destinationAddress, ProgramManager programManager, TaskMonitor monitor) {
        DomainFile[] files;
        DomainFolder[] folders;
        for (DomainFolder child : folders = folder.getFolders()) {
            if (monitor.isCancelled()) break;
            DestinationProgramInfo info = this.recurseFolder(child, destinationAddress, programManager, monitor);
            if (info == null) continue;
            return info;
        }
        for (DomainFile file : files = folder.getFiles()) {
            if (monitor.isCancelled()) break;
            DomainObject domainObject = null;
            try {
                SymbolTable symbolTable;
                Symbol symbol;
                Program program;
                domainObject = file.getDomainObject((Object)this, true, false, monitor);
                if (!(domainObject instanceof Program) || !(program = (Program)domainObject).getMemory().contains(destinationAddress)) continue;
                if (programManager != null) {
                    programManager.openProgram(program, 2);
                }
                String symbolName = (symbol = (symbolTable = program.getSymbolTable()).getPrimarySymbol(destinationAddress)) == null ? null : symbol.getName();
                DestinationProgramInfo destinationProgramInfo = new DestinationProgramInfo(program.getName(), file.getPathname(), symbolName);
                return destinationProgramInfo;
            }
            catch (Exception e) {
                Msg.warn((Object)this, (Object)e);
            }
            finally {
                if (domainObject != null) {
                    domainObject.release((Object)this);
                }
            }
        }
        return null;
    }

    boolean isKext(Program program) {
        Processor processor = program.getLanguage().getProcessor();
        if (processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"ARM")) || processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"AARCH64"))) {
            return program.getName().toLowerCase().endsWith(".kext");
        }
        return false;
    }

    class DestinationProgramInfo {
        String programName;
        String programPath;
        String symbolName;

        DestinationProgramInfo(String programName, String programPath, String symbolName) {
            this.programName = programName;
            this.programPath = programPath;
            this.symbolName = symbolName;
        }
    }
}

