/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sevenzip;

import ghidra.app.util.bin.ByteProvider;
import java.io.IOException;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.SevenZipException;

class SZByteProviderStream
implements IInStream {
    private ByteProvider bp;
    private long position;

    SZByteProviderStream(ByteProvider bp) {
        this.bp = bp;
    }

    public synchronized long seek(long offset, int seekOrigin) throws SevenZipException {
        try {
            switch (seekOrigin) {
                case 0: {
                    this.setPos(offset);
                    break;
                }
                case 1: {
                    this.setPos(this.position + offset);
                    break;
                }
                case 2: {
                    this.setPos(this.bp.length() + offset);
                    break;
                }
                default: {
                    throw new RuntimeException("Seek: unknown origin: " + seekOrigin);
                }
            }
        }
        catch (IOException e) {
            throw new SevenZipException((Throwable)e);
        }
        return this.position;
    }

    private void setPos(long newPos) throws SevenZipException {
        if (newPos < 0L) {
            throw new SevenZipException("Invalid offset: " + newPos);
        }
        this.position = newPos;
    }

    public synchronized int read(byte[] data) throws SevenZipException {
        try {
            int bytesToRead = (int)Math.min((long)data.length, this.bp.length() - this.position);
            if (bytesToRead <= 0) {
                return 0;
            }
            byte[] bytes = this.bp.readBytes(this.position, (long)bytesToRead);
            System.arraycopy(bytes, 0, data, 0, bytes.length);
            this.position += (long)bytes.length;
            return bytes.length;
        }
        catch (IOException e) {
            throw new SevenZipException("Error reading random access file", (Throwable)e);
        }
    }

    public void close() throws IOException {
        this.bp.close();
    }
}

