/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sparseimage;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.sparseimage.SparseImageDecompressor;
import ghidra.file.formats.sparseimage.SparseImageFileSystemFactory;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.SingleFileSystemIndexHelper;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

@FileSystemInfo(type="simg", description="Android Sparse Image (simg)", factory=SparseImageFileSystemFactory.class)
public class SparseImageFileSystem
implements GFileSystem {
    private final FSRLRoot fsFSRL;
    private final FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private final FileSystemService fsService;
    private ByteProvider byteProvider;
    private ByteProvider payloadProvider;
    private SingleFileSystemIndexHelper fsIndexHelper;

    public SparseImageFileSystem(FSRLRoot fsFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws CancelledException, IOException {
        this.fsFSRL = fsFSRL;
        this.fsService = fsService;
        this.byteProvider = byteProvider;
        this.payloadProvider = this.getPayload(null, monitor);
        FSRL containerFSRL = byteProvider.getFSRL();
        String payloadName = containerFSRL.getName() + ".raw";
        this.fsIndexHelper = new SingleFileSystemIndexHelper((GFileSystem)this, fsFSRL, payloadName, this.payloadProvider.length(), this.payloadProvider.getFSRL().getMD5());
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.fsIndexHelper.clear();
        if (this.byteProvider != null) {
            this.byteProvider.close();
            this.byteProvider = null;
        }
        if (this.payloadProvider != null) {
            this.payloadProvider.close();
            this.payloadProvider = null;
        }
    }

    public boolean isClosed() {
        return this.fsIndexHelper.isClosed();
    }

    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    public GFile lookup(String path) throws IOException {
        return this.fsIndexHelper.lookup(path);
    }

    private ByteProvider getPayload(FSRL payloadFSRL, TaskMonitor monitor) throws CancelledException, IOException {
        return this.fsService.getDerivedByteProviderPush(this.byteProvider.getFSRL(), payloadFSRL, "sparse", -1L, os -> {
            SparseImageDecompressor sid = new SparseImageDecompressor(this.byteProvider, os);
            sid.decompress(monitor);
        }, monitor);
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.fsIndexHelper.isPayloadFile(file)) {
            return new ByteProviderWrapper(this.payloadProvider, file.getFSRL());
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsIndexHelper.getListing(directory);
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        FileAttributes result = new FileAttributes();
        if (this.fsIndexHelper.isPayloadFile(file)) {
            try {
                result.add(FileAttributeType.SIZE_ATTR, (Object)this.payloadProvider.length());
                result.add(FileAttributeType.COMPRESSED_SIZE_ATTR, (Object)this.byteProvider.length());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            result.add("MD5", (Object)this.fsIndexHelper.getPayloadFile().getFSRL().getMD5());
        }
        return result;
    }
}

