/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelOnlyWrappingTaskMonitor;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.FileNotFoundException;
import java.util.List;

public class PasteFileTask
extends Task {
    private DomainFolderNode destNode;
    private List<GTreeNode> list;
    private boolean isCut;
    private RepositoryAdapter repository;
    private boolean hasFailedCopy;

    public PasteFileTask(DomainFolderNode destNode, List<GTreeNode> list, boolean isCut) {
        super(list.size() > 1 ? "Paste Files" : "Paste File", true, true, true);
        this.destNode = destNode;
        this.list = list;
        this.isCut = isCut;
        this.repository = AppInfo.getActiveProject().getRepository();
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        TaskMonitor subMonitor = monitor;
        if (this.list.size() > 1) {
            subMonitor = new CancelOnlyWrappingTaskMonitor(monitor);
        }
        monitor.initialize((long)this.list.size());
        for (GTreeNode node : this.list) {
            monitor.checkCancelled();
            if (node instanceof DomainFolderNode) {
                monitor.setMessage("Pasting folder");
                this.pasteFolder(((DomainFolderNode)node).getDomainFolder(), subMonitor);
            } else if (node instanceof DomainFileNode) {
                monitor.setMessage("Pasting file");
                this.pasteFile(((DomainFileNode)node).getDomainFile(), subMonitor);
            }
            monitor.incrementProgress(1L);
        }
        if (this.hasFailedCopy) {
            Msg.showWarn((Object)((Object)this), null, (String)"Paste Failure(s)", (Object)"Unable to paste all nodes (see log for details)");
        }
    }

    private void pasteFile(DomainFile file, TaskMonitor monitor) {
        if (this.isCut) {
            this.moveFile(file, this.destNode.getDomainFolder());
        } else {
            this.copyFile(file, this.destNode.getDomainFolder(), monitor);
        }
    }

    private void pasteFolder(DomainFolder folder, TaskMonitor monitor) {
        if (this.isCut) {
            this.moveFolder(folder, this.destNode.getDomainFolder());
        } else {
            this.copyFolder(folder, this.destNode.getDomainFolder(), monitor);
        }
    }

    private void copyFile(DomainFile file, DomainFolder folder, TaskMonitor monitor) {
        try {
            String name = file.getName();
            DomainFile newFile = file.copyTo(folder, monitor);
            Msg.info((Object)((Object)this), (Object)("Copied file " + name + " to " + folder.toString() + " as " + newFile.getName()));
        }
        catch (FileNotFoundException e) {
            Msg.error((Object)((Object)this), (Object)("File not found '" + file + "'"));
            this.hasFailedCopy = true;
        }
        catch (CancelledException e) {
        }
        catch (Exception e) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)"Copy Files", null);
        }
    }

    private void copyFolder(DomainFolder folder, DomainFolder newParent, TaskMonitor monitor) {
        String name = folder.getName();
        try {
            folder.copyTo(newParent, monitor);
            Msg.info((Object)((Object)this), (Object)("Copied folder " + name + " to " + newParent.toString()));
        }
        catch (FileNotFoundException e) {
            Msg.error((Object)((Object)this), (Object)("Folder not found '" + folder + "'"));
            this.hasFailedCopy = true;
        }
        catch (CancelledException e) {
        }
        catch (Exception e) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)"Copy Folder", null);
        }
    }

    private void moveFile(DomainFile file, DomainFolder folder) {
        try {
            String name = file.getName();
            file.moveTo(folder);
            Msg.info((Object)((Object)this), (Object)("Moved file " + name + " to " + folder.toString()));
        }
        catch (FileNotFoundException e) {
            Msg.error((Object)((Object)this), (Object)("File not found '" + file + "'"));
            this.hasFailedCopy = true;
        }
        catch (Exception e) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)"Move File", null);
        }
    }

    private void moveFolder(DomainFolder folder, DomainFolder newParent) {
        String name = folder.getName();
        try {
            folder.moveTo(newParent);
            Msg.info((Object)((Object)this), (Object)("Moved folder " + name + " to " + folder.toString()));
        }
        catch (FileNotFoundException e) {
            Msg.error((Object)((Object)this), (Object)("Folder not found '" + folder + "'"));
            this.hasFailedCopy = true;
        }
        catch (Exception e) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)"Move Folder", null);
        }
    }
}

