/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.tool;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.DropTargetFactory;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.util.FileOpenDropHandler;
import ghidra.framework.main.ApplicationLevelOnlyPlugin;
import ghidra.framework.model.Project;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.options.PreferenceState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginConfigurationModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.dialog.ExtensionDetails;
import ghidra.framework.plugintool.dialog.ExtensionException;
import ghidra.framework.plugintool.dialog.ExtensionUtils;
import ghidra.framework.plugintool.dialog.PluginInstallerDialog;
import ghidra.framework.plugintool.util.PluginClassManager;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.framework.plugintool.util.PluginUtils;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.framework.project.tool.OpenFileDropHandlerFactory;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.jdom.Element;

public class GhidraTool
extends PluginTool {
    private static final String NON_AUTOSAVE_SAVE_TOOL_TITLE = "Save Tool?";
    public static final String EXTENSIONS_PREFERENCE_NAME = "KNOWN_EXTENSIONS";
    public static boolean autoSave = true;
    private FileOpenDropHandler fileOpenDropHandler;
    private PluginClassManager pluginClassManager;
    private DockingAction configureToolAction;

    public GhidraTool(Project project, String name) {
        super(project, name, true, true, false);
    }

    public GhidraTool(Project project, GhidraToolTemplate template) {
        super(project, template);
    }

    @Override
    protected DockingWindowManager createDockingWindowManager(boolean isDockable, boolean hasStatus, boolean isModal) {
        return new DockingWindowManager((Tool)this, null, isModal, isDockable, hasStatus, (DropTargetFactory)new OpenFileDropHandlerFactory(this));
    }

    @Override
    protected void initActions() {
        this.addSaveToolAction();
        this.addExportToolAction();
        this.addCloseAction();
        this.addExitAction();
        this.addManagePluginsAction();
        this.addOptionsAction();
        this.addHelpActions();
    }

    @Override
    public PluginClassManager getPluginClassManager() {
        if (this.pluginClassManager == null) {
            this.pluginClassManager = new PluginClassManager(Plugin.class, ApplicationLevelOnlyPlugin.class);
        }
        return this.pluginClassManager;
    }

    @Override
    public void setToolName(String name) {
        super.setToolName(name);
        this.setConfigChanged(true);
    }

    @Override
    public ToolTemplate getToolTemplate(boolean includeConfigState) {
        return new GhidraToolTemplate(this.iconURL, this.saveToXml(includeConfigState), this.getSupportedDataTypes());
    }

    @Override
    public Element saveWindowingDataToXml() {
        return this.winMgr.saveWindowingDataToXml();
    }

    @Override
    public void restoreWindowingDataFromXml(Element rootElement) {
        this.winMgr.restoreWindowDataFromXml(rootElement);
    }

    @Override
    public boolean shouldSave() {
        if (autoSave) {
            return true;
        }
        if (this.hasConfigChanged()) {
            return this.promptUserToSave();
        }
        return false;
    }

    @Override
    protected boolean doSaveTool() {
        if (autoSave) {
            return super.doSaveTool();
        }
        if (this.hasConfigChanged() && this.promptUserToSave()) {
            this.saveTool();
        }
        return true;
    }

    private boolean promptUserToSave() {
        int result = OptionDialog.showOptionNoCancelDialog((Component)this.getToolFrame(), (String)NON_AUTOSAVE_SAVE_TOOL_TITLE, (String)("The tool configuration has changed for " + this.getName() + ".\nDo you want to save it to your tool chest?"), (String)"&Save", (String)"Do&n't Save", (int)3);
        return result == 1;
    }

    @Override
    public void exit() {
        if (this.fileOpenDropHandler != null) {
            this.fileOpenDropHandler.dispose();
            this.fileOpenDropHandler = null;
        }
        super.exit();
    }

    private void addCloseAction() {
        DockingAction closeAction = new DockingAction("Close Tool", "Tool"){

            public void actionPerformed(ActionContext context) {
                GhidraTool.this.close();
            }
        };
        closeAction.setHelpLocation(new HelpLocation("Tool", closeAction.getName()));
        closeAction.setEnabled(true);
        closeAction.setMenuBarData(new MenuData(new String[]{"&File", "Close Tool"}, null, "Window_A"));
        this.addAction((DockingActionIf)closeAction);
    }

    protected void addManagePluginsAction() {
        this.configureToolAction = new DockingAction("Configure Tool", "Tool"){

            public void actionPerformed(ActionContext context) {
                GhidraTool.this.showConfig();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return GhidraTool.this.isConfigurable();
            }
        };
        this.configureToolAction.setMenuBarData(new MenuData(new String[]{"&File", "Configure"}, null, "PrintPost_PreTool"));
        this.configureToolAction.setEnabled(true);
        this.addAction((DockingActionIf)this.configureToolAction);
    }

    protected void showConfig() {
        this.showConfig(true, false);
    }

    public void checkForNewExtensions() {
        this.removeUninstalledExtensions();
        Set<ExtensionDetails> newExtensions = ExtensionUtils.getExtensionsInstalledSinceLastToolLaunch(this);
        List<Class<?>> newPlugins = PluginUtils.findLoadedPlugins(newExtensions);
        if (newPlugins.isEmpty()) {
            return;
        }
        int option = OptionDialog.showYesNoDialog((Component)this.getActiveWindow(), (String)"New Plugins Found!", (String)"New extension plugins detected. Would you like to configure them?");
        if (option == 1) {
            List<PluginDescription> pluginDescriptions = PluginUtils.getPluginDescriptions(this, newPlugins);
            PluginInstallerDialog pluginInstaller = new PluginInstallerDialog("New Plugins Found!", this, new PluginConfigurationModel(this), pluginDescriptions);
            this.showDialog(pluginInstaller);
        }
        this.addInstalledExtensions(newExtensions);
    }

    private void removeUninstalledExtensions() {
        try {
            Set<ExtensionDetails> installedExtensions = ExtensionUtils.getInstalledExtensions(false);
            List installedExtensionNames = installedExtensions.stream().map(ext -> ext.getName()).collect(Collectors.toList());
            DockingWindowManager dockingWindowManager = DockingWindowManager.getInstance((Component)this.getToolFrame());
            PreferenceState state = this.getExtensionPreferences(dockingWindowManager);
            String[] extNames = state.getStrings(EXTENSIONS_PREFERENCE_NAME, new String[0]);
            ArrayList<String> preferenceExtensionNames = new ArrayList<String>(Arrays.asList(extNames));
            Iterator i = preferenceExtensionNames.iterator();
            while (i.hasNext()) {
                String extName = (String)i.next();
                if (installedExtensionNames.contains(extName)) continue;
                i.remove();
            }
            state.putStrings(EXTENSIONS_PREFERENCE_NAME, preferenceExtensionNames.toArray(new String[preferenceExtensionNames.size()]));
            dockingWindowManager.putPreferenceState(EXTENSIONS_PREFERENCE_NAME, state);
        }
        catch (ExtensionException e) {
            Msg.warn((Object)((Object)this), (Object)"Couldn't retrieve installed extensions!", (Throwable)((Object)e));
        }
    }

    private void addInstalledExtensions(Set<ExtensionDetails> newExtensions) {
        DockingWindowManager dockingWindowManager = DockingWindowManager.getInstance((Component)this.getToolFrame());
        PreferenceState state = this.getExtensionPreferences(dockingWindowManager);
        Object[] extNames = state.getStrings(EXTENSIONS_PREFERENCE_NAME, new String[0]);
        List<String> extensionNamesToAdd = newExtensions.stream().map(ext -> ext.getName()).collect(Collectors.toList());
        String[] allPreferences = (String[])ArrayUtils.addAll((Object[])extNames, (Object[])extensionNamesToAdd.toArray(new String[extensionNamesToAdd.size()]));
        state.putStrings(EXTENSIONS_PREFERENCE_NAME, allPreferences);
        dockingWindowManager.putPreferenceState(EXTENSIONS_PREFERENCE_NAME, state);
    }

    private PreferenceState getExtensionPreferences(DockingWindowManager dockingWindowManager) {
        PreferenceState state = dockingWindowManager.getPreferenceState(EXTENSIONS_PREFERENCE_NAME);
        if (state == null) {
            state = new PreferenceState();
        }
        return state;
    }
}

