/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.Option;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.options.annotation.AutoOptionDefined;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;

public class AutoOptionsListener<R>
implements OptionsChangeListener {
    protected static final Map<Class<?>, Set<OptionSetter<?>>> SETTERS_BY_RECEIVER_CLASS = new HashMap();
    protected static final Map<Class<?>, ReceiverProfile<?>> PROFILES_BY_RECEIVER_CLASS = new HashMap();
    protected final R receiver;
    protected final ReceiverProfile<R> profile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <R> Set<OptionSetter<R>> collectSettersByReceiver(Class<R> cls, Plugin plugin) {
        Map<Class<?>, Set<OptionSetter<?>>> map = SETTERS_BY_RECEIVER_CLASS;
        synchronized (map) {
            if (SETTERS_BY_RECEIVER_CLASS.containsKey(cls)) {
                return SETTERS_BY_RECEIVER_CLASS.get(cls);
            }
            HashSet<OptionSetter<R>> result = new HashSet<OptionSetter<R>>();
            SETTERS_BY_RECEIVER_CLASS.put(cls, result);
            Class<R> superclass = cls.getSuperclass();
            if (superclass != null) {
                Set<OptionSetter<R>> superResult = AutoOptionsListener.collectSettersByReceiver(superclass, plugin);
                result.addAll(superResult);
            }
            for (Class<?> clazz : cls.getInterfaces()) {
                Set<OptionSetter<?>> superResult = AutoOptionsListener.collectSettersByReceiver(clazz, plugin);
                result.addAll(superResult);
            }
            for (AnnotatedElement annotatedElement : cls.getDeclaredFields()) {
                AutoOptionConsumed consumed;
                AutoOptionDefined defined = ((Field)annotatedElement).getAnnotation(AutoOptionDefined.class);
                if (defined != null) {
                    try {
                        result.add(new FieldOptionSetter((Field)annotatedElement, defined, plugin));
                    }
                    catch (IllegalArgumentException e) {
                        Msg.error(AutoOptionsListener.class, (Object)e.getMessage());
                    }
                }
                if ((consumed = ((Field)annotatedElement).getAnnotation(AutoOptionConsumed.class)) == null) continue;
                try {
                    result.add(new FieldOptionSetter((Field)annotatedElement, consumed, plugin));
                }
                catch (IllegalArgumentException e) {
                    Msg.error(AutoOptionsListener.class, (Object)e.getMessage());
                }
            }
            for (AnnotatedElement annotatedElement : cls.getDeclaredMethods()) {
                AutoOptionConsumed consumed = ((Method)annotatedElement).getAnnotation(AutoOptionConsumed.class);
                if (consumed == null) continue;
                try {
                    result.add(new MethodOptionSetter((Method)annotatedElement, consumed, plugin));
                }
                catch (IllegalArgumentException e) {
                    Msg.error(AutoOptionsListener.class, (Object)e.getMessage());
                }
            }
            return result;
        }
    }

    public AutoOptionsListener(Plugin plugin, R receiver) {
        this.receiver = receiver;
        this.profile = PROFILES_BY_RECEIVER_CLASS.computeIfAbsent(receiver.getClass(), cls -> new ReceiverProfile(cls, plugin));
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.profile.optionsChanged(options, optionName, oldValue, newValue, this.receiver);
    }

    public void notifyCurrentValues(PluginTool tool) {
        this.profile.notifyCurrentValues(tool, this.receiver);
    }

    public Set<String> getCategories() {
        return this.profile.categoriesView;
    }

    protected static class FieldOptionSetter<R>
    implements OptionSetter<R> {
        protected final Field field;
        protected final AutoOptions.CategoryAndName key;

        public FieldOptionSetter(Field field, AutoOptionDefined annotation, Plugin plugin) {
            this(field, new AutoOptions.CategoryAndName(annotation, plugin));
        }

        public FieldOptionSetter(Field field, AutoOptionConsumed annotation, Plugin plugin) {
            this(field, new AutoOptions.CategoryAndName(annotation, plugin));
        }

        public FieldOptionSetter(Field field, String category, String name) {
            this(field, new AutoOptions.CategoryAndName(category, name));
        }

        public FieldOptionSetter(Field field, AutoOptions.CategoryAndName key) {
            this.field = field;
            this.key = key;
            field.setAccessible(true);
        }

        @Override
        public void set(R receiver, Object newValue, Object oldValue) {
            try {
                this.field.set(receiver, newValue);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError("Could not set " + this.field + " = " + newValue + " for option " + this.key, e);
            }
        }

        @Override
        public AutoOptions.CategoryAndName getKey() {
            return this.key;
        }
    }

    protected static class MethodOptionSetter<R>
    implements OptionSetter<R> {
        protected final Method method;
        protected final AutoOptions.CategoryAndName key;
        protected final ParamOrder order;

        public MethodOptionSetter(Method method, AutoOptionConsumed annotation, Plugin plugin) {
            this(method, new AutoOptions.CategoryAndName(annotation, plugin));
        }

        public MethodOptionSetter(Method method, String category, String name) {
            this(method, new AutoOptions.CategoryAndName(category, name));
        }

        public MethodOptionSetter(Method method, AutoOptions.CategoryAndName key) {
            this.method = method;
            this.key = key;
            method.setAccessible(true);
            Parameter[] parameters = method.getParameters();
            if (parameters.length == 0) {
                this.order = ParamOrder.NONE;
            } else if (parameters.length == 1) {
                this.order = parameters[0].getAnnotation(AutoOptions.OldValue.class) != null ? ParamOrder.OLD_ONLY : ParamOrder.NEW_ONLY;
            } else if (parameters.length == 2) {
                if (parameters[0].getAnnotation(AutoOptions.NewValue.class) != null) {
                    if (parameters[1].getAnnotation(AutoOptions.NewValue.class) != null) {
                        throw new IllegalArgumentException("Cannot apply " + AutoOptions.NewValue.class.getName() + " to both parameters of " + method);
                    }
                    this.order = ParamOrder.NEW_OLD;
                } else if (parameters[0].getAnnotation(AutoOptions.OldValue.class) != null) {
                    if (parameters[1].getAnnotation(AutoOptions.OldValue.class) != null) {
                        throw new IllegalArgumentException("Cannot apply " + AutoOptions.OldValue.class.getName() + " to both parameters of " + method);
                    }
                    this.order = ParamOrder.OLD_NEW;
                } else {
                    this.order = parameters[1].getAnnotation(AutoOptions.NewValue.class) != null ? ParamOrder.OLD_NEW : ParamOrder.NEW_OLD;
                }
            } else {
                throw new IllegalArgumentException(AutoOptionConsumed.class + "-annotated method " + method + " cannot have more than two parameters");
            }
        }

        @Override
        public void set(R receiver, Object newValue, Object oldValue) {
            Object[] args = this.order.populate(oldValue, newValue);
            try {
                this.method.invoke(receiver, args);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                String argsStr = StringUtils.join((Object[])args, (String)",");
                Msg.error((Object)this, (Object)("Could not invoke " + this.method + "(" + argsStr + ") for option " + this.key), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                String argsStr = StringUtils.join((Object[])args, (String)",");
                Msg.error((Object)this, (Object)("Error during invocation of " + this.method + "(" + argsStr + ") for option " + this.key), (Throwable)e.getCause());
            }
        }

        @Override
        public AutoOptions.CategoryAndName getKey() {
            return this.key;
        }
    }

    protected static class ReceiverProfile<R> {
        protected final Map<AutoOptions.CategoryAndName, Set<OptionSetter<R>>> settersByOption = new HashMap<AutoOptions.CategoryAndName, Set<OptionSetter<R>>>();
        protected final Set<String> categories = new HashSet<String>();
        protected final Set<String> categoriesView = Collections.unmodifiableSet(this.categories);

        public ReceiverProfile(Class<R> receiverCls, Plugin plugin) {
            for (OptionSetter<R> setter : AutoOptionsListener.collectSettersByReceiver(receiverCls, plugin)) {
                AutoOptions.CategoryAndName key = setter.getKey();
                Set settersForReceiver = this.settersByOption.computeIfAbsent(key, k -> new HashSet());
                settersForReceiver.add(setter);
                this.categories.add(key.category());
            }
        }

        public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue, R receiver) {
            AutoOptions.CategoryAndName key;
            Set<OptionSetter<R>> settersForOption;
            if (oldValue == null) {
                oldValue = options.getDefaultValue(optionName);
            }
            if ((settersForOption = this.settersByOption.get(key = new AutoOptions.CategoryAndName(options.getName(), optionName))) == null) {
                return;
            }
            for (OptionSetter<R> setter : settersForOption) {
                setter.set(receiver, newValue, oldValue);
            }
        }

        public void notifyCurrentValues(PluginTool tool, R receiver) {
            for (Map.Entry<AutoOptions.CategoryAndName, Set<OptionSetter<R>>> ent : this.settersByOption.entrySet()) {
                AutoOptions.CategoryAndName key = ent.getKey();
                ToolOptions options = tool.getOptions(key.category());
                Option opt = options.getOption(key.name(), OptionType.NO_TYPE, null);
                if (!opt.isRegistered()) continue;
                Object newValue = opt.getValue(null);
                Object oldValue = opt.getDefaultValue();
                for (OptionSetter<R> setter : ent.getValue()) {
                    setter.set(receiver, newValue, oldValue);
                }
            }
        }
    }

    protected static enum ParamOrder {
        NONE((o, n) -> new Object[0]),
        NEW_ONLY((o, n) -> new Object[]{n}),
        OLD_ONLY((o, n) -> new Object[]{o}),
        NEW_OLD((o, n) -> new Object[]{n, o}),
        OLD_NEW((o, n) -> new Object[]{o, n});

        private final BiFunction<Object, Object, Object[]> pop;

        private ParamOrder(BiFunction<Object, Object, Object[]> pop) {
            this.pop = pop;
        }

        public Object[] populate(Object oldVal, Object newVal) {
            return this.pop.apply(oldVal, newVal);
        }
    }

    protected static interface OptionSetter<R> {
        public void set(R var1, Object var2, Object var3);

        public AutoOptions.CategoryAndName getKey();
    }
}

