/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import java.io.IOException;

public interface DirectedIterator<T> {
    public boolean hasNext() throws IOException;

    public T next() throws IOException;

    public boolean delete() throws IOException;

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Direction {
        FORWARD{

            @Override
            Direction reverse() {
                return BACKWARD;
            }
        }
        ,
        BACKWARD{

            @Override
            Direction reverse() {
                return FORWARD;
            }
        };


        abstract Direction reverse();

        static Direction reverse(Direction direction) {
            return direction.reverse();
        }
    }
}

