/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.typeinfo;

import java.util.ArrayList;
import java.util.List;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDType;
import mdemangler.datatype.modifier.MDCVMod;
import mdemangler.naming.MDQualification;
import mdemangler.typeinfo.MDTypeInfo;

public class MDVxTable
extends MDTypeInfo {
    private MDCVMod cvmod;
    private List<MDQualification> nestedQualifications;
    private boolean goodNestedTermination;

    public MDVxTable(MDMang dmang) {
        super(dmang);
        this.mdtype = new MDType(dmang);
        this.cvmod = new MDCVMod(dmang);
        this.nestedQualifications = new ArrayList<MDQualification>();
        this.goodNestedTermination = false;
    }

    public MDCVMod getCVMod() {
        return this.cvmod;
    }

    public List<MDQualification> getNestedQualifications() {
        return this.nestedQualifications;
    }

    public boolean isConst() {
        return this.cvmod.isConst();
    }

    public boolean isVolatile() {
        return this.cvmod.isVolatile();
    }

    public boolean isPointer64() {
        return this.cvmod.isPointer64();
    }

    @Override
    public void insert(StringBuilder builder) {
        this.cvmod.insert(builder);
    }

    @Override
    protected void parseInternal() throws MDException {
        this.cvmod.parse();
        while (this.dmang.peek() != '@' && this.dmang.peek() != '\uffff') {
            MDQualification qualification = new MDQualification(this.dmang);
            qualification.parse();
            this.nestedQualifications.add(qualification);
        }
        if (this.dmang.peek() == '@') {
            this.dmang.increment();
            this.goodNestedTermination = true;
        }
        this.nameModifier = this.generateNameModifier();
    }

    String generateNameModifier() {
        if (!this.goodNestedTermination) {
            return "{for ??}";
        }
        if (this.nestedQualifications.isEmpty()) {
            return "";
        }
        boolean first = true;
        StringBuilder modNameBuilder = new StringBuilder();
        this.dmang.appendString(modNameBuilder, "{for `");
        for (MDQualification qualification : this.nestedQualifications) {
            StringBuilder qnameBuilder = new StringBuilder();
            qualification.insert(qnameBuilder);
            if (first) {
                first = false;
            } else {
                this.dmang.appendString(modNameBuilder, "'s `");
            }
            this.dmang.appendString(modNameBuilder, qnameBuilder.toString());
        }
        this.dmang.appendString(modNameBuilder, "'}");
        return modNameBuilder.toString();
    }
}

