/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.PcodeFactory;

public class ClangLabelToken
extends ClangToken {
    private Address blockaddr = null;

    public ClangLabelToken(ClangNode par) {
        super(par);
    }

    @Override
    public boolean isVariableRef() {
        return false;
    }

    @Override
    public Address getMinAddress() {
        return this.blockaddr;
    }

    @Override
    public Address getMaxAddress() {
        return this.blockaddr;
    }

    @Override
    public void decode(Decoder decoder, PcodeFactory pfactory) throws DecoderException {
        AddressSpace spc = decoder.readSpace(AttributeId.ATTRIB_SPACE);
        long offset = decoder.readUnsignedInteger(AttributeId.ATTRIB_OFF);
        this.blockaddr = spc.getAddress(offset);
        super.decode(decoder, pfactory);
    }
}

