/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableDecl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.GlobalSymbolMap;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;

public class ClangVariableToken
extends ClangToken {
    private Varnode varnode = null;
    private PcodeOp op = null;

    public ClangVariableToken(ClangNode par) {
        super(par);
    }

    @Override
    public Varnode getVarnode() {
        return this.varnode;
    }

    @Override
    public PcodeOp getPcodeOp() {
        return this.op;
    }

    @Override
    public boolean isVariableRef() {
        return true;
    }

    @Override
    public Address getMinAddress() {
        if (this.op == null) {
            return null;
        }
        return this.op.getSeqnum().getTarget();
    }

    @Override
    public Address getMaxAddress() {
        if (this.op == null) {
            return null;
        }
        return this.op.getSeqnum().getTarget();
    }

    @Override
    public HighVariable getHighVariable() {
        Varnode inst = this.getVarnode();
        if (inst != null) {
            HighVariable hvar = inst.getHigh();
            if (hvar != null && hvar.getRepresentative() == null) {
                Varnode[] instances = new Varnode[]{inst};
                hvar.attachInstances(instances, inst);
            }
            return inst.getHigh();
        }
        ClangNode parent = this.Parent();
        if (parent instanceof ClangVariableDecl) {
            return ((ClangVariableDecl)parent).getHighVariable();
        }
        return null;
    }

    @Override
    public HighSymbol getHighSymbol(HighFunction highFunction) {
        HighSymbol symbol;
        HighVariable hvar;
        Varnode inst = this.getVarnode();
        if (inst != null && (hvar = inst.getHigh()) != null && (symbol = hvar.getSymbol()) != null) {
            return symbol;
        }
        ClangNode parent = this.Parent();
        if (parent instanceof ClangVariableDecl) {
            return ((ClangVariableDecl)parent).getHighSymbol();
        }
        if (highFunction == null) {
            return null;
        }
        Address storageAddress = this.getStorageAddress(highFunction.getAddressFactory());
        if (storageAddress == null) {
            return null;
        }
        return ClangVariableToken.findHighSymbol(storageAddress, highFunction);
    }

    @Override
    public void decode(Decoder decoder, PcodeFactory pfactory) throws DecoderException {
        int attribId;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            int refid;
            if (attribId == AttributeId.ATTRIB_VARREF.id()) {
                refid = (int)decoder.readUnsignedInteger();
                this.varnode = pfactory.getRef(refid);
                continue;
            }
            if (attribId != AttributeId.ATTRIB_OPREF.id()) continue;
            refid = (int)decoder.readUnsignedInteger();
            this.op = pfactory.getOpRef(refid);
        }
        decoder.rewindAttributes();
        super.decode(decoder, pfactory);
    }

    private Address getStorageAddress(AddressFactory addrFactory) {
        Address storageAddress = null;
        storageAddress = this.varnode != null ? this.varnode.getAddress() : HighFunctionDBUtil.getSpacebaseReferenceAddress((AddressFactory)addrFactory, (PcodeOp)this.op);
        return storageAddress;
    }

    private static HighSymbol findHighSymbol(Address addr, HighFunction highFunction) {
        HighSymbol highSymbol = null;
        if (addr.isStackAddress()) {
            LocalSymbolMap lsym = highFunction.getLocalSymbolMap();
            highSymbol = lsym.findLocal(addr, null);
        } else {
            GlobalSymbolMap gsym = highFunction.getGlobalSymbolMap();
            highSymbol = gsym.getSymbol(addr);
        }
        return highSymbol;
    }
}

