/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import ghidra.app.decompiler.CTokenHighlightMatcher;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.DecompilerHighlighter;
import ghidra.app.decompiler.component.ClangLayoutController;
import ghidra.app.decompiler.component.ColorProvider;
import ghidra.app.decompiler.component.DecompilerPanel;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;

class ClangDecompilerHighlighter
implements DecompilerHighlighter {
    protected String id;
    private DecompilerPanel decompilerPanel;
    private CTokenHighlightMatcher matcher;
    private Set<ClangDecompilerHighlighter> clones = new HashSet<ClangDecompilerHighlighter>();

    ClangDecompilerHighlighter(DecompilerPanel panel, CTokenHighlightMatcher matcher) {
        UUID uuId = UUID.randomUUID();
        this.id = uuId.toString();
        this.decompilerPanel = panel;
        this.matcher = matcher;
    }

    ClangDecompilerHighlighter(String id, DecompilerPanel panel, CTokenHighlightMatcher matcher) {
        this.id = id;
        this.decompilerPanel = panel;
        this.matcher = matcher;
    }

    ClangDecompilerHighlighter clone(DecompilerPanel panel) {
        ClangDecompilerHighlighter clone = new ClangDecompilerHighlighter(this.id, panel, this.matcher);
        this.clones.add(clone);
        return clone;
    }

    ClangDecompilerHighlighter copy(DecompilerPanel panel) {
        return new ClangDecompilerHighlighter(panel, this.matcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyHighlights() {
        if (this.decompilerPanel == null) {
            return;
        }
        this.clearHighlights();
        ClangLayoutController layoutModel = this.decompilerPanel.getLayoutController();
        ClangTokenGroup root = layoutModel.getRoot();
        HashMap<ClangToken, Color> highlights = new HashMap<ClangToken, Color>();
        try {
            this.matcher.start(root);
            this.gatherHighlights(root, highlights);
        }
        finally {
            this.matcher.end();
        }
        Supplier<Collection> tokens = () -> highlights.keySet();
        ColorProvider colorProvider = t -> (Color)highlights.get(t);
        this.decompilerPanel.addHighlighterHighlights(this, tokens, colorProvider);
        this.clones.forEach(c -> c.applyHighlights());
    }

    private void gatherHighlights(ClangTokenGroup root, Map<ClangToken, Color> results) {
        int n = root.numChildren();
        for (int i = 0; i < n; ++i) {
            ClangNode child = root.Child(i);
            this.getHighlight(child, results);
            if (!(child instanceof ClangTokenGroup)) continue;
            this.gatherHighlights((ClangTokenGroup)child, results);
        }
    }

    private void getHighlight(ClangNode node, Map<ClangToken, Color> results) {
        if (node instanceof ClangTokenGroup) {
            return;
        }
        ClangToken token = (ClangToken)node;
        Color color = this.matcher.getTokenHighlight(token);
        if (color != null) {
            results.put(token, color);
        }
    }

    @Override
    public void clearHighlights() {
        if (this.decompilerPanel == null) {
            return;
        }
        this.decompilerPanel.removeHighlighterHighlights(this);
        this.clones.forEach(c -> c.clearHighlights());
    }

    @Override
    public void dispose() {
        if (this.decompilerPanel == null) {
            return;
        }
        this.clearHighlights();
        this.decompilerPanel.removeHighlighter(this.id);
        this.decompilerPanel = null;
        this.clones.forEach(c -> c.dispose());
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return super.toString() + " " + this.id;
    }
}

