/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpimagegrid_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpimagegrid
 * @title: gimpimagegrid
 * @short_description: Functions manuipulating an image's grid.
 *
 * Functions manuipulating an image's grid.
 **/


/**
 * gimp_image_grid_get_spacing:
 * @image_ID: The image.
 * @xspacing: The image's grid horizontal spacing.
 * @yspacing: The image's grid vertical spacing.
 *
 * Gets the spacing of an image's grid.
 *
 * This procedure retrieves the horizontal and vertical spacing of an
 * image's grid. It takes the image as parameter.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_get_spacing (gint32   image_ID,
                             gdouble *xspacing,
                             gdouble *yspacing)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-image-grid-get-spacing",
                                    &nreturn_vals,
                                    GIMP_PDB_IMAGE, image_ID,
                                    GIMP_PDB_END);

  *xspacing = 0.0;
  *yspacing = 0.0;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    {
      *xspacing = return_vals[1].data.d_float;
      *yspacing = return_vals[2].data.d_float;
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_image_grid_set_spacing:
 * @image_ID: The image.
 * @xspacing: The image's grid horizontal spacing.
 * @yspacing: The image's grid vertical spacing.
 *
 * Sets the spacing of an image's grid.
 *
 * This procedure sets the horizontal and vertical spacing of an
 * image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_spacing (gint32  image_ID,
                             gdouble xspacing,
                             gdouble yspacing)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-image-grid-set-spacing",
                                    &nreturn_vals,
                                    GIMP_PDB_IMAGE, image_ID,
                                    GIMP_PDB_FLOAT, xspacing,
                                    GIMP_PDB_FLOAT, yspacing,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_image_grid_get_offset:
 * @image_ID: The image.
 * @xoffset: The image's grid horizontal offset.
 * @yoffset: The image's grid vertical offset.
 *
 * Gets the offset of an image's grid.
 *
 * This procedure retrieves the horizontal and vertical offset of an
 * image's grid. It takes the image as parameter.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_get_offset (gint32   image_ID,
                            gdouble *xoffset,
                            gdouble *yoffset)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-image-grid-get-offset",
                                    &nreturn_vals,
                                    GIMP_PDB_IMAGE, image_ID,
                                    GIMP_PDB_END);

  *xoffset = 0.0;
  *yoffset = 0.0;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    {
      *xoffset = return_vals[1].data.d_float;
      *yoffset = return_vals[2].data.d_float;
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_image_grid_set_offset:
 * @image_ID: The image.
 * @xoffset: The image's grid horizontal offset.
 * @yoffset: The image's grid vertical offset.
 *
 * Sets the offset of an image's grid.
 *
 * This procedure sets the horizontal and vertical offset of an image's
 * grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_offset (gint32  image_ID,
                            gdouble xoffset,
                            gdouble yoffset)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-image-grid-set-offset",
                                    &nreturn_vals,
                                    GIMP_PDB_IMAGE, image_ID,
                                    GIMP_PDB_FLOAT, xoffset,
                                    GIMP_PDB_FLOAT, yoffset,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_image_grid_get_foreground_color:
 * @image_ID: The image.
 * @fgcolor: The image's grid foreground color.
 *
 * Sets the foreground color of an image's grid.
 *
 * This procedure gets the foreground color of an image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_get_foreground_color (gint32   image_ID,
                                      GimpRGB *fgcolor)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-image-grid-get-foreground-color",
                                    &nreturn_vals,
                                    GIMP_PDB_IMAGE, image_ID,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    *fgcolor = return_vals[1].data.d_color;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_image_grid_set_foreground_color:
 * @image_ID: The image.
 * @fgcolor: The new foreground color.
 *
 * Gets the foreground color of an image's grid.
 *
 * This procedure sets the foreground color of an image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_foreground_color (gint32         image_ID,
                                      const GimpRGB *fgcolor)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-image-grid-set-foreground-color",
                                    &nreturn_vals,
                                    GIMP_PDB_IMAGE, image_ID,
                                    GIMP_PDB_COLOR, fgcolor,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_image_grid_get_background_color:
 * @image_ID: The image.
 * @bgcolor: The image's grid background color.
 *
 * Sets the background color of an image's grid.
 *
 * This procedure gets the background color of an image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_get_background_color (gint32   image_ID,
                                      GimpRGB *bgcolor)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-image-grid-get-background-color",
                                    &nreturn_vals,
                                    GIMP_PDB_IMAGE, image_ID,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    *bgcolor = return_vals[1].data.d_color;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_image_grid_set_background_color:
 * @image_ID: The image.
 * @bgcolor: The new background color.
 *
 * Gets the background color of an image's grid.
 *
 * This procedure sets the background color of an image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_background_color (gint32         image_ID,
                                      const GimpRGB *bgcolor)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-image-grid-set-background-color",
                                    &nreturn_vals,
                                    GIMP_PDB_IMAGE, image_ID,
                                    GIMP_PDB_COLOR, bgcolor,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_image_grid_get_style:
 * @image_ID: The image.
 *
 * Gets the style of an image's grid.
 *
 * This procedure retrieves the style of an image's grid.
 *
 * Returns: The image's grid style.
 *
 * Since: 2.4
 **/
GimpGridStyle
gimp_image_grid_get_style (gint32 image_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpGridStyle style = 0;

  return_vals = gimp_run_procedure ("gimp-image-grid-get-style",
                                    &nreturn_vals,
                                    GIMP_PDB_IMAGE, image_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    style = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return style;
}

/**
 * gimp_image_grid_set_style:
 * @image_ID: The image.
 * @style: The image's grid style.
 *
 * Sets the style unit of an image's grid.
 *
 * This procedure sets the style of an image's grid. It takes the image
 * and the new style as parameters.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_style (gint32        image_ID,
                           GimpGridStyle style)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-image-grid-set-style",
                                    &nreturn_vals,
                                    GIMP_PDB_IMAGE, image_ID,
                                    GIMP_PDB_INT32, style,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
