/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppalettes_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimppalettes
 * @title: gimppalettes
 * @short_description: Operations related to palettes.
 *
 * Operations related to palettes.
 **/


/**
 * gimp_palettes_refresh:
 *
 * Refreshes current palettes. This function always succeeds.
 *
 * This procedure retrieves all palettes currently in the user's
 * palette path and updates the palette dialogs accordingly.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_palettes_refresh (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-palettes-refresh",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_palettes_get_list:
 * @filter: An optional regular expression used to filter the list.
 * @num_palettes: The number of palettes in the list.
 *
 * Retrieves a list of all of the available palettes
 *
 * This procedure returns a complete listing of available palettes.
 * Each name returned can be used as input to the command
 * gimp_context_set_palette().
 *
 * Returns: The list of palette names. The returned value must be freed
 * with g_strfreev().
 **/
gchar **
gimp_palettes_get_list (const gchar *filter,
                        gint        *num_palettes)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar **palette_list = NULL;
  gint i;

  return_vals = gimp_run_procedure ("gimp-palettes-get-list",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, filter,
                                    GIMP_PDB_END);

  *num_palettes = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      *num_palettes = return_vals[1].data.d_int32;
      if (*num_palettes > 0)
        {
          palette_list = g_new0 (gchar *, *num_palettes + 1);
          for (i = 0; i < *num_palettes; i++)
            palette_list[i] = g_strdup (return_vals[2].data.d_stringarray[i]);
        }
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return palette_list;
}
