/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimpdrawable.h"
#include "core/gimpimage.h"
#include "core/gimplayer-floating-selection.h"
#include "core/gimplayer.h"
#include "core/gimpparamspecs.h"

#include "gimppdb.h"
#include "gimppdberror.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpValueArray *
floating_sel_remove_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpLayer *floating_sel;

  floating_sel = gimp_value_get_layer (gimp_value_array_index (args, 0), gimp);

  if (success)
    {
      if (gimp_layer_is_floating_sel (floating_sel))
        {
          gimp_image_remove_layer (gimp_item_get_image (GIMP_ITEM (floating_sel)),
                                   floating_sel, TRUE, NULL);
        }
      else
        {
          g_set_error_literal (error, GIMP_PDB_ERROR,
                               GIMP_PDB_ERROR_INVALID_ARGUMENT,
                               _("Cannot remove this layer because "
                                 "it is not a floating selection."));
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
floating_sel_anchor_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpLayer *floating_sel;

  floating_sel = gimp_value_get_layer (gimp_value_array_index (args, 0), gimp);

  if (success)
    {
      if (gimp_layer_is_floating_sel (floating_sel))
        {
          floating_sel_anchor (floating_sel);
        }
      else
        {
          g_set_error_literal (error, GIMP_PDB_ERROR,
                               GIMP_PDB_ERROR_INVALID_ARGUMENT,
                               _("Cannot anchor this layer because "
                                 "it is not a floating selection."));
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
floating_sel_to_layer_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  GimpLayer *floating_sel;

  floating_sel = gimp_value_get_layer (gimp_value_array_index (args, 0), gimp);

  if (success)
    {
      if (gimp_layer_is_floating_sel (floating_sel))
        {
          success = floating_sel_to_layer (floating_sel, error);
        }
      else
        {
          g_set_error_literal (error, GIMP_PDB_ERROR,
                               GIMP_PDB_ERROR_INVALID_ARGUMENT,
                               _("Cannot convert this layer to a normal layer "
                                 "because it is not a floating selection."));
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
floating_sel_attach_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  GimpDrawable *drawable;

  layer = gimp_value_get_layer (gimp_value_array_index (args, 0), gimp);
  drawable = gimp_value_get_drawable (gimp_value_array_index (args, 1), gimp);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          /* see layer-new */
          if (gimp_drawable_is_gray (GIMP_DRAWABLE (layer)) &&
              GIMP_IS_LAYER (drawable))
            gimp_layer_fix_format_space (layer, TRUE, FALSE);

          floating_sel_attach (layer, drawable);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_floating_sel_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-floating-sel-remove
   */
  procedure = gimp_procedure_new (floating_sel_remove_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-floating-sel-remove");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-floating-sel-remove",
                                     "Remove the specified floating selection from its associated drawable.",
                                     "This procedure removes the floating selection completely, without any side effects. The associated drawable is then set to active.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("floating-sel",
                                                         "floating sel",
                                                         "The floating selection",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-floating-sel-anchor
   */
  procedure = gimp_procedure_new (floating_sel_anchor_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-floating-sel-anchor");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-floating-sel-anchor",
                                     "Anchor the specified floating selection to its associated drawable.",
                                     "This procedure anchors the floating selection to its associated drawable. This is similar to merging with a merge type of ClipToBottomLayer. The floating selection layer is no longer valid after this operation.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("floating-sel",
                                                         "floating sel",
                                                         "The floating selection",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-floating-sel-to-layer
   */
  procedure = gimp_procedure_new (floating_sel_to_layer_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-floating-sel-to-layer");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-floating-sel-to-layer",
                                     "Transforms the specified floating selection into a layer.",
                                     "This procedure transforms the specified floating selection into a layer with the same offsets and extents. The composited image will look precisely the same, but the floating selection layer will no longer be clipped to the extents of the drawable it was attached to. The floating selection will become the active layer. This procedure will not work if the floating selection has a different base type from the underlying image. This might be the case if the floating selection is above an auxiliary channel or a layer mask.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("floating-sel",
                                                         "floating sel",
                                                         "The floating selection",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-floating-sel-attach
   */
  procedure = gimp_procedure_new (floating_sel_attach_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-floating-sel-attach");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-floating-sel-attach",
                                     "Attach the specified layer as floating to the specified drawable.",
                                     "This procedure attaches the layer as floating selection to the drawable.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer (is attached as floating selection)",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The drawable (where to attach the floating selection)",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
