/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpdisplay_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpdisplay
 * @title: gimpdisplay
 * @short_description: Functions to create, delete and flush displays (views) on an image.
 *
 * Functions to create, delete and flush displays (views) on an image.
 **/


/**
 * gimp_display_is_valid:
 * @display_ID: The display to check.
 *
 * Returns TRUE if the display is valid.
 *
 * This procedure checks if the given display ID is valid and refers to
 * an existing display.
 *
 * Returns: Whether the display ID is valid.
 *
 * Since: 2.4
 **/
gboolean
gimp_display_is_valid (gint32 display_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean valid = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_DISPLAY_ID,
                                          G_TYPE_NONE);
  gimp_value_set_display_id (gimp_value_array_index (args, 0), display_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-display-is-valid",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    valid = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return valid;
}

/**
 * gimp_display_new:
 * @image_ID: The image.
 *
 * Create a new display for the specified image.
 *
 * Creates a new display for the specified image. If the image already
 * has a display, another is added. Multiple displays are handled
 * transparently by GIMP. The newly created display is returned and can
 * be subsequently destroyed with a call to gimp_display_delete(). This
 * procedure only makes sense for use with the GIMP UI, and will result
 * in an execution error if called when GIMP has no UI.
 *
 * Returns: The new display.
 **/
gint32
gimp_display_new (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 display_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-display-new",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    display_ID = gimp_value_get_display_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return display_ID;
}

/**
 * gimp_display_delete:
 * @display_ID: The display to delete.
 *
 * Delete the specified display.
 *
 * This procedure removes the specified display. If this is the last
 * remaining display for the underlying image, then the image is
 * deleted also. Note that the display is closed no matter if the image
 * is dirty or not. Better save the image before calling this
 * procedure.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_display_delete (gint32 display_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_DISPLAY_ID,
                                          G_TYPE_NONE);
  gimp_value_set_display_id (gimp_value_array_index (args, 0), display_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-display-delete",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_display_get_window_handle:
 * @display_ID: The display to get the window handle from.
 *
 * Get a handle to the native window for an image display.
 *
 * This procedure returns a handle to the native window for a given
 * image display. For example in the X backend of GDK, a native window
 * handle is an Xlib XID. A value of 0 is returned for an invalid
 * display or if this function is unimplemented for the windowing
 * system that is being used.
 *
 * Returns: The native window handle or 0.
 *
 * Since: 2.4
 **/
gint
gimp_display_get_window_handle (gint32 display_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint window = 0;

  args = gimp_value_array_new_from_types (GIMP_TYPE_DISPLAY_ID,
                                          G_TYPE_NONE);
  gimp_value_set_display_id (gimp_value_array_index (args, 0), display_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-display-get-window-handle",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    window = g_value_get_int (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return window;
}

/**
 * gimp_displays_flush:
 *
 * Flush all internal changes to the user interface
 *
 * This procedure takes no arguments and returns nothing except a
 * success status. Its purpose is to flush all pending updates of image
 * manipulations to the user interface. It should be called whenever
 * appropriate.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_displays_flush (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_NONE);

  return_vals = gimp_run_procedure_with_array ("gimp-displays-flush",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_displays_reconnect:
 * @old_image_ID: The old image (must have at least one display).
 * @new_image_ID: The new image (must not have a display).
 *
 * Reconnect displays from one image to another image.
 *
 * This procedure connects all displays of the old_image to the
 * new_image. If the old_image has no display or new_image already has
 * a display the reconnect is not performed and the procedure returns
 * without success. You should rarely need to use this function.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_displays_reconnect (gint32 old_image_ID,
                         gint32 new_image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), old_image_ID);
  gimp_value_set_image_id (gimp_value_array_index (args, 1), new_image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-displays-reconnect",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
