/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpedit_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpedit
 * @title: gimpedit
 * @short_description: Edit menu functions (cut, copy, paste, clear, etc.)
 *
 * Edit menu functions (cut, copy, paste, clear, etc.)
 **/


/**
 * gimp_edit_cut:
 * @drawable_ID: The drawable to cut from.
 *
 * Cut from the specified drawable.
 *
 * If there is a selection in the image, then the area specified by the
 * selection is cut from the specified drawable and placed in an
 * internal GIMP edit buffer. It can subsequently be retrieved using
 * the gimp_edit_paste() command. If there is no selection, then the
 * specified drawable will be removed and its contents stored in the
 * internal GIMP edit buffer. This procedure will fail if the selected
 * area lies completely outside the bounds of the current drawable and
 * there is nothing to copy from.
 *
 * Returns: TRUE if the cut was successful, FALSE if there was nothing
 * to copy from.
 **/
gboolean
gimp_edit_cut (gint32 drawable_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean non_empty = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_DRAWABLE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_drawable_id (gimp_value_array_index (args, 0), drawable_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-edit-cut",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    non_empty = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return non_empty;
}

/**
 * gimp_edit_copy:
 * @drawable_ID: The drawable to copy from.
 *
 * Copy from the specified drawable.
 *
 * If there is a selection in the image, then the area specified by the
 * selection is copied from the specified drawable and placed in an
 * internal GIMP edit buffer. It can subsequently be retrieved using
 * the gimp_edit_paste() command. If there is no selection, then the
 * specified drawable's contents will be stored in the internal GIMP
 * edit buffer. This procedure will fail if the selected area lies
 * completely outside the bounds of the current drawable and there is
 * nothing to copy from.
 *
 * Returns: TRUE if the cut was successful, FALSE if there was nothing
 * to copy from.
 **/
gboolean
gimp_edit_copy (gint32 drawable_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean non_empty = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_DRAWABLE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_drawable_id (gimp_value_array_index (args, 0), drawable_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-edit-copy",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    non_empty = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return non_empty;
}

/**
 * gimp_edit_copy_visible:
 * @image_ID: The image to copy from.
 *
 * Copy from the projection.
 *
 * If there is a selection in the image, then the area specified by the
 * selection is copied from the projection and placed in an internal
 * GIMP edit buffer. It can subsequently be retrieved using the
 * gimp_edit_paste() command. If there is no selection, then the
 * projection's contents will be stored in the internal GIMP edit
 * buffer.
 *
 * Returns: TRUE if the copy was successful.
 *
 * Since: 2.2
 **/
gboolean
gimp_edit_copy_visible (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean non_empty = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-edit-copy-visible",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    non_empty = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return non_empty;
}

/**
 * gimp_edit_paste:
 * @drawable_ID: The drawable to paste to.
 * @paste_into: Clear selection, or paste behind it?
 *
 * Paste buffer to the specified drawable.
 *
 * This procedure pastes a copy of the internal GIMP edit buffer to the
 * specified drawable. The GIMP edit buffer will be empty unless a call
 * was previously made to either gimp_edit_cut() or gimp_edit_copy().
 * The \"paste_into\" option specifies whether to clear the current
 * image selection, or to paste the buffer \"behind\" the selection.
 * This allows the selection to act as a mask for the pasted buffer.
 * Anywhere that the selection mask is non-zero, the pasted buffer will
 * show through. The pasted buffer will be a new layer in the image
 * which is designated as the image floating selection. If the image
 * has a floating selection at the time of pasting, the old floating
 * selection will be anchored to its drawable before the new floating
 * selection is added. This procedure returns the new floating layer.
 * The resulting floating selection will already be attached to the
 * specified drawable, and a subsequent call to floating_sel_attach is
 * not needed.
 *
 * Returns: The new floating selection.
 **/
gint32
gimp_edit_paste (gint32   drawable_ID,
                 gboolean paste_into)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 floating_sel_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_DRAWABLE_ID,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  gimp_value_set_drawable_id (gimp_value_array_index (args, 0), drawable_ID);
  g_value_set_boolean (gimp_value_array_index (args, 1), paste_into);

  return_vals = gimp_run_procedure_with_array ("gimp-edit-paste",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    floating_sel_ID = gimp_value_get_layer_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return floating_sel_ID;
}

/**
 * gimp_edit_paste_as_new_image:
 *
 * Paste buffer to a new image.
 *
 * This procedure pastes a copy of the internal GIMP edit buffer to a
 * new image. The GIMP edit buffer will be empty unless a call was
 * previously made to either gimp_edit_cut() or gimp_edit_copy(). This
 * procedure returns the new image or -1 if the edit buffer was empty.
 *
 * Returns: The new image.
 *
 * Since: 2.10
 **/
gint32
gimp_edit_paste_as_new_image (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 image_ID = -1;

  args = gimp_value_array_new_from_types (G_TYPE_NONE);

  return_vals = gimp_run_procedure_with_array ("gimp-edit-paste-as-new-image",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    image_ID = gimp_value_get_image_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return image_ID;
}

/**
 * gimp_edit_named_cut:
 * @drawable_ID: The drawable to cut from.
 * @buffer_name: The name of the buffer to create.
 *
 * Cut into a named buffer.
 *
 * This procedure works like gimp_edit_cut(), but additionally stores
 * the cut buffer into a named buffer that will stay available for
 * later pasting, regardless of any intermediate copy or cut
 * operations.
 *
 * Returns: (transfer full): The real name given to the buffer, or NULL
 * if the cut failed.
 *
 * Since: 2.4
 **/
gchar *
gimp_edit_named_cut (gint32       drawable_ID,
                     const gchar *buffer_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *real_name = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_DRAWABLE_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_drawable_id (gimp_value_array_index (args, 0), drawable_ID);
  g_value_set_string (gimp_value_array_index (args, 1), buffer_name);

  return_vals = gimp_run_procedure_with_array ("gimp-edit-named-cut",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    real_name = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return real_name;
}

/**
 * gimp_edit_named_copy:
 * @drawable_ID: The drawable to copy from.
 * @buffer_name: The name of the buffer to create.
 *
 * Copy into a named buffer.
 *
 * This procedure works like gimp_edit_copy(), but additionally stores
 * the copied buffer into a named buffer that will stay available for
 * later pasting, regardless of any intermediate copy or cut
 * operations.
 *
 * Returns: (transfer full): The real name given to the buffer, or NULL
 * if the copy failed.
 *
 * Since: 2.4
 **/
gchar *
gimp_edit_named_copy (gint32       drawable_ID,
                      const gchar *buffer_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *real_name = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_DRAWABLE_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_drawable_id (gimp_value_array_index (args, 0), drawable_ID);
  g_value_set_string (gimp_value_array_index (args, 1), buffer_name);

  return_vals = gimp_run_procedure_with_array ("gimp-edit-named-copy",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    real_name = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return real_name;
}

/**
 * gimp_edit_named_copy_visible:
 * @image_ID: The image to copy from.
 * @buffer_name: The name of the buffer to create.
 *
 * Copy from the projection into a named buffer.
 *
 * This procedure works like gimp_edit_copy_visible(), but additionally
 * stores the copied buffer into a named buffer that will stay
 * available for later pasting, regardless of any intermediate copy or
 * cut operations.
 *
 * Returns: (transfer full): The real name given to the buffer, or NULL
 * if the copy failed.
 *
 * Since: 2.4
 **/
gchar *
gimp_edit_named_copy_visible (gint32       image_ID,
                              const gchar *buffer_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *real_name = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_string (gimp_value_array_index (args, 1), buffer_name);

  return_vals = gimp_run_procedure_with_array ("gimp-edit-named-copy-visible",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    real_name = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return real_name;
}

/**
 * gimp_edit_named_paste:
 * @drawable_ID: The drawable to paste to.
 * @buffer_name: The name of the buffer to paste.
 * @paste_into: Clear selection, or paste behind it?
 *
 * Paste named buffer to the specified drawable.
 *
 * This procedure works like gimp_edit_paste() but pastes a named
 * buffer instead of the global buffer.
 *
 * Returns: The new floating selection.
 *
 * Since: 2.4
 **/
gint32
gimp_edit_named_paste (gint32       drawable_ID,
                       const gchar *buffer_name,
                       gboolean     paste_into)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 floating_sel_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_DRAWABLE_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  gimp_value_set_drawable_id (gimp_value_array_index (args, 0), drawable_ID);
  g_value_set_string (gimp_value_array_index (args, 1), buffer_name);
  g_value_set_boolean (gimp_value_array_index (args, 2), paste_into);

  return_vals = gimp_run_procedure_with_array ("gimp-edit-named-paste",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    floating_sel_ID = gimp_value_get_layer_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return floating_sel_ID;
}

/**
 * gimp_edit_named_paste_as_new_image:
 * @buffer_name: The name of the buffer to paste.
 *
 * Paste named buffer to a new image.
 *
 * This procedure works like gimp_edit_paste_as_new_image() but pastes
 * a named buffer instead of the global buffer.
 *
 * Returns: The new image.
 *
 * Since: 2.10
 **/
gint32
gimp_edit_named_paste_as_new_image (const gchar *buffer_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 image_ID = -1;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), buffer_name);

  return_vals = gimp_run_procedure_with_array ("gimp-edit-named-paste-as-new-image",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    image_ID = gimp_value_get_image_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return image_ID;
}
