/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpfonts_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpfonts
 * @title: gimpfonts
 * @short_description: Operations related to fonts.
 *
 * Operations related to fonts.
 **/


/**
 * gimp_fonts_refresh:
 *
 * Refresh current fonts. This function always succeeds.
 *
 * This procedure retrieves all fonts currently in the user's font path
 * and updates the font dialogs accordingly. Depending on the amount of
 * fonts on the system, this can take considerable time.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_fonts_refresh (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_NONE);

  return_vals = gimp_run_procedure_with_array ("gimp-fonts-refresh",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_fonts_get_list:
 * @filter: An optional regular expression used to filter the list.
 * @num_fonts: (out): The number of available fonts.
 *
 * Retrieve the list of loaded fonts.
 *
 * This procedure returns a list of the fonts that are currently
 * available.
 *
 * Returns: (array length=num_fonts) (element-type gchar*) (transfer
 * full): The list of font names. The returned value must be freed with
 * g_strfreev().
 **/
gchar **
gimp_fonts_get_list (const gchar *filter,
                     gint        *num_fonts)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar **font_list = NULL;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), filter);

  return_vals = gimp_run_procedure_with_array ("gimp-fonts-get-list",
                                               args);
  gimp_value_array_unref (args);

  *num_fonts = 0;

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    {
      *num_fonts = g_value_get_int (gimp_value_array_index (return_vals, 1));
      font_list = gimp_value_dup_string_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return font_list;
}
