/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpgradient_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpgradient
 * @title: gimpgradient
 * @short_description: Functions operating on a single gradient.
 *
 * Functions operating on a single gradient.
 **/


/**
 * gimp_gradient_new:
 * @name: The requested name of the new gradient.
 *
 * Creates a new gradient
 *
 * This procedure creates a new, uninitialized gradient
 *
 * Returns: (transfer full): The actual new gradient name.
 *
 * Since: 2.2
 **/
gchar *
gimp_gradient_new (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *actual_name = NULL;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-new",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    actual_name = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return actual_name;
}

/**
 * gimp_gradient_duplicate:
 * @name: The gradient name.
 *
 * Duplicates a gradient
 *
 * This procedure creates an identical gradient by a different name
 *
 * Returns: (transfer full): The name of the gradient's copy.
 *
 * Since: 2.2
 **/
gchar *
gimp_gradient_duplicate (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *copy_name = NULL;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-duplicate",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    copy_name = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return copy_name;
}

/**
 * gimp_gradient_is_editable:
 * @name: The gradient name.
 *
 * Tests if gradient can be edited
 *
 * Returns TRUE if you have permission to change the gradient
 *
 * Returns: TRUE if the gradient can be edited.
 *
 * Since: 2.4
 **/
gboolean
gimp_gradient_is_editable (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean editable = FALSE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-is-editable",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    editable = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return editable;
}

/**
 * gimp_gradient_rename:
 * @name: The gradient name.
 * @new_name: The new name of the gradient.
 *
 * Rename a gradient
 *
 * This procedure renames a gradient
 *
 * Returns: (transfer full): The actual new name of the gradient.
 *
 * Since: 2.2
 **/
gchar *
gimp_gradient_rename (const gchar *name,
                      const gchar *new_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *actual_name = NULL;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_string (gimp_value_array_index (args, 1), new_name);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-rename",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    actual_name = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return actual_name;
}

/**
 * gimp_gradient_delete:
 * @name: The gradient name.
 *
 * Deletes a gradient
 *
 * This procedure deletes a gradient
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_delete (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-delete",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_get_number_of_segments:
 * @name: The gradient name.
 *
 * Returns the number of segments of the specified gradient
 *
 * This procedure returns the number of segments of the specified
 * gradient.
 *
 * Returns: Number of segments.
 *
 * Since: 2.6
 **/
gint
gimp_gradient_get_number_of_segments (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint num_segments = 0;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-get-number-of-segments",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    num_segments = g_value_get_int (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return num_segments;
}

/**
 * gimp_gradient_get_uniform_samples:
 * @name: The gradient name.
 * @num_samples: The number of samples to take.
 * @reverse: Use the reverse gradient.
 * @num_color_samples: (out): Length of the color_samples array (4 * num_samples).
 * @color_samples: (out) (array length=num_color_samples) (element-type gdouble) (transfer full): Color samples: { R1, G1, B1, A1, ..., Rn, Gn, Bn, An }.
 *
 * Sample the specified in uniform parts.
 *
 * This procedure samples the active gradient in the specified number
 * of uniform parts. It returns a list of floating-point values which
 * correspond to the RGBA values for each sample. The minimum number of
 * samples to take is 2, in which case the returned colors will
 * correspond to the { 0.0, 1.0 } positions in the gradient. For
 * example, if the number of samples is 3, the procedure will return
 * the colors at positions { 0.0, 0.5, 1.0 }.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_get_uniform_samples (const gchar  *name,
                                   gint          num_samples,
                                   gboolean      reverse,
                                   gint         *num_color_samples,
                                   gdouble     **color_samples)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), num_samples);
  g_value_set_boolean (gimp_value_array_index (args, 2), reverse);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-get-uniform-samples",
                                               args);
  gimp_value_array_unref (args);

  *num_color_samples = 0;
  *color_samples = NULL;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *num_color_samples = g_value_get_int (gimp_value_array_index (return_vals, 1));
      *color_samples = gimp_value_dup_float_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_get_custom_samples:
 * @name: The gradient name.
 * @num_samples: The number of samples to take.
 * @positions: (array length=num_samples) (element-type gdouble): The list of positions to sample along the gradient.
 * @reverse: Use the reverse gradient.
 * @num_color_samples: (out): Length of the color_samples array (4 * num_samples).
 * @color_samples: (out) (array length=num_color_samples) (element-type gdouble) (transfer full): Color samples: { R1, G1, B1, A1, ..., Rn, Gn, Bn, An }.
 *
 * Sample the specified gradient in custom positions.
 *
 * This procedure samples the active gradient in the specified number
 * of points. The procedure will sample the gradient in the specified
 * positions from the list. The left endpoint of the gradient
 * corresponds to position 0.0, and the right endpoint corresponds to
 * 1.0. The procedure returns a list of floating-point values which
 * correspond to the RGBA values for each sample.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_get_custom_samples (const gchar    *name,
                                  gint            num_samples,
                                  const gdouble  *positions,
                                  gboolean        reverse,
                                  gint           *num_color_samples,
                                  gdouble       **color_samples)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_FLOAT_ARRAY,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), num_samples);
  gimp_value_set_float_array (gimp_value_array_index (args, 2), positions, num_samples);
  g_value_set_boolean (gimp_value_array_index (args, 3), reverse);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-get-custom-samples",
                                               args);
  gimp_value_array_unref (args);

  *num_color_samples = 0;
  *color_samples = NULL;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *num_color_samples = g_value_get_int (gimp_value_array_index (return_vals, 1));
      *color_samples = gimp_value_dup_float_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_left_color:
 * @name: The gradient name.
 * @segment: The index of the segment within the gradient.
 * @color: (out caller-allocates): The return color.
 * @opacity: (out): The opacity of the endpoint.
 *
 * Retrieves the left endpoint color of the specified segment
 *
 * This procedure retrieves the left endpoint color of the specified
 * segment of the specified gradient.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_get_left_color (const gchar *name,
                                      gint         segment,
                                      GimpRGB     *color,
                                      gdouble     *opacity)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), segment);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-get-left-color",
                                               args);
  gimp_value_array_unref (args);

  *opacity = 0.0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    {
      gimp_value_get_rgb (gimp_value_array_index (return_vals, 1), &*color);
      *opacity = g_value_get_double (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_set_left_color:
 * @name: The gradient name.
 * @segment: The index of the segment within the gradient.
 * @color: The color to set.
 * @opacity: The opacity to set for the endpoint.
 *
 * Sets the left endpoint color of the specified segment
 *
 * This procedure sets the left endpoint color of the specified segment
 * of the specified gradient.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_set_left_color (const gchar   *name,
                                      gint           segment,
                                      const GimpRGB *color,
                                      gdouble        opacity)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_RGB,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), segment);
  gimp_value_set_rgb (gimp_value_array_index (args, 2), color);
  g_value_set_double (gimp_value_array_index (args, 3), opacity);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-set-left-color",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_right_color:
 * @name: The gradient name.
 * @segment: The index of the segment within the gradient.
 * @color: (out caller-allocates): The return color.
 * @opacity: (out): The opacity of the endpoint.
 *
 * Retrieves the right endpoint color of the specified segment
 *
 * This procedure retrieves the right endpoint color of the specified
 * segment of the specified gradient.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_get_right_color (const gchar *name,
                                       gint         segment,
                                       GimpRGB     *color,
                                       gdouble     *opacity)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), segment);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-get-right-color",
                                               args);
  gimp_value_array_unref (args);

  *opacity = 0.0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    {
      gimp_value_get_rgb (gimp_value_array_index (return_vals, 1), &*color);
      *opacity = g_value_get_double (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_set_right_color:
 * @name: The gradient name.
 * @segment: The index of the segment within the gradient.
 * @color: The color to set.
 * @opacity: The opacity to set for the endpoint.
 *
 * Sets the right endpoint color of the specified segment
 *
 * This procedure sets the right endpoint color of the specified
 * segment of the specified gradient.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_set_right_color (const gchar   *name,
                                       gint           segment,
                                       const GimpRGB *color,
                                       gdouble        opacity)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_RGB,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), segment);
  gimp_value_set_rgb (gimp_value_array_index (args, 2), color);
  g_value_set_double (gimp_value_array_index (args, 3), opacity);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-set-right-color",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_left_pos:
 * @name: The gradient name.
 * @segment: The index of the segment within the gradient.
 * @pos: (out): The return position.
 *
 * Retrieves the left endpoint position of the specified segment
 *
 * This procedure retrieves the left endpoint position of the specified
 * segment of the specified gradient.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_get_left_pos (const gchar *name,
                                    gint         segment,
                                    gdouble     *pos)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), segment);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-get-left-pos",
                                               args);
  gimp_value_array_unref (args);

  *pos = 0.0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    *pos = g_value_get_double (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_set_left_pos:
 * @name: The gradient name.
 * @segment: The index of the segment within the gradient.
 * @pos: The position to set the guidepoint to.
 * @final_pos: (out): The return position.
 *
 * Sets the left endpoint position of the specified segment
 *
 * This procedure sets the left endpoint position of the specified
 * segment of the specified gradient. The final position will be
 * between the position of the middle point to the left to the middle
 * point of the current segment.
 * This procedure returns the final position.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_set_left_pos (const gchar *name,
                                    gint         segment,
                                    gdouble      pos,
                                    gdouble     *final_pos)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), segment);
  g_value_set_double (gimp_value_array_index (args, 2), pos);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-set-left-pos",
                                               args);
  gimp_value_array_unref (args);

  *final_pos = 0.0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    *final_pos = g_value_get_double (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_middle_pos:
 * @name: The gradient name.
 * @segment: The index of the segment within the gradient.
 * @pos: (out): The return position.
 *
 * Retrieves the middle point position of the specified segment
 *
 * This procedure retrieves the middle point position of the specified
 * segment of the specified gradient.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_get_middle_pos (const gchar *name,
                                      gint         segment,
                                      gdouble     *pos)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), segment);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-get-middle-pos",
                                               args);
  gimp_value_array_unref (args);

  *pos = 0.0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    *pos = g_value_get_double (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_set_middle_pos:
 * @name: The gradient name.
 * @segment: The index of the segment within the gradient.
 * @pos: The position to set the guidepoint to.
 * @final_pos: (out): The return position.
 *
 * Sets the middle point position of the specified segment
 *
 * This procedure sets the middle point position of the specified
 * segment of the specified gradient. The final position will be
 * between the two endpoints of the segment.
 * This procedure returns the final position.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_set_middle_pos (const gchar *name,
                                      gint         segment,
                                      gdouble      pos,
                                      gdouble     *final_pos)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), segment);
  g_value_set_double (gimp_value_array_index (args, 2), pos);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-set-middle-pos",
                                               args);
  gimp_value_array_unref (args);

  *final_pos = 0.0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    *final_pos = g_value_get_double (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_right_pos:
 * @name: The gradient name.
 * @segment: The index of the segment within the gradient.
 * @pos: (out): The return position.
 *
 * Retrieves the right endpoint position of the specified segment
 *
 * This procedure retrieves the right endpoint position of the
 * specified segment of the specified gradient.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_get_right_pos (const gchar *name,
                                     gint         segment,
                                     gdouble     *pos)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), segment);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-get-right-pos",
                                               args);
  gimp_value_array_unref (args);

  *pos = 0.0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    *pos = g_value_get_double (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_set_right_pos:
 * @name: The gradient name.
 * @segment: The index of the segment within the gradient.
 * @pos: The position to set the guidepoint to.
 * @final_pos: (out): The return position.
 *
 * Sets the right endpoint position of the specified segment
 *
 * This procedure sets the right endpoint position of the specified
 * segment of the specified gradient. The final position will be
 * between the position of the middle point of the current segment and
 * the middle point of the segment to the right.
 * This procedure returns the final position.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_set_right_pos (const gchar *name,
                                     gint         segment,
                                     gdouble      pos,
                                     gdouble     *final_pos)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), segment);
  g_value_set_double (gimp_value_array_index (args, 2), pos);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-set-right-pos",
                                               args);
  gimp_value_array_unref (args);

  *final_pos = 0.0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    *final_pos = g_value_get_double (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_blending_function:
 * @name: The gradient name.
 * @segment: The index of the segment within the gradient.
 * @blend_func: (out): The blending function of the segment.
 *
 * Retrieves the gradient segment's blending function
 *
 * This procedure retrieves the blending function of the segment at the
 * specified gradient name and segment index.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_get_blending_function (const gchar             *name,
                                             gint                     segment,
                                             GimpGradientSegmentType *blend_func)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), segment);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-get-blending-function",
                                               args);
  gimp_value_array_unref (args);

  *blend_func = 0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    *blend_func = g_value_get_enum (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_coloring_type:
 * @name: The gradient name.
 * @segment: The index of the segment within the gradient.
 * @coloring_type: (out): The coloring type of the segment.
 *
 * Retrieves the gradient segment's coloring type
 *
 * This procedure retrieves the coloring type of the segment at the
 * specified gradient name and segment index.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_get_coloring_type (const gchar              *name,
                                         gint                      segment,
                                         GimpGradientSegmentColor *coloring_type)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), segment);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-get-coloring-type",
                                               args);
  gimp_value_array_unref (args);

  *coloring_type = 0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    *coloring_type = g_value_get_enum (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_set_blending_function:
 * @name: The gradient name.
 * @start_segment: The index of the first segment to operate on.
 * @end_segment: The index of the last segment to operate on. If negative, the selection will extend to the end of the string.
 * @blending_function: The blending function.
 *
 * Change the blending function of a segments range
 *
 * This function changes the blending function of a segment range to
 * the specified blending function.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_set_blending_function (const gchar             *name,
                                                   gint                     start_segment,
                                                   gint                     end_segment,
                                                   GimpGradientSegmentType  blending_function)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_GRADIENT_SEGMENT_TYPE,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), start_segment);
  g_value_set_int (gimp_value_array_index (args, 2), end_segment);
  g_value_set_enum (gimp_value_array_index (args, 3), blending_function);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-range-set-blending-function",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_set_coloring_type:
 * @name: The gradient name.
 * @start_segment: The index of the first segment to operate on.
 * @end_segment: The index of the last segment to operate on. If negative, the selection will extend to the end of the string.
 * @coloring_type: The coloring type.
 *
 * Change the coloring type of a segments range
 *
 * This function changes the coloring type of a segment range to the
 * specified coloring type.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_set_coloring_type (const gchar              *name,
                                               gint                      start_segment,
                                               gint                      end_segment,
                                               GimpGradientSegmentColor  coloring_type)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_GRADIENT_SEGMENT_COLOR,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), start_segment);
  g_value_set_int (gimp_value_array_index (args, 2), end_segment);
  g_value_set_enum (gimp_value_array_index (args, 3), coloring_type);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-range-set-coloring-type",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_flip:
 * @name: The gradient name.
 * @start_segment: The index of the first segment to operate on.
 * @end_segment: The index of the last segment to operate on. If negative, the selection will extend to the end of the string.
 *
 * Flip the segment range
 *
 * This function flips a segment range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_flip (const gchar *name,
                                  gint         start_segment,
                                  gint         end_segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), start_segment);
  g_value_set_int (gimp_value_array_index (args, 2), end_segment);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-range-flip",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_replicate:
 * @name: The gradient name.
 * @start_segment: The index of the first segment to operate on.
 * @end_segment: The index of the last segment to operate on. If negative, the selection will extend to the end of the string.
 * @replicate_times: The number of times to replicate.
 *
 * Replicate the segment range
 *
 * This function replicates a segment range a given number of times.
 * Instead of the original segment range, several smaller scaled copies
 * of it will appear in equal widths.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_replicate (const gchar *name,
                                       gint         start_segment,
                                       gint         end_segment,
                                       gint         replicate_times)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), start_segment);
  g_value_set_int (gimp_value_array_index (args, 2), end_segment);
  g_value_set_int (gimp_value_array_index (args, 3), replicate_times);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-range-replicate",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_split_midpoint:
 * @name: The gradient name.
 * @start_segment: The index of the first segment to operate on.
 * @end_segment: The index of the last segment to operate on. If negative, the selection will extend to the end of the string.
 *
 * Splits each segment in the segment range at midpoint
 *
 * This function splits each segment in the segment range at its
 * midpoint.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_split_midpoint (const gchar *name,
                                            gint         start_segment,
                                            gint         end_segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), start_segment);
  g_value_set_int (gimp_value_array_index (args, 2), end_segment);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-range-split-midpoint",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_split_uniform:
 * @name: The gradient name.
 * @start_segment: The index of the first segment to operate on.
 * @end_segment: The index of the last segment to operate on. If negative, the selection will extend to the end of the string.
 * @split_parts: The number of uniform divisions to split each segment to.
 *
 * Splits each segment in the segment range uniformly
 *
 * This function splits each segment in the segment range uniformly
 * according to the number of times specified by the parameter.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_split_uniform (const gchar *name,
                                           gint         start_segment,
                                           gint         end_segment,
                                           gint         split_parts)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), start_segment);
  g_value_set_int (gimp_value_array_index (args, 2), end_segment);
  g_value_set_int (gimp_value_array_index (args, 3), split_parts);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-range-split-uniform",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_delete:
 * @name: The gradient name.
 * @start_segment: The index of the first segment to operate on.
 * @end_segment: The index of the last segment to operate on. If negative, the selection will extend to the end of the string.
 *
 * Delete the segment range
 *
 * This function deletes a segment range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_delete (const gchar *name,
                                    gint         start_segment,
                                    gint         end_segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), start_segment);
  g_value_set_int (gimp_value_array_index (args, 2), end_segment);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-range-delete",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_redistribute_handles:
 * @name: The gradient name.
 * @start_segment: The index of the first segment to operate on.
 * @end_segment: The index of the last segment to operate on. If negative, the selection will extend to the end of the string.
 *
 * Uniformly redistribute the segment range's handles
 *
 * This function redistributes the handles of the specified segment
 * range of the specified gradient, so they'll be evenly spaced.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_redistribute_handles (const gchar *name,
                                                  gint         start_segment,
                                                  gint         end_segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), start_segment);
  g_value_set_int (gimp_value_array_index (args, 2), end_segment);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-range-redistribute-handles",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_blend_colors:
 * @name: The gradient name.
 * @start_segment: The index of the first segment to operate on.
 * @end_segment: The index of the last segment to operate on. If negative, the selection will extend to the end of the string.
 *
 * Blend the colors of the segment range.
 *
 * This function blends the colors (but not the opacity) of the
 * segments' range of the gradient. Using it, the colors' transition
 * will be uniform across the range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_blend_colors (const gchar *name,
                                          gint         start_segment,
                                          gint         end_segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), start_segment);
  g_value_set_int (gimp_value_array_index (args, 2), end_segment);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-range-blend-colors",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_blend_opacity:
 * @name: The gradient name.
 * @start_segment: The index of the first segment to operate on.
 * @end_segment: The index of the last segment to operate on. If negative, the selection will extend to the end of the string.
 *
 * Blend the opacity of the segment range.
 *
 * This function blends the opacity (but not the colors) of the
 * segments' range of the gradient. Using it, the opacity's transition
 * will be uniform across the range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_blend_opacity (const gchar *name,
                                           gint         start_segment,
                                           gint         end_segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), start_segment);
  g_value_set_int (gimp_value_array_index (args, 2), end_segment);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-range-blend-opacity",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_move:
 * @name: The gradient name.
 * @start_segment: The index of the first segment to operate on.
 * @end_segment: The index of the last segment to operate on. If negative, the selection will extend to the end of the string.
 * @delta: The delta to move the segment range.
 * @control_compress: Whether or not to compress the neighboring segments.
 *
 * Move the position of an entire segment range by a delta.
 *
 * This function moves the position of an entire segment range by a
 * delta. The actual delta (which is returned) will be limited by the
 * control points of the neighboring segments.
 *
 * Returns: The final delta by which the range moved.
 *
 * Since: 2.2
 **/
gdouble
gimp_gradient_segment_range_move (const gchar *name,
                                  gint         start_segment,
                                  gint         end_segment,
                                  gdouble      delta,
                                  gboolean     control_compress)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble final_delta = 0.0;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), start_segment);
  g_value_set_int (gimp_value_array_index (args, 2), end_segment);
  g_value_set_double (gimp_value_array_index (args, 3), delta);
  g_value_set_boolean (gimp_value_array_index (args, 4), control_compress);

  return_vals = gimp_run_procedure_with_array ("gimp-gradient-segment-range-move",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    final_delta = g_value_get_double (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return final_delta;
}
