/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpimage_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpimage
 * @title: gimpimage
 * @short_description: Operations on complete images.
 *
 * Operations on complete images: creation, resizing/rescaling, and
 * operations involving multiple layers.
 **/


/**
 * gimp_image_is_valid:
 * @image_ID: The image to check.
 *
 * Returns TRUE if the image is valid.
 *
 * This procedure checks if the given image ID is valid and refers to
 * an existing image.
 *
 * Returns: Whether the image ID is valid.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_is_valid (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean valid = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-is-valid",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    valid = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return valid;
}

/**
 * gimp_image_list:
 * @num_images: (out): The number of images currently open.
 *
 * Returns the list of images currently open.
 *
 * This procedure returns the list of images currently open in GIMP.
 *
 * Returns: (array length=num_images) (element-type gint32) (transfer
 * full): The list of images currently open. The returned value must be
 * freed with g_free().
 **/
gint *
gimp_image_list (gint *num_images)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint *image_ids = NULL;

  args = gimp_value_array_new_from_types (G_TYPE_NONE);

  return_vals = gimp_run_procedure_with_array ("gimp-image-list",
                                               args);
  gimp_value_array_unref (args);

  *num_images = 0;

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    {
      *num_images = g_value_get_int (gimp_value_array_index (return_vals, 1));
      image_ids = gimp_value_dup_int32_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return image_ids;
}

/**
 * gimp_image_new:
 * @width: The width of the image.
 * @height: The height of the image.
 * @type: The type of image.
 *
 * Creates a new image with the specified width, height, and type.
 *
 * Creates a new image, undisplayed, with the specified extents and
 * type. A layer should be created and added before this image is
 * displayed, or subsequent calls to gimp_display_new() with this image
 * as an argument will fail. Layers can be created using the
 * gimp_layer_new() commands. They can be added to an image using the
 * gimp_image_insert_layer() command.
 *
 * If your image's type if INDEXED, a colormap must also be added with
 * gimp_image_set_colormap(). An indexed image without a colormap will
 * output unexpected colors.
 *
 * Returns: The ID of the newly created image.
 **/
gint32
gimp_image_new (gint              width,
                gint              height,
                GimpImageBaseType type)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 image_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_IMAGE_BASE_TYPE,
                                          G_TYPE_NONE);
  g_value_set_int (gimp_value_array_index (args, 0), width);
  g_value_set_int (gimp_value_array_index (args, 1), height);
  g_value_set_enum (gimp_value_array_index (args, 2), type);

  return_vals = gimp_run_procedure_with_array ("gimp-image-new",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    image_ID = gimp_value_get_image_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return image_ID;
}

/**
 * gimp_image_new_with_precision:
 * @width: The width of the image.
 * @height: The height of the image.
 * @type: The type of image.
 * @precision: The precision.
 *
 * Creates a new image with the specified width, height, type and
 * precision.
 *
 * Creates a new image, undisplayed with the specified extents, type
 * and precision. Indexed images can only be created at
 * GIMP_PRECISION_U8_NON_LINEAR precision. See gimp_image_new() for
 * further details.
 *
 * Returns: The ID of the newly created image.
 *
 * Since: 2.10
 **/
gint32
gimp_image_new_with_precision (gint              width,
                               gint              height,
                               GimpImageBaseType type,
                               GimpPrecision     precision)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 image_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_IMAGE_BASE_TYPE,
                                          GIMP_TYPE_PRECISION,
                                          G_TYPE_NONE);
  g_value_set_int (gimp_value_array_index (args, 0), width);
  g_value_set_int (gimp_value_array_index (args, 1), height);
  g_value_set_enum (gimp_value_array_index (args, 2), type);
  g_value_set_enum (gimp_value_array_index (args, 3), precision);

  return_vals = gimp_run_procedure_with_array ("gimp-image-new-with-precision",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    image_ID = gimp_value_get_image_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return image_ID;
}

/**
 * gimp_image_duplicate:
 * @image_ID: The image.
 *
 * Duplicate the specified image
 *
 * This procedure duplicates the specified image, copying all layers,
 * channels, and image information.
 *
 * Returns: The new, duplicated image.
 **/
gint32
gimp_image_duplicate (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 new_image_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-duplicate",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    new_image_ID = gimp_value_get_image_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return new_image_ID;
}

/**
 * gimp_image_delete:
 * @image_ID: The image.
 *
 * Delete the specified image.
 *
 * If there are no displays associated with this image it will be
 * deleted. This means that you can not delete an image through the PDB
 * that was created by the user. If the associated display was however
 * created through the PDB and you know the display ID, you may delete
 * the display. Removal of the last associated display will then delete
 * the image.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_delete (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-delete",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_base_type:
 * @image_ID: The image.
 *
 * Get the base type of the image.
 *
 * This procedure returns the image's base type. Layers in the image
 * must be of this subtype, but can have an optional alpha channel.
 *
 * Returns: The image's base type.
 **/
GimpImageBaseType
gimp_image_base_type (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpImageBaseType base_type = 0;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-base-type",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    base_type = g_value_get_enum (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return base_type;
}

/**
 * gimp_image_get_precision:
 * @image_ID: The image.
 *
 * Get the precision of the image.
 *
 * This procedure returns the image's precision.
 *
 * Returns: The image's precision.
 *
 * Since: 2.10
 **/
GimpPrecision
gimp_image_get_precision (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpPrecision precision = 0;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-precision",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    precision = g_value_get_enum (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return precision;
}

/**
 * gimp_image_get_default_new_layer_mode:
 * @image_ID: The image.
 *
 * Get the default mode for newly created layers of this image.
 *
 * Returns the default mode for newly created layers of this image.
 *
 * Returns: The layer mode.
 *
 * Since: 2.10
 **/
GimpLayerMode
gimp_image_get_default_new_layer_mode (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpLayerMode mode = 0;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-default-new-layer-mode",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    mode = g_value_get_enum (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return mode;
}

/**
 * gimp_image_width:
 * @image_ID: The image.
 *
 * Return the width of the image
 *
 * This procedure returns the image's width. This value is independent
 * of any of the layers in this image. This is the \"canvas\" width.
 *
 * Returns: The image's width.
 **/
gint
gimp_image_width (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint width = 0;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-width",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    width = g_value_get_int (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return width;
}

/**
 * gimp_image_height:
 * @image_ID: The image.
 *
 * Return the height of the image
 *
 * This procedure returns the image's height. This value is independent
 * of any of the layers in this image. This is the \"canvas\" height.
 *
 * Returns: The image's height.
 **/
gint
gimp_image_height (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint height = 0;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-height",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    height = g_value_get_int (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return height;
}

/**
 * gimp_image_get_layers:
 * @image_ID: The image.
 * @num_layers: (out): The number of layers contained in the image.
 *
 * Returns the list of layers contained in the specified image.
 *
 * This procedure returns the list of layers contained in the specified
 * image. The order of layers is from topmost to bottommost.
 *
 * Returns: (array length=num_layers) (element-type gint32) (transfer
 * full): The list of layers contained in the image. The returned value
 * must be freed with g_free().
 **/
gint *
gimp_image_get_layers (gint32  image_ID,
                       gint   *num_layers)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint *layer_ids = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-layers",
                                               args);
  gimp_value_array_unref (args);

  *num_layers = 0;

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    {
      *num_layers = g_value_get_int (gimp_value_array_index (return_vals, 1));
      layer_ids = gimp_value_dup_int32_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return layer_ids;
}

/**
 * gimp_image_get_channels:
 * @image_ID: The image.
 * @num_channels: (out): The number of channels contained in the image.
 *
 * Returns the list of channels contained in the specified image.
 *
 * This procedure returns the list of channels contained in the
 * specified image. This does not include the selection mask, or layer
 * masks. The order is from topmost to bottommost. Note that
 * \"channels\" are custom channels and do not include the image's
 * color components.
 *
 * Returns: (array length=num_channels) (element-type gint32) (transfer
 * full): The list of channels contained in the image. The returned
 * value must be freed with g_free().
 **/
gint *
gimp_image_get_channels (gint32  image_ID,
                         gint   *num_channels)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint *channel_ids = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-channels",
                                               args);
  gimp_value_array_unref (args);

  *num_channels = 0;

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    {
      *num_channels = g_value_get_int (gimp_value_array_index (return_vals, 1));
      channel_ids = gimp_value_dup_int32_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return channel_ids;
}

/**
 * gimp_image_get_vectors:
 * @image_ID: The image.
 * @num_vectors: (out): The number of vectors contained in the image.
 *
 * Returns the list of vectors contained in the specified image.
 *
 * This procedure returns the list of vectors contained in the
 * specified image.
 *
 * Returns: (array length=num_vectors) (element-type gint32) (transfer
 * full): The list of vectors contained in the image. The returned
 * value must be freed with g_free().
 *
 * Since: 2.4
 **/
gint *
gimp_image_get_vectors (gint32  image_ID,
                        gint   *num_vectors)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint *vector_ids = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-vectors",
                                               args);
  gimp_value_array_unref (args);

  *num_vectors = 0;

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    {
      *num_vectors = g_value_get_int (gimp_value_array_index (return_vals, 1));
      vector_ids = gimp_value_dup_int32_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return vector_ids;
}

/**
 * gimp_image_get_active_drawable:
 * @image_ID: The image.
 *
 * Get the image's active drawable
 *
 * This procedure returns the ID of the image's active drawable. This
 * can be either a layer, a channel, or a layer mask. The active
 * drawable is specified by the active image channel. If that is -1,
 * then by the active image layer. If the active image layer has a
 * layer mask and the layer mask is in edit mode, then the layer mask
 * is the active drawable.
 *
 * Returns: The active drawable.
 **/
gint32
gimp_image_get_active_drawable (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 drawable_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-active-drawable",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    drawable_ID = gimp_value_get_drawable_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return drawable_ID;
}

/**
 * gimp_image_unset_active_channel:
 * @image_ID: The image.
 *
 * Unsets the active channel in the specified image.
 *
 * If an active channel exists, it is unset. There then exists no
 * active channel, and if desired, one can be set through a call to
 * 'Set Active Channel'. No error is returned in the case of no
 * existing active channel.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_unset_active_channel (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-unset-active-channel",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_floating_sel:
 * @image_ID: The image.
 *
 * Return the floating selection of the image.
 *
 * This procedure returns the image's floating selection, if it exists.
 * If it doesn't exist, -1 is returned as the layer ID.
 *
 * Returns: The image's floating selection.
 **/
gint32
gimp_image_get_floating_sel (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 floating_sel_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-floating-sel",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    floating_sel_ID = gimp_value_get_layer_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return floating_sel_ID;
}

/**
 * gimp_image_floating_sel_attached_to:
 * @image_ID: The image.
 *
 * Return the drawable the floating selection is attached to.
 *
 * This procedure returns the drawable the image's floating selection
 * is attached to, if it exists. If it doesn't exist, -1 is returned as
 * the drawable ID.
 *
 * Returns: The drawable the floating selection is attached to.
 **/
gint32
gimp_image_floating_sel_attached_to (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 drawable_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-floating-sel-attached-to",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    drawable_ID = gimp_value_get_drawable_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return drawable_ID;
}

/**
 * gimp_image_pick_color:
 * @image_ID: The image.
 * @drawable_ID: The drawable to pick from.
 * @x: x coordinate of upper-left corner of rectangle.
 * @y: y coordinate of upper-left corner of rectangle.
 * @sample_merged: Use the composite image, not the drawable.
 * @sample_average: Average the color of all the pixels in a specified radius.
 * @average_radius: The radius of pixels to average.
 * @color: (out caller-allocates): The return color.
 *
 * Determine the color at the given drawable coordinates
 *
 * This tool determines the color at the specified coordinates. The
 * returned color is an RGB triplet even for grayscale and indexed
 * drawables. If the coordinates lie outside of the extents of the
 * specified drawable, then an error is returned. If the drawable has
 * an alpha channel, the algorithm examines the alpha value of the
 * drawable at the coordinates. If the alpha value is completely
 * transparent (0), then an error is returned. If the sample_merged
 * parameter is TRUE, the data of the composite image will be used
 * instead of that for the specified drawable. This is equivalent to
 * sampling for colors after merging all visible layers. In the case of
 * a merged sampling, the supplied drawable is ignored.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_pick_color (gint32    image_ID,
                       gint32    drawable_ID,
                       gdouble   x,
                       gdouble   y,
                       gboolean  sample_merged,
                       gboolean  sample_average,
                       gdouble   average_radius,
                       GimpRGB  *color)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_DRAWABLE_ID,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_drawable_id (gimp_value_array_index (args, 1), drawable_ID);
  g_value_set_double (gimp_value_array_index (args, 2), x);
  g_value_set_double (gimp_value_array_index (args, 3), y);
  g_value_set_boolean (gimp_value_array_index (args, 4), sample_merged);
  g_value_set_boolean (gimp_value_array_index (args, 5), sample_average);
  g_value_set_double (gimp_value_array_index (args, 6), average_radius);

  return_vals = gimp_run_procedure_with_array ("gimp-image-pick-color",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    gimp_value_get_rgb (gimp_value_array_index (return_vals, 1), &*color);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_pick_correlate_layer:
 * @image_ID: The image.
 * @x: The x coordinate for the pick.
 * @y: The y coordinate for the pick.
 *
 * Find the layer visible at the specified coordinates.
 *
 * This procedure finds the layer which is visible at the specified
 * coordinates. Layers which do not qualify are those whose extents do
 * not pass within the specified coordinates, or which are transparent
 * at the specified coordinates. This procedure will return -1 if no
 * layer is found.
 *
 * Returns: The layer found at the specified coordinates.
 **/
gint32
gimp_image_pick_correlate_layer (gint32 image_ID,
                                 gint   x,
                                 gint   y)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 layer_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_int (gimp_value_array_index (args, 1), x);
  g_value_set_int (gimp_value_array_index (args, 2), y);

  return_vals = gimp_run_procedure_with_array ("gimp-image-pick-correlate-layer",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    layer_ID = gimp_value_get_layer_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return layer_ID;
}

/**
 * gimp_image_insert_layer:
 * @image_ID: The image.
 * @layer_ID: The layer.
 * @parent_ID: The parent layer.
 * @position: The layer position.
 *
 * Add the specified layer to the image.
 *
 * This procedure adds the specified layer to the image at the given
 * position. If the specified parent is a valid layer group (See
 * gimp_item_is_group() and gimp_layer_group_new()) then the layer is
 * added inside the group. If the parent is 0, the layer is added
 * inside the main stack, outside of any group. The position argument
 * specifies the location of the layer inside the stack (or the group,
 * if a valid parent was supplied), starting from the top (0) and
 * increasing. If the position is specified as -1 and the parent is
 * specified as 0, then the layer is inserted above the active layer,
 * or inside the group if the active layer is a layer group. The layer
 * type must be compatible with the image base type.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_insert_layer (gint32 image_ID,
                         gint32 layer_ID,
                         gint32 parent_ID,
                         gint   position)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_LAYER_ID,
                                          GIMP_TYPE_LAYER_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_layer_id (gimp_value_array_index (args, 1), layer_ID);
  gimp_value_set_layer_id (gimp_value_array_index (args, 2), parent_ID);
  g_value_set_int (gimp_value_array_index (args, 3), position);

  return_vals = gimp_run_procedure_with_array ("gimp-image-insert-layer",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_remove_layer:
 * @image_ID: The image.
 * @layer_ID: The layer.
 *
 * Remove the specified layer from the image.
 *
 * This procedure removes the specified layer from the image. If the
 * layer doesn't exist, an error is returned. If there are no layers
 * left in the image, this call will fail. If this layer is the last
 * layer remaining, the image will become empty and have no active
 * layer.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_remove_layer (gint32 image_ID,
                         gint32 layer_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_LAYER_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_layer_id (gimp_value_array_index (args, 1), layer_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-remove-layer",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_freeze_layers:
 * @image_ID: The image.
 *
 * Freeze the image's layer list.
 *
 * This procedure freezes the layer list of the image, suppressing any
 * updates to the Layers dialog in response to changes to the image's
 * layers. This can significantly improve performance while applying
 * changes affecting the layer list.
 *
 * Each call to gimp_image_freeze_layers() should be matched by a
 * corresponding call to gimp_image_thaw_layers(), undoing its effects.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10.2
 **/
gboolean
gimp_image_freeze_layers (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-freeze-layers",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_thaw_layers:
 * @image_ID: The image.
 *
 * Thaw the image's layer list.
 *
 * This procedure thaws the layer list of the image, re-enabling
 * updates to the Layers dialog.
 *
 * This procedure should match a corresponding call to
 * gimp_image_freeze_layers().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10.2
 **/
gboolean
gimp_image_thaw_layers (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-thaw-layers",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_insert_channel:
 * @image_ID: The image.
 * @channel_ID: The channel.
 * @parent_ID: The parent channel.
 * @position: The channel position.
 *
 * Add the specified channel to the image.
 *
 * This procedure adds the specified channel to the image at the given
 * position. Since channel groups are not currently supported, the
 * parent argument must always be 0. The position argument specifies
 * the location of the channel inside the stack, starting from the top
 * (0) and increasing. If the position is specified as -1, then the
 * channel is inserted above the active channel.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_insert_channel (gint32 image_ID,
                           gint32 channel_ID,
                           gint32 parent_ID,
                           gint   position)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_CHANNEL_ID,
                                          GIMP_TYPE_CHANNEL_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_channel_id (gimp_value_array_index (args, 1), channel_ID);
  gimp_value_set_channel_id (gimp_value_array_index (args, 2), parent_ID);
  g_value_set_int (gimp_value_array_index (args, 3), position);

  return_vals = gimp_run_procedure_with_array ("gimp-image-insert-channel",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_remove_channel:
 * @image_ID: The image.
 * @channel_ID: The channel.
 *
 * Remove the specified channel from the image.
 *
 * This procedure removes the specified channel from the image. If the
 * channel doesn't exist, an error is returned.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_remove_channel (gint32 image_ID,
                           gint32 channel_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_CHANNEL_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_channel_id (gimp_value_array_index (args, 1), channel_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-remove-channel",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_freeze_channels:
 * @image_ID: The image.
 *
 * Freeze the image's channel list.
 *
 * This procedure freezes the channel list of the image, suppressing
 * any updates to the Channels dialog in response to changes to the
 * image's channels. This can significantly improve performance while
 * applying changes affecting the channel list.
 *
 * Each call to gimp_image_freeze_channels() should be matched by a
 * corresponding call to gimp_image_thaw_channels(), undoing its
 * effects.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10.2
 **/
gboolean
gimp_image_freeze_channels (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-freeze-channels",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_thaw_channels:
 * @image_ID: The image.
 *
 * Thaw the image's channel list.
 *
 * This procedure thaws the channel list of the image, re-enabling
 * updates to the Channels dialog.
 *
 * This procedure should match a corresponding call to
 * gimp_image_freeze_channels().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10.2
 **/
gboolean
gimp_image_thaw_channels (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-thaw-channels",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_insert_vectors:
 * @image_ID: The image.
 * @vectors_ID: The vectors.
 * @parent_ID: The parent vectors.
 * @position: The vectors position.
 *
 * Add the specified vectors to the image.
 *
 * This procedure adds the specified vectors to the image at the given
 * position. Since vectors groups are not currently supported, the
 * parent argument must always be 0. The position argument specifies
 * the location of the vectors inside the stack, starting from the top
 * (0) and increasing. If the position is specified as -1, then the
 * vectors is inserted above the active vectors.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_insert_vectors (gint32 image_ID,
                           gint32 vectors_ID,
                           gint32 parent_ID,
                           gint   position)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_VECTORS_ID,
                                          GIMP_TYPE_VECTORS_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_vectors_id (gimp_value_array_index (args, 1), vectors_ID);
  gimp_value_set_vectors_id (gimp_value_array_index (args, 2), parent_ID);
  g_value_set_int (gimp_value_array_index (args, 3), position);

  return_vals = gimp_run_procedure_with_array ("gimp-image-insert-vectors",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_remove_vectors:
 * @image_ID: The image.
 * @vectors_ID: The vectors object.
 *
 * Remove the specified path from the image.
 *
 * This procedure removes the specified path from the image. If the
 * path doesn't exist, an error is returned.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_remove_vectors (gint32 image_ID,
                           gint32 vectors_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_VECTORS_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_vectors_id (gimp_value_array_index (args, 1), vectors_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-remove-vectors",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_freeze_vectors:
 * @image_ID: The image.
 *
 * Freeze the image's vectors list.
 *
 * This procedure freezes the vectors list of the image, suppressing
 * any updates to the Paths dialog in response to changes to the
 * image's vectors. This can significantly improve performance while
 * applying changes affecting the vectors list.
 *
 * Each call to gimp_image_freeze_vectors() should be matched by a
 * corresponding call to gimp_image_thaw_vectors(), undoing its
 * effects.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10.2
 **/
gboolean
gimp_image_freeze_vectors (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-freeze-vectors",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_thaw_vectors:
 * @image_ID: The image.
 *
 * Thaw the image's vectors list.
 *
 * This procedure thaws the vectors list of the image, re-enabling
 * updates to the Paths dialog.
 *
 * This procedure should match a corresponding call to
 * gimp_image_freeze_vectors().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10.2
 **/
gboolean
gimp_image_thaw_vectors (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-thaw-vectors",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_item_position:
 * @image_ID: The image.
 * @item_ID: The item.
 *
 * Returns the position of the item in its level of its item tree.
 *
 * This procedure determines the position of the specified item in its
 * level in its item tree in the image. If the item doesn't exist in
 * the image, or the item is not part of an item tree, an error is
 * returned.
 *
 * Returns: The position of the item in its level in the item tree.
 *
 * Since: 2.8
 **/
gint
gimp_image_get_item_position (gint32 image_ID,
                              gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint position = 0;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_item_id (gimp_value_array_index (args, 1), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-item-position",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    position = g_value_get_int (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return position;
}

/**
 * gimp_image_raise_item:
 * @image_ID: The image.
 * @item_ID: The item to raise.
 *
 * Raise the specified item in its level in its item tree
 *
 * This procedure raises the specified item one step in the item tree.
 * The procedure call will fail if there is no item above it.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_image_raise_item (gint32 image_ID,
                       gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_item_id (gimp_value_array_index (args, 1), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-raise-item",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_lower_item:
 * @image_ID: The image.
 * @item_ID: The item to lower.
 *
 * Lower the specified item in its level in its item tree
 *
 * This procedure lowers the specified item one step in the item tree.
 * The procedure call will fail if there is no item below it.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_image_lower_item (gint32 image_ID,
                       gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_item_id (gimp_value_array_index (args, 1), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-lower-item",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_raise_item_to_top:
 * @image_ID: The image.
 * @item_ID: The item to raise to top.
 *
 * Raise the specified item to the top of its level in its item tree
 *
 * This procedure raises the specified item to top of its level in the
 * item tree. It will not move the item if there is no item above it.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_image_raise_item_to_top (gint32 image_ID,
                              gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_item_id (gimp_value_array_index (args, 1), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-raise-item-to-top",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_lower_item_to_bottom:
 * @image_ID: The image.
 * @item_ID: The item to lower to bottom.
 *
 * Lower the specified item to the bottom of its level in its item tree
 *
 * This procedure lowers the specified item to bottom of its level in
 * the item tree. It will not move the layer if there is no layer below
 * it.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_image_lower_item_to_bottom (gint32 image_ID,
                                 gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_item_id (gimp_value_array_index (args, 1), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-lower-item-to-bottom",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_reorder_item:
 * @image_ID: The image.
 * @item_ID: The item to reorder.
 * @parent_ID: The new parent item.
 * @position: The new position of the item.
 *
 * Reorder the specified item within its item tree
 *
 * This procedure reorders the specified item within its item tree.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_image_reorder_item (gint32 image_ID,
                         gint32 item_ID,
                         gint32 parent_ID,
                         gint   position)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_ITEM_ID,
                                          GIMP_TYPE_ITEM_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_item_id (gimp_value_array_index (args, 1), item_ID);
  gimp_value_set_item_id (gimp_value_array_index (args, 2), parent_ID);
  g_value_set_int (gimp_value_array_index (args, 3), position);

  return_vals = gimp_run_procedure_with_array ("gimp-image-reorder-item",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_flatten:
 * @image_ID: The image.
 *
 * Flatten all visible layers into a single layer. Discard all
 * invisible layers.
 *
 * This procedure combines the visible layers in a manner analogous to
 * merging with the CLIP_TO_IMAGE merge type. Non-visible layers are
 * discarded, and the resulting image is stripped of its alpha channel.
 *
 * Returns: The resulting layer.
 **/
gint32
gimp_image_flatten (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 layer_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-flatten",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    layer_ID = gimp_value_get_layer_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return layer_ID;
}

/**
 * gimp_image_merge_visible_layers:
 * @image_ID: The image.
 * @merge_type: The type of merge.
 *
 * Merge the visible image layers into one.
 *
 * This procedure combines the visible layers into a single layer using
 * the specified merge type. A merge type of EXPAND_AS_NECESSARY
 * expands the final layer to encompass the areas of the visible
 * layers. A merge type of CLIP_TO_IMAGE clips the final layer to the
 * extents of the image. A merge type of CLIP_TO_BOTTOM_LAYER clips the
 * final layer to the size of the bottommost layer.
 *
 * Returns: The resulting layer.
 **/
gint32
gimp_image_merge_visible_layers (gint32        image_ID,
                                 GimpMergeType merge_type)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 layer_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_MERGE_TYPE,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_enum (gimp_value_array_index (args, 1), merge_type);

  return_vals = gimp_run_procedure_with_array ("gimp-image-merge-visible-layers",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    layer_ID = gimp_value_get_layer_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return layer_ID;
}

/**
 * gimp_image_merge_down:
 * @image_ID: The image.
 * @merge_layer_ID: The layer to merge down from.
 * @merge_type: The type of merge.
 *
 * Merge the layer passed and the first visible layer below.
 *
 * This procedure combines the passed layer and the first visible layer
 * below it using the specified merge type. A merge type of
 * EXPAND_AS_NECESSARY expands the final layer to encompass the areas
 * of the visible layers. A merge type of CLIP_TO_IMAGE clips the final
 * layer to the extents of the image. A merge type of
 * CLIP_TO_BOTTOM_LAYER clips the final layer to the size of the
 * bottommost layer.
 *
 * Returns: The resulting layer.
 **/
gint32
gimp_image_merge_down (gint32        image_ID,
                       gint32        merge_layer_ID,
                       GimpMergeType merge_type)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 layer_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_LAYER_ID,
                                          GIMP_TYPE_MERGE_TYPE,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_layer_id (gimp_value_array_index (args, 1), merge_layer_ID);
  g_value_set_enum (gimp_value_array_index (args, 2), merge_type);

  return_vals = gimp_run_procedure_with_array ("gimp-image-merge-down",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    layer_ID = gimp_value_get_layer_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return layer_ID;
}

/**
 * _gimp_image_get_colormap:
 * @image_ID: The image.
 * @num_bytes: (out): Number of bytes in the colormap array.
 *
 * Returns the image's colormap
 *
 * This procedure returns an actual pointer to the image's colormap, as
 * well as the number of bytes contained in the colormap. The actual
 * number of colors in the transmitted colormap will be 'num-bytes' /
 * 3. If the image is not in Indexed color mode, no colormap is
 * returned.
 *
 * Returns: (array length=num_bytes) (element-type guint8) (transfer
 * full): The image's colormap. The returned value must be freed with
 * g_free().
 **/
guint8 *
_gimp_image_get_colormap (gint32  image_ID,
                          gint   *num_bytes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  guint8 *colormap = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-colormap",
                                               args);
  gimp_value_array_unref (args);

  *num_bytes = 0;

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    {
      *num_bytes = g_value_get_int (gimp_value_array_index (return_vals, 1));
      colormap = gimp_value_dup_int8_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return colormap;
}

/**
 * _gimp_image_set_colormap:
 * @image_ID: The image.
 * @num_bytes: Number of bytes in the colormap array.
 * @colormap: (array length=num_bytes) (element-type guint8): The new colormap values.
 *
 * Sets the entries in the image's colormap.
 *
 * This procedure sets the entries in the specified image's colormap.
 * The number of entries is specified by the 'num-bytes' parameter and
 * corresponds to the number of INT8 triples that must be contained in
 * the 'colormap' array. The actual number of colors in the transmitted
 * colormap is 'num-bytes' / 3.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_image_set_colormap (gint32        image_ID,
                          gint          num_bytes,
                          const guint8 *colormap)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT8_ARRAY,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_int (gimp_value_array_index (args, 1), num_bytes);
  gimp_value_set_int8_array (gimp_value_array_index (args, 2), colormap, num_bytes);

  return_vals = gimp_run_procedure_with_array ("gimp-image-set-colormap",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_image_get_metadata:
 * @image_ID: The image.
 *
 * Returns the image's metadata.
 *
 * Returns exif/iptc/xmp metadata from the image.
 *
 * Returns: (transfer full): The exif/ptc/xmp metadata as a string.
 **/
gchar *
_gimp_image_get_metadata (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *metadata_string = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-metadata",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    metadata_string = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return metadata_string;
}

/**
 * _gimp_image_set_metadata:
 * @image_ID: The image.
 * @metadata_string: The exif/ptc/xmp metadata as a string.
 *
 * Set the image's metadata.
 *
 * Sets exif/iptc/xmp metadata on the image.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_image_set_metadata (gint32       image_ID,
                          const gchar *metadata_string)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_string (gimp_value_array_index (args, 1), metadata_string);

  return_vals = gimp_run_procedure_with_array ("gimp-image-set-metadata",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_clean_all:
 * @image_ID: The image.
 *
 * Set the image dirty count to 0.
 *
 * This procedure sets the specified image's dirty count to 0, allowing
 * operations to occur without having a 'dirtied' image. This is
 * especially useful for creating and loading images which should not
 * initially be considered dirty, even though layers must be created,
 * filled, and installed in the image. Note that save plug-ins must NOT
 * call this function themselves after saving the image.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_clean_all (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-clean-all",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_is_dirty:
 * @image_ID: The image.
 *
 * Checks if the image has unsaved changes.
 *
 * This procedure checks the specified image's dirty count to see if it
 * needs to be saved. Note that saving the image does not automatically
 * set the dirty count to 0, you need to call gimp_image_clean_all()
 * after calling a save procedure to make the image clean.
 *
 * Returns: TRUE if the image has unsaved changes.
 **/
gboolean
gimp_image_is_dirty (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean dirty = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-is-dirty",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    dirty = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return dirty;
}

/**
 * _gimp_image_thumbnail:
 * @image_ID: The image.
 * @width: The requested thumbnail width.
 * @height: The requested thumbnail height.
 * @actual_width: (out): The previews width.
 * @actual_height: (out): The previews height.
 * @bpp: (out): The previews bpp.
 * @thumbnail_data_count: (out): The number of bytes in thumbnail data.
 * @thumbnail_data: (out) (array length=thumbnail_data_count) (element-type guint8) (transfer full): The thumbnail data.
 *
 * Get a thumbnail of an image.
 *
 * This function gets data from which a thumbnail of an image preview
 * can be created. Maximum x or y dimension is 1024 pixels. The pixels
 * are returned in RGB[A] or GRAY[A] format. The bpp return value gives
 * the number of bits per pixel in the image.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_image_thumbnail (gint32   image_ID,
                       gint     width,
                       gint     height,
                       gint    *actual_width,
                       gint    *actual_height,
                       gint    *bpp,
                       gint    *thumbnail_data_count,
                       guint8 **thumbnail_data)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_int (gimp_value_array_index (args, 1), width);
  g_value_set_int (gimp_value_array_index (args, 2), height);

  return_vals = gimp_run_procedure_with_array ("gimp-image-thumbnail",
                                               args);
  gimp_value_array_unref (args);

  *actual_width = 0;
  *actual_height = 0;
  *bpp = 0;
  *thumbnail_data_count = 0;
  *thumbnail_data = NULL;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *actual_width = g_value_get_int (gimp_value_array_index (return_vals, 1));
      *actual_height = g_value_get_int (gimp_value_array_index (return_vals, 2));
      *bpp = g_value_get_int (gimp_value_array_index (return_vals, 3));
      *thumbnail_data_count = g_value_get_int (gimp_value_array_index (return_vals, 4));
      *thumbnail_data = gimp_value_dup_int8_array (gimp_value_array_index (return_vals, 5));
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_active_layer:
 * @image_ID: The image.
 *
 * Returns the specified image's active layer.
 *
 * If there is an active layer, its ID will be returned, otherwise, -1.
 * If a channel is currently active, then no layer will be. If a layer
 * mask is active, then this will return the associated layer.
 *
 * Returns: The active layer.
 **/
gint32
gimp_image_get_active_layer (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 active_layer_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-active-layer",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    active_layer_ID = gimp_value_get_layer_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return active_layer_ID;
}

/**
 * gimp_image_set_active_layer:
 * @image_ID: The image.
 * @active_layer_ID: The new image active layer.
 *
 * Sets the specified image's active layer.
 *
 * If the layer exists, it is set as the active layer in the image. Any
 * previous active layer or channel is set to inactive. An exception is
 * a previously existing floating selection, in which case this
 * procedure will return an execution error.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_set_active_layer (gint32 image_ID,
                             gint32 active_layer_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_LAYER_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_layer_id (gimp_value_array_index (args, 1), active_layer_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-set-active-layer",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_active_channel:
 * @image_ID: The image.
 *
 * Returns the specified image's active channel.
 *
 * If there is an active channel, this will return the channel ID,
 * otherwise, -1.
 *
 * Returns: The active channel.
 **/
gint32
gimp_image_get_active_channel (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 active_channel_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-active-channel",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    active_channel_ID = gimp_value_get_channel_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return active_channel_ID;
}

/**
 * gimp_image_set_active_channel:
 * @image_ID: The image.
 * @active_channel_ID: The new image active channel.
 *
 * Sets the specified image's active channel.
 *
 * If the channel exists, it is set as the active channel in the image.
 * Any previous active channel or layer is set to inactive. An
 * exception is a previously existing floating selection, in which case
 * this procedure will return an execution error.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_set_active_channel (gint32 image_ID,
                               gint32 active_channel_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_CHANNEL_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_channel_id (gimp_value_array_index (args, 1), active_channel_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-set-active-channel",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_active_vectors:
 * @image_ID: The image.
 *
 * Returns the specified image's active vectors.
 *
 * If there is an active path, its ID will be returned, otherwise, -1.
 *
 * Returns: The active vectors.
 **/
gint32
gimp_image_get_active_vectors (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 active_vectors_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-active-vectors",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    active_vectors_ID = gimp_value_get_vectors_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return active_vectors_ID;
}

/**
 * gimp_image_set_active_vectors:
 * @image_ID: The image.
 * @active_vectors_ID: The new image active vectors.
 *
 * Sets the specified image's active vectors.
 *
 * If the path exists, it is set as the active path in the image.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_set_active_vectors (gint32 image_ID,
                               gint32 active_vectors_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_VECTORS_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_vectors_id (gimp_value_array_index (args, 1), active_vectors_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-set-active-vectors",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_selection:
 * @image_ID: The image.
 *
 * Returns the specified image's selection.
 *
 * This will always return a valid ID for a selection -- which is
 * represented as a channel internally.
 *
 * Returns: The selection channel.
 **/
gint32
gimp_image_get_selection (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 selection_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-selection",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    selection_ID = gimp_value_get_selection_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return selection_ID;
}

/**
 * gimp_image_get_component_active:
 * @image_ID: The image.
 * @component: The image component.
 *
 * Returns if the specified image's image component is active.
 *
 * This procedure returns if the specified image's image component
 * (i.e. Red, Green, Blue intensity channels in an RGB image) is active
 * or inactive -- whether or not it can be modified. If the specified
 * component is not valid for the image type, an error is returned.
 *
 * Returns: Component is active.
 **/
gboolean
gimp_image_get_component_active (gint32          image_ID,
                                 GimpChannelType component)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean active = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_CHANNEL_TYPE,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_enum (gimp_value_array_index (args, 1), component);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-component-active",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    active = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return active;
}

/**
 * gimp_image_set_component_active:
 * @image_ID: The image.
 * @component: The image component.
 * @active: Component is active.
 *
 * Sets if the specified image's image component is active.
 *
 * This procedure sets if the specified image's image component (i.e.
 * Red, Green, Blue intensity channels in an RGB image) is active or
 * inactive -- whether or not it can be modified. If the specified
 * component is not valid for the image type, an error is returned.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_set_component_active (gint32          image_ID,
                                 GimpChannelType component,
                                 gboolean        active)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_CHANNEL_TYPE,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_enum (gimp_value_array_index (args, 1), component);
  g_value_set_boolean (gimp_value_array_index (args, 2), active);

  return_vals = gimp_run_procedure_with_array ("gimp-image-set-component-active",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_component_visible:
 * @image_ID: The image.
 * @component: The image component.
 *
 * Returns if the specified image's image component is visible.
 *
 * This procedure returns if the specified image's image component
 * (i.e. Red, Green, Blue intensity channels in an RGB image) is
 * visible or invisible -- whether or not it can be seen. If the
 * specified component is not valid for the image type, an error is
 * returned.
 *
 * Returns: Component is visible.
 **/
gboolean
gimp_image_get_component_visible (gint32          image_ID,
                                  GimpChannelType component)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean visible = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_CHANNEL_TYPE,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_enum (gimp_value_array_index (args, 1), component);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-component-visible",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    visible = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return visible;
}

/**
 * gimp_image_set_component_visible:
 * @image_ID: The image.
 * @component: The image component.
 * @visible: Component is visible.
 *
 * Sets if the specified image's image component is visible.
 *
 * This procedure sets if the specified image's image component (i.e.
 * Red, Green, Blue intensity channels in an RGB image) is visible or
 * invisible -- whether or not it can be seen. If the specified
 * component is not valid for the image type, an error is returned.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_set_component_visible (gint32          image_ID,
                                  GimpChannelType component,
                                  gboolean        visible)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_CHANNEL_TYPE,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_enum (gimp_value_array_index (args, 1), component);
  g_value_set_boolean (gimp_value_array_index (args, 2), visible);

  return_vals = gimp_run_procedure_with_array ("gimp-image-set-component-visible",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_filename:
 * @image_ID: The image.
 *
 * Returns the specified image's filename.
 *
 * This procedure returns the specified image's filename in the
 * filesystem encoding. The image has a filename only if it was loaded
 * or imported from a file or has since been saved or exported.
 * Otherwise, this function returns %NULL. See also
 * gimp_image_get_uri().
 *
 * Returns: (transfer full): The filename. The returned value must be
 * freed with g_free().
 **/
gchar *
gimp_image_get_filename (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *filename = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-filename",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    filename = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return filename;
}

/**
 * gimp_image_set_filename:
 * @image_ID: The image.
 * @filename: The new image filename.
 *
 * Sets the specified image's filename.
 *
 * This procedure sets the specified image's filename. The filename
 * should be in the filesystem encoding.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_set_filename (gint32       image_ID,
                         const gchar *filename)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_string (gimp_value_array_index (args, 1), filename);

  return_vals = gimp_run_procedure_with_array ("gimp-image-set-filename",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_uri:
 * @image_ID: The image.
 *
 * Returns the URI for the specified image.
 *
 * This procedure returns the URI associated with the specified image.
 * The image has an URI only if it was loaded or imported from a file
 * or has since been saved or exported. Otherwise, this function
 * returns %NULL. See also gimp-image-get-imported-uri to get the URI
 * of the current file if it was imported from a non-GIMP file format
 * and not yet saved, or gimp-image-get-exported-uri if the image has
 * been exported to a non-GIMP file format.
 *
 * Returns: (transfer full): The URI. The returned value must be freed
 * with g_free().
 *
 * Since: 2.8
 **/
gchar *
gimp_image_get_uri (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *uri = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-uri",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    uri = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return uri;
}

/**
 * gimp_image_get_xcf_uri:
 * @image_ID: The image.
 *
 * Returns the XCF URI for the specified image.
 *
 * This procedure returns the XCF URI associated with the image. If
 * there is no such URI, this procedure returns %NULL.
 *
 * Returns: (transfer full): The imported URI. The returned value must
 * be freed with g_free().
 *
 * Since: 2.8
 **/
gchar *
gimp_image_get_xcf_uri (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *uri = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-xcf-uri",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    uri = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return uri;
}

/**
 * gimp_image_get_imported_uri:
 * @image_ID: The image.
 *
 * Returns the imported URI for the specified image.
 *
 * This procedure returns the URI associated with the specified image
 * if the image was imported from a non-native Gimp format. If the
 * image was not imported, or has since been saved in the native Gimp
 * format, this procedure returns %NULL.
 *
 * Returns: (transfer full): The imported URI. The returned value must
 * be freed with g_free().
 *
 * Since: 2.8
 **/
gchar *
gimp_image_get_imported_uri (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *uri = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-imported-uri",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    uri = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return uri;
}

/**
 * gimp_image_get_exported_uri:
 * @image_ID: The image.
 *
 * Returns the exported URI for the specified image.
 *
 * This procedure returns the URI associated with the specified image
 * if the image was exported a non-native GIMP format. If the image was
 * not exported, this procedure returns %NULL.
 *
 * Returns: (transfer full): The exported URI. The returned value must
 * be freed with g_free().
 *
 * Since: 2.8
 **/
gchar *
gimp_image_get_exported_uri (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *uri = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-exported-uri",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    uri = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return uri;
}

/**
 * gimp_image_get_name:
 * @image_ID: The image.
 *
 * Returns the specified image's name.
 *
 * This procedure returns the image's name. If the image has a filename
 * or an URI, then the returned name contains the filename's or URI's
 * base name (the last component of the path). Otherwise it is the
 * translated string \"Untitled\". The returned name is formatted like
 * the image name in the image window title, it may contain '[]',
 * '(imported)' etc. and should only be used to label user interface
 * elements. Never use it to construct filenames.
 *
 * Returns: (transfer full): The name. The returned value must be freed
 * with g_free().
 **/
gchar *
gimp_image_get_name (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-name",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    name = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return name;
}

/**
 * gimp_image_get_resolution:
 * @image_ID: The image.
 * @xresolution: (out): The resolution in the x-axis, in dots per inch.
 * @yresolution: (out): The resolution in the y-axis, in dots per inch.
 *
 * Returns the specified image's resolution.
 *
 * This procedure returns the specified image's resolution in dots per
 * inch. This value is independent of any of the layers in this image.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_get_resolution (gint32   image_ID,
                           gdouble *xresolution,
                           gdouble *yresolution)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-resolution",
                                               args);
  gimp_value_array_unref (args);

  *xresolution = 0.0;
  *yresolution = 0.0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *xresolution = g_value_get_double (gimp_value_array_index (return_vals, 1));
      *yresolution = g_value_get_double (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_set_resolution:
 * @image_ID: The image.
 * @xresolution: The new image resolution in the x-axis, in dots per inch.
 * @yresolution: The new image resolution in the y-axis, in dots per inch.
 *
 * Sets the specified image's resolution.
 *
 * This procedure sets the specified image's resolution in dots per
 * inch. This value is independent of any of the layers in this image.
 * No scaling or resizing is performed.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_set_resolution (gint32  image_ID,
                           gdouble xresolution,
                           gdouble yresolution)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_double (gimp_value_array_index (args, 1), xresolution);
  g_value_set_double (gimp_value_array_index (args, 2), yresolution);

  return_vals = gimp_run_procedure_with_array ("gimp-image-set-resolution",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_unit:
 * @image_ID: The image.
 *
 * Returns the specified image's unit.
 *
 * This procedure returns the specified image's unit. This value is
 * independent of any of the layers in this image. See the
 * gimp_unit_*() procedure definitions for the valid range of unit IDs
 * and a description of the unit system.
 *
 * Returns: The unit.
 **/
GimpUnit
gimp_image_get_unit (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpUnit unit = 0;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-unit",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    unit = g_value_get_int (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return unit;
}

/**
 * gimp_image_set_unit:
 * @image_ID: The image.
 * @unit: The new image unit.
 *
 * Sets the specified image's unit.
 *
 * This procedure sets the specified image's unit. No scaling or
 * resizing is performed. This value is independent of any of the
 * layers in this image. See the gimp_unit_*() procedure definitions
 * for the valid range of unit IDs and a description of the unit
 * system.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_set_unit (gint32   image_ID,
                     GimpUnit unit)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_UNIT,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_int (gimp_value_array_index (args, 1), unit);

  return_vals = gimp_run_procedure_with_array ("gimp-image-set-unit",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_tattoo_state:
 * @image_ID: The image.
 *
 * Returns the tattoo state associated with the image.
 *
 * This procedure returns the tattoo state of the image. Use only by
 * save/load plug-ins that wish to preserve an images tattoo state.
 * Using this function at other times will produce unexpected results.
 *
 * Returns: The tattoo state.
 **/
gint
gimp_image_get_tattoo_state (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint tattoo_state = 0;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-tattoo-state",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    tattoo_state = g_value_get_uint (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return tattoo_state;
}

/**
 * gimp_image_set_tattoo_state:
 * @image_ID: The image.
 * @tattoo_state: The new image tattoo state.
 *
 * Set the tattoo state associated with the image.
 *
 * This procedure sets the tattoo state of the image. Use only by
 * save/load plug-ins that wish to preserve an images tattoo state.
 * Using this function at other times will produce unexpected results.
 * A full check of uniqueness of states in layers, channels and paths
 * will be performed by this procedure and a execution failure will be
 * returned if this fails. A failure will also be returned if the new
 * tattoo state value is less than the maximum tattoo value from all of
 * the tattoos from the paths, layers and channels. After the image
 * data has been loaded and all the tattoos have been set then this is
 * the last procedure that should be called. If effectively does a
 * status check on the tattoo values that have been set to make sure
 * that all is OK.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_set_tattoo_state (gint32 image_ID,
                             gint   tattoo_state)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_uint (gimp_value_array_index (args, 1), tattoo_state);

  return_vals = gimp_run_procedure_with_array ("gimp-image-set-tattoo-state",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_layer_by_tattoo:
 * @image_ID: The image.
 * @tattoo: The tattoo of the layer to find.
 *
 * Find a layer with a given tattoo in an image.
 *
 * This procedure returns the layer with the given tattoo in the
 * specified image.
 *
 * Returns: The layer with the specified tattoo.
 **/
gint32
gimp_image_get_layer_by_tattoo (gint32 image_ID,
                                gint   tattoo)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 layer_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_uint (gimp_value_array_index (args, 1), tattoo);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-layer-by-tattoo",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    layer_ID = gimp_value_get_layer_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return layer_ID;
}

/**
 * gimp_image_get_channel_by_tattoo:
 * @image_ID: The image.
 * @tattoo: The tattoo of the channel to find.
 *
 * Find a channel with a given tattoo in an image.
 *
 * This procedure returns the channel with the given tattoo in the
 * specified image.
 *
 * Returns: The channel with the specified tattoo.
 **/
gint32
gimp_image_get_channel_by_tattoo (gint32 image_ID,
                                  gint   tattoo)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 channel_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_uint (gimp_value_array_index (args, 1), tattoo);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-channel-by-tattoo",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    channel_ID = gimp_value_get_channel_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return channel_ID;
}

/**
 * gimp_image_get_vectors_by_tattoo:
 * @image_ID: The image.
 * @tattoo: The tattoo of the vectors to find.
 *
 * Find a vectors with a given tattoo in an image.
 *
 * This procedure returns the vectors with the given tattoo in the
 * specified image.
 *
 * Returns: The vectors with the specified tattoo.
 *
 * Since: 2.6
 **/
gint32
gimp_image_get_vectors_by_tattoo (gint32 image_ID,
                                  gint   tattoo)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 vectors_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_uint (gimp_value_array_index (args, 1), tattoo);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-vectors-by-tattoo",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    vectors_ID = gimp_value_get_vectors_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return vectors_ID;
}

/**
 * gimp_image_get_layer_by_name:
 * @image_ID: The image.
 * @name: The name of the layer to find.
 *
 * Find a layer with a given name in an image.
 *
 * This procedure returns the layer with the given name in the
 * specified image.
 *
 * Returns: The layer with the specified name.
 *
 * Since: 2.8
 **/
gint32
gimp_image_get_layer_by_name (gint32       image_ID,
                              const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 layer_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_string (gimp_value_array_index (args, 1), name);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-layer-by-name",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    layer_ID = gimp_value_get_layer_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return layer_ID;
}

/**
 * gimp_image_get_channel_by_name:
 * @image_ID: The image.
 * @name: The name of the channel to find.
 *
 * Find a channel with a given name in an image.
 *
 * This procedure returns the channel with the given name in the
 * specified image.
 *
 * Returns: The channel with the specified name.
 *
 * Since: 2.8
 **/
gint32
gimp_image_get_channel_by_name (gint32       image_ID,
                                const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 channel_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_string (gimp_value_array_index (args, 1), name);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-channel-by-name",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    channel_ID = gimp_value_get_channel_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return channel_ID;
}

/**
 * gimp_image_get_vectors_by_name:
 * @image_ID: The image.
 * @name: The name of the vectors to find.
 *
 * Find a vectors with a given name in an image.
 *
 * This procedure returns the vectors with the given name in the
 * specified image.
 *
 * Returns: The vectors with the specified name.
 *
 * Since: 2.8
 **/
gint32
gimp_image_get_vectors_by_name (gint32       image_ID,
                                const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 vectors_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_string (gimp_value_array_index (args, 1), name);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-vectors-by-name",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    vectors_ID = gimp_value_get_vectors_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return vectors_ID;
}

/**
 * gimp_image_attach_parasite:
 * @image_ID: The image.
 * @parasite: The parasite to attach to an image.
 *
 * Add a parasite to an image.
 *
 * This procedure attaches a parasite to an image. It has no return
 * values.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_image_attach_parasite (gint32              image_ID,
                            const GimpParasite *parasite)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_PARASITE,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_boxed (gimp_value_array_index (args, 1), parasite);

  return_vals = gimp_run_procedure_with_array ("gimp-image-attach-parasite",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_detach_parasite:
 * @image_ID: The image.
 * @name: The name of the parasite to detach from an image.
 *
 * Removes a parasite from an image.
 *
 * This procedure detaches a parasite from an image. It has no return
 * values.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_image_detach_parasite (gint32       image_ID,
                            const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_string (gimp_value_array_index (args, 1), name);

  return_vals = gimp_run_procedure_with_array ("gimp-image-detach-parasite",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_parasite:
 * @image_ID: The image.
 * @name: The name of the parasite to find.
 *
 * Look up a parasite in an image
 *
 * Finds and returns the parasite that was previously attached to an
 * image.
 *
 * Returns: (transfer full): The found parasite.
 *
 * Since: 2.8
 **/
GimpParasite *
gimp_image_get_parasite (gint32       image_ID,
                         const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpParasite *parasite = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_string (gimp_value_array_index (args, 1), name);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-parasite",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    parasite = g_value_dup_boxed (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return parasite;
}

/**
 * gimp_image_get_parasite_list:
 * @image_ID: The image.
 * @num_parasites: (out): The number of attached parasites.
 *
 * List all parasites.
 *
 * Returns a list of all currently attached parasites.
 *
 * Returns: (array length=num_parasites) (element-type gchar*)
 * (transfer full): The names of currently attached parasites. The
 * returned value must be freed with g_strfreev().
 *
 * Since: 2.8
 **/
gchar **
gimp_image_get_parasite_list (gint32  image_ID,
                              gint   *num_parasites)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar **parasites = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-parasite-list",
                                               args);
  gimp_value_array_unref (args);

  *num_parasites = 0;

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    {
      *num_parasites = g_value_get_int (gimp_value_array_index (return_vals, 1));
      parasites = gimp_value_dup_string_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return parasites;
}
