/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpimagecolorprofile_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpimagecolorprofile
 * @title: gimpimagecolorprofile
 * @short_description: Operations on an image's color profile.
 *
 * Operations on an image's color profile.
 **/


/**
 * _gimp_image_get_color_profile:
 * @image_ID: The image.
 * @num_bytes: (out): Number of bytes in the color_profile array.
 *
 * Returns the image's color profile
 *
 * This procedure returns the image's color profile, or NULL if the
 * image has no color profile assigned.
 *
 * Returns: (array length=num_bytes) (element-type guint8) (transfer
 * full): The image's serialized color profile. The returned value must
 * be freed with g_free().
 *
 * Since: 2.10
 **/
guint8 *
_gimp_image_get_color_profile (gint32  image_ID,
                               gint   *num_bytes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  guint8 *profile_data = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-color-profile",
                                               args);
  gimp_value_array_unref (args);

  *num_bytes = 0;

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    {
      *num_bytes = g_value_get_int (gimp_value_array_index (return_vals, 1));
      profile_data = gimp_value_dup_int8_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return profile_data;
}

/**
 * _gimp_image_get_effective_color_profile:
 * @image_ID: The image.
 * @num_bytes: (out): Number of bytes in the color_profile array.
 *
 * Returns the color profile that is used for the image
 *
 * This procedure returns the color profile that is actually used for
 * this image, which is the profile returned by
 * gimp_image_get_color_profile() if the image has a profile assigned,
 * or a generated default RGB or grayscale profile, according to the
 * image's type.
 *
 * Returns: (array length=num_bytes) (element-type guint8) (transfer
 * full): The image's serialized color profile. The returned value must
 * be freed with g_free().
 *
 * Since: 2.10
 **/
guint8 *
_gimp_image_get_effective_color_profile (gint32  image_ID,
                                         gint   *num_bytes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  guint8 *profile_data = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-effective-color-profile",
                                               args);
  gimp_value_array_unref (args);

  *num_bytes = 0;

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    {
      *num_bytes = g_value_get_int (gimp_value_array_index (return_vals, 1));
      profile_data = gimp_value_dup_int8_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return profile_data;
}

/**
 * _gimp_image_set_color_profile:
 * @image_ID: The image.
 * @num_bytes: Number of bytes in the color_profile array.
 * @color_profile: (array length=num_bytes) (element-type guint8): The new serialized color profile.
 *
 * Sets the image's color profile
 *
 * This procedure sets the image's color profile, or unsets it if NULL
 * is passed as 'color_profile'. This procedure does no color
 * conversion. However, it will change the pixel format of all layers
 * to contain the babl space matching the profile. You must call this
 * procedure before adding layers to the image.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
_gimp_image_set_color_profile (gint32        image_ID,
                               gint          num_bytes,
                               const guint8 *color_profile)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT8_ARRAY,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_int (gimp_value_array_index (args, 1), num_bytes);
  gimp_value_set_int8_array (gimp_value_array_index (args, 2), color_profile, num_bytes);

  return_vals = gimp_run_procedure_with_array ("gimp-image-set-color-profile",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_set_color_profile_from_file:
 * @image_ID: The image.
 * @uri: The URI of the file containing the new color profile.
 *
 * Sets the image's color profile from an ICC file
 *
 * This procedure sets the image's color profile from a file containing
 * an ICC profile, or unsets it if NULL is passed as 'uri'. This
 * procedure does no color conversion. However, it will change the
 * pixel format of all layers to contain the babl space matching the
 * profile. You must call this procedure before adding layers to the
 * image.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_image_set_color_profile_from_file (gint32       image_ID,
                                        const gchar *uri)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_string (gimp_value_array_index (args, 1), uri);

  return_vals = gimp_run_procedure_with_array ("gimp-image-set-color-profile-from-file",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_image_convert_color_profile:
 * @image_ID: The image.
 * @num_bytes: Number of bytes in the color_profile array.
 * @color_profile: (array length=num_bytes) (element-type guint8): The serialized color profile.
 * @intent: Rendering intent.
 * @bpc: Black point compensation.
 *
 * Convert the image's layers to a color profile
 *
 * This procedure converts from the image's color profile (or the
 * default RGB or grayscale profile if none is set) to the given color
 * profile. Only RGB and grayscale color profiles are accepted,
 * according to the image's type.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
_gimp_image_convert_color_profile (gint32                    image_ID,
                                   gint                      num_bytes,
                                   const guint8             *color_profile,
                                   GimpColorRenderingIntent  intent,
                                   gboolean                  bpc)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT8_ARRAY,
                                          GIMP_TYPE_COLOR_RENDERING_INTENT,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_int (gimp_value_array_index (args, 1), num_bytes);
  gimp_value_set_int8_array (gimp_value_array_index (args, 2), color_profile, num_bytes);
  g_value_set_enum (gimp_value_array_index (args, 3), intent);
  g_value_set_boolean (gimp_value_array_index (args, 4), bpc);

  return_vals = gimp_run_procedure_with_array ("gimp-image-convert-color-profile",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_convert_color_profile_from_file:
 * @image_ID: The image.
 * @uri: The URI of the file containing the new color profile.
 * @intent: Rendering intent.
 * @bpc: Black point compensation.
 *
 * Convert the image's layers to a color profile
 *
 * This procedure converts from the image's color profile (or the
 * default RGB or grayscale profile if none is set) to an ICC profile
 * specified by 'uri'. Only RGB and grayscale color profiles are
 * accepted, according to the image's type.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_image_convert_color_profile_from_file (gint32                    image_ID,
                                            const gchar              *uri,
                                            GimpColorRenderingIntent  intent,
                                            gboolean                  bpc)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_STRING,
                                          GIMP_TYPE_COLOR_RENDERING_INTENT,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_string (gimp_value_array_index (args, 1), uri);
  g_value_set_enum (gimp_value_array_index (args, 2), intent);
  g_value_set_boolean (gimp_value_array_index (args, 3), bpc);

  return_vals = gimp_run_procedure_with_array ("gimp-image-convert-color-profile-from-file",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
