/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpimagegrid_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpimagegrid
 * @title: gimpimagegrid
 * @short_description: Functions manuipulating an image's grid.
 *
 * Functions manuipulating an image's grid.
 **/


/**
 * gimp_image_grid_get_spacing:
 * @image_ID: The image.
 * @xspacing: (out): The image's grid horizontal spacing.
 * @yspacing: (out): The image's grid vertical spacing.
 *
 * Gets the spacing of an image's grid.
 *
 * This procedure retrieves the horizontal and vertical spacing of an
 * image's grid. It takes the image as parameter.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_get_spacing (gint32   image_ID,
                             gdouble *xspacing,
                             gdouble *yspacing)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-grid-get-spacing",
                                               args);
  gimp_value_array_unref (args);

  *xspacing = 0.0;
  *yspacing = 0.0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *xspacing = g_value_get_double (gimp_value_array_index (return_vals, 1));
      *yspacing = g_value_get_double (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_set_spacing:
 * @image_ID: The image.
 * @xspacing: The image's grid horizontal spacing.
 * @yspacing: The image's grid vertical spacing.
 *
 * Sets the spacing of an image's grid.
 *
 * This procedure sets the horizontal and vertical spacing of an
 * image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_spacing (gint32  image_ID,
                             gdouble xspacing,
                             gdouble yspacing)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_double (gimp_value_array_index (args, 1), xspacing);
  g_value_set_double (gimp_value_array_index (args, 2), yspacing);

  return_vals = gimp_run_procedure_with_array ("gimp-image-grid-set-spacing",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_get_offset:
 * @image_ID: The image.
 * @xoffset: (out): The image's grid horizontal offset.
 * @yoffset: (out): The image's grid vertical offset.
 *
 * Gets the offset of an image's grid.
 *
 * This procedure retrieves the horizontal and vertical offset of an
 * image's grid. It takes the image as parameter.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_get_offset (gint32   image_ID,
                            gdouble *xoffset,
                            gdouble *yoffset)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-grid-get-offset",
                                               args);
  gimp_value_array_unref (args);

  *xoffset = 0.0;
  *yoffset = 0.0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *xoffset = g_value_get_double (gimp_value_array_index (return_vals, 1));
      *yoffset = g_value_get_double (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_set_offset:
 * @image_ID: The image.
 * @xoffset: The image's grid horizontal offset.
 * @yoffset: The image's grid vertical offset.
 *
 * Sets the offset of an image's grid.
 *
 * This procedure sets the horizontal and vertical offset of an image's
 * grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_offset (gint32  image_ID,
                            gdouble xoffset,
                            gdouble yoffset)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_double (gimp_value_array_index (args, 1), xoffset);
  g_value_set_double (gimp_value_array_index (args, 2), yoffset);

  return_vals = gimp_run_procedure_with_array ("gimp-image-grid-set-offset",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_get_foreground_color:
 * @image_ID: The image.
 * @fgcolor: (out caller-allocates): The image's grid foreground color.
 *
 * Sets the foreground color of an image's grid.
 *
 * This procedure gets the foreground color of an image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_get_foreground_color (gint32   image_ID,
                                      GimpRGB *fgcolor)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-grid-get-foreground-color",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    gimp_value_get_rgb (gimp_value_array_index (return_vals, 1), &*fgcolor);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_set_foreground_color:
 * @image_ID: The image.
 * @fgcolor: The new foreground color.
 *
 * Gets the foreground color of an image's grid.
 *
 * This procedure sets the foreground color of an image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_foreground_color (gint32         image_ID,
                                      const GimpRGB *fgcolor)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_RGB,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_rgb (gimp_value_array_index (args, 1), fgcolor);

  return_vals = gimp_run_procedure_with_array ("gimp-image-grid-set-foreground-color",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_get_background_color:
 * @image_ID: The image.
 * @bgcolor: (out caller-allocates): The image's grid background color.
 *
 * Sets the background color of an image's grid.
 *
 * This procedure gets the background color of an image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_get_background_color (gint32   image_ID,
                                      GimpRGB *bgcolor)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-grid-get-background-color",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    gimp_value_get_rgb (gimp_value_array_index (return_vals, 1), &*bgcolor);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_set_background_color:
 * @image_ID: The image.
 * @bgcolor: The new background color.
 *
 * Gets the background color of an image's grid.
 *
 * This procedure sets the background color of an image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_background_color (gint32         image_ID,
                                      const GimpRGB *bgcolor)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_RGB,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  gimp_value_set_rgb (gimp_value_array_index (args, 1), bgcolor);

  return_vals = gimp_run_procedure_with_array ("gimp-image-grid-set-background-color",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_get_style:
 * @image_ID: The image.
 *
 * Gets the style of an image's grid.
 *
 * This procedure retrieves the style of an image's grid.
 *
 * Returns: The image's grid style.
 *
 * Since: 2.4
 **/
GimpGridStyle
gimp_image_grid_get_style (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpGridStyle style = 0;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-grid-get-style",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    style = g_value_get_enum (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return style;
}

/**
 * gimp_image_grid_set_style:
 * @image_ID: The image.
 * @style: The image's grid style.
 *
 * Sets the style unit of an image's grid.
 *
 * This procedure sets the style of an image's grid. It takes the image
 * and the new style as parameters.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_style (gint32        image_ID,
                           GimpGridStyle style)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_GRID_STYLE,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_enum (gimp_value_array_index (args, 1), style);

  return_vals = gimp_run_procedure_with_array ("gimp-image-grid-set-style",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
