/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpitem_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpitem
 * @title: gimpitem
 * @short_description: Functions to manipulate items.
 *
 * Functions to manipulate items.
 **/


/**
 * gimp_item_is_valid:
 * @item_ID: The item to check.
 *
 * Returns TRUE if the item is valid.
 *
 * This procedure checks if the given item ID is valid and refers to an
 * existing item.
 *
 * Returns: Whether the item ID is valid.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_valid (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean valid = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-is-valid",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    valid = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return valid;
}

/**
 * gimp_item_get_image:
 * @item_ID: The item.
 *
 * Returns the item's image.
 *
 * This procedure returns the item's image.
 *
 * Returns: The item's image.
 *
 * Since: 2.8
 **/
gint32
gimp_item_get_image (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 image_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-get-image",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    image_ID = gimp_value_get_image_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return image_ID;
}

/**
 * gimp_item_delete:
 * @item_ID: The item to delete.
 *
 * Delete a item.
 *
 * This procedure deletes the specified item. This must not be done if
 * the image containing this item was already deleted or if the item
 * was already removed from the image. The only case in which this
 * procedure is useful is if you want to get rid of a item which has
 * not yet been added to an image.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_delete (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-delete",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_is_drawable:
 * @item_ID: The item.
 *
 * Returns whether the item is a drawable.
 *
 * This procedure returns TRUE if the specified item is a drawable.
 *
 * Returns: TRUE if the item is a drawable, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_drawable (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean drawable = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-is-drawable",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    drawable = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return drawable;
}

/**
 * gimp_item_is_layer:
 * @item_ID: The item.
 *
 * Returns whether the item is a layer.
 *
 * This procedure returns TRUE if the specified item is a layer.
 *
 * Returns: TRUE if the item is a layer, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_layer (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean layer = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-is-layer",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    layer = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return layer;
}

/**
 * gimp_item_is_text_layer:
 * @item_ID: The item.
 *
 * Returns whether the item is a text layer.
 *
 * This procedure returns TRUE if the specified item is a text layer.
 *
 * Returns: TRUE if the item is a text layer, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_text_layer (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean text_layer = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-is-text-layer",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    text_layer = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return text_layer;
}

/**
 * gimp_item_is_channel:
 * @item_ID: The item.
 *
 * Returns whether the item is a channel.
 *
 * This procedure returns TRUE if the specified item is a channel.
 *
 * Returns: TRUE if the item is a channel, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_channel (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean channel = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-is-channel",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    channel = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return channel;
}

/**
 * gimp_item_is_layer_mask:
 * @item_ID: The item.
 *
 * Returns whether the item is a layer mask.
 *
 * This procedure returns TRUE if the specified item is a layer mask.
 *
 * Returns: TRUE if the item is a layer mask, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_layer_mask (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean layer_mask = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-is-layer-mask",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    layer_mask = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return layer_mask;
}

/**
 * gimp_item_is_selection:
 * @item_ID: The item.
 *
 * Returns whether the item is a selection.
 *
 * This procedure returns TRUE if the specified item is a selection.
 *
 * Returns: TRUE if the item is a selection, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_selection (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean selection = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-is-selection",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    selection = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return selection;
}

/**
 * gimp_item_is_vectors:
 * @item_ID: The item.
 *
 * Returns whether the item is a vectors.
 *
 * This procedure returns TRUE if the specified item is a vectors.
 *
 * Returns: TRUE if the item is a vectors, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_vectors (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean vectors = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-is-vectors",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    vectors = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return vectors;
}

/**
 * gimp_item_is_group:
 * @item_ID: The item.
 *
 * Returns whether the item is a group item.
 *
 * This procedure returns TRUE if the specified item is a group item
 * which can have children.
 *
 * Returns: TRUE if the item is a group, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_group (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean group = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-is-group",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    group = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return group;
}

/**
 * gimp_item_get_parent:
 * @item_ID: The item.
 *
 * Returns the item's parent item.
 *
 * This procedure returns the item's parent item, if any.
 *
 * Returns: The item's parent item.
 *
 * Since: 2.8
 **/
gint32
gimp_item_get_parent (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 parent_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-get-parent",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    parent_ID = gimp_value_get_item_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return parent_ID;
}

/**
 * gimp_item_get_children:
 * @item_ID: The item.
 * @num_children: (out): The item's number of children.
 *
 * Returns the item's list of children.
 *
 * This procedure returns the list of items which are children of the
 * specified item. The order is topmost to bottommost.
 *
 * Returns: (array length=num_children) (element-type gint32) (transfer
 * full): The item's list of children.
 *
 * Since: 2.8
 **/
gint *
gimp_item_get_children (gint32  item_ID,
                        gint   *num_children)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint *child_ids = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-get-children",
                                               args);
  gimp_value_array_unref (args);

  *num_children = 0;

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    {
      *num_children = g_value_get_int (gimp_value_array_index (return_vals, 1));
      child_ids = gimp_value_dup_int32_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return child_ids;
}

/**
 * gimp_item_get_expanded:
 * @item_ID: The item.
 *
 * Returns whether the item is expanded.
 *
 * This procedure returns TRUE if the specified item is expanded.
 *
 * Returns: TRUE if the item is expanded, FALSE otherwise.
 *
 * Since: 2.10
 **/
gboolean
gimp_item_get_expanded (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean expanded = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-get-expanded",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    expanded = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return expanded;
}

/**
 * gimp_item_set_expanded:
 * @item_ID: The item.
 * @expanded: TRUE to expand the item, FALSE to collapse the item.
 *
 * Sets the expanded state of the item.
 *
 * This procedure expands or collapses the item.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_item_set_expanded (gint32   item_ID,
                        gboolean expanded)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);
  g_value_set_boolean (gimp_value_array_index (args, 1), expanded);

  return_vals = gimp_run_procedure_with_array ("gimp-item-set-expanded",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_name:
 * @item_ID: The item.
 *
 * Get the name of the specified item.
 *
 * This procedure returns the specified item's name.
 *
 * Returns: (transfer full): The item name.
 *
 * Since: 2.8
 **/
gchar *
gimp_item_get_name (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-get-name",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    name = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return name;
}

/**
 * gimp_item_set_name:
 * @item_ID: The item.
 * @name: The new item name.
 *
 * Set the name of the specified item.
 *
 * This procedure sets the specified item's name.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_name (gint32       item_ID,
                    const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);
  g_value_set_string (gimp_value_array_index (args, 1), name);

  return_vals = gimp_run_procedure_with_array ("gimp-item-set-name",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_visible:
 * @item_ID: The item.
 *
 * Get the visibility of the specified item.
 *
 * This procedure returns the specified item's visibility.
 *
 * Returns: The item visibility.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_get_visible (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean visible = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-get-visible",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    visible = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return visible;
}

/**
 * gimp_item_set_visible:
 * @item_ID: The item.
 * @visible: The new item visibility.
 *
 * Set the visibility of the specified item.
 *
 * This procedure sets the specified item's visibility.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_visible (gint32   item_ID,
                       gboolean visible)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);
  g_value_set_boolean (gimp_value_array_index (args, 1), visible);

  return_vals = gimp_run_procedure_with_array ("gimp-item-set-visible",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_linked:
 * @item_ID: The item.
 *
 * Get the linked state of the specified item.
 *
 * This procedure returns the specified item's linked state.
 *
 * Returns: The item linked state (for moves).
 *
 * Since: 2.8
 **/
gboolean
gimp_item_get_linked (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean linked = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-get-linked",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    linked = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return linked;
}

/**
 * gimp_item_set_linked:
 * @item_ID: The item.
 * @linked: The new item linked state.
 *
 * Set the linked state of the specified item.
 *
 * This procedure sets the specified item's linked state.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_linked (gint32   item_ID,
                      gboolean linked)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);
  g_value_set_boolean (gimp_value_array_index (args, 1), linked);

  return_vals = gimp_run_procedure_with_array ("gimp-item-set-linked",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_lock_content:
 * @item_ID: The item.
 *
 * Get the 'lock content' state of the specified item.
 *
 * This procedure returns the specified item's lock content state.
 *
 * Returns: Whether the item's contents are locked.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_get_lock_content (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean lock_content = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-get-lock-content",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    lock_content = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return lock_content;
}

/**
 * gimp_item_set_lock_content:
 * @item_ID: The item.
 * @lock_content: The new item 'lock content' state.
 *
 * Set the 'lock content' state of the specified item.
 *
 * This procedure sets the specified item's lock content state.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_lock_content (gint32   item_ID,
                            gboolean lock_content)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);
  g_value_set_boolean (gimp_value_array_index (args, 1), lock_content);

  return_vals = gimp_run_procedure_with_array ("gimp-item-set-lock-content",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_lock_position:
 * @item_ID: The item.
 *
 * Get the 'lock position' state of the specified item.
 *
 * This procedure returns the specified item's lock position state.
 *
 * Returns: Whether the item's position is locked.
 *
 * Since: 2.10
 **/
gboolean
gimp_item_get_lock_position (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean lock_position = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-get-lock-position",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    lock_position = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return lock_position;
}

/**
 * gimp_item_set_lock_position:
 * @item_ID: The item.
 * @lock_position: The new item 'lock position' state.
 *
 * Set the 'lock position' state of the specified item.
 *
 * This procedure sets the specified item's lock position state.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_item_set_lock_position (gint32   item_ID,
                             gboolean lock_position)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);
  g_value_set_boolean (gimp_value_array_index (args, 1), lock_position);

  return_vals = gimp_run_procedure_with_array ("gimp-item-set-lock-position",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_color_tag:
 * @item_ID: The item.
 *
 * Get the color tag of the specified item.
 *
 * This procedure returns the specified item's color tag.
 *
 * Returns: The item's color tag.
 *
 * Since: 2.10
 **/
GimpColorTag
gimp_item_get_color_tag (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpColorTag color_tag = 0;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-get-color-tag",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    color_tag = g_value_get_enum (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return color_tag;
}

/**
 * gimp_item_set_color_tag:
 * @item_ID: The item.
 * @color_tag: The new item color tag.
 *
 * Set the color tag of the specified item.
 *
 * This procedure sets the specified item's color tag.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_item_set_color_tag (gint32       item_ID,
                         GimpColorTag color_tag)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          GIMP_TYPE_COLOR_TAG,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);
  g_value_set_enum (gimp_value_array_index (args, 1), color_tag);

  return_vals = gimp_run_procedure_with_array ("gimp-item-set-color-tag",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_tattoo:
 * @item_ID: The item.
 *
 * Get the tattoo of the specified item.
 *
 * This procedure returns the specified item's tattoo. A tattoo is a
 * unique and permanent identifier attached to a item that can be used
 * to uniquely identify a item within an image even between sessions.
 *
 * Returns: The item tattoo.
 *
 * Since: 2.8
 **/
gint
gimp_item_get_tattoo (gint32 item_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint tattoo = 0;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-get-tattoo",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    tattoo = g_value_get_uint (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return tattoo;
}

/**
 * gimp_item_set_tattoo:
 * @item_ID: The item.
 * @tattoo: The new item tattoo.
 *
 * Set the tattoo of the specified item.
 *
 * This procedure sets the specified item's tattoo. A tattoo is a
 * unique and permanent identifier attached to a item that can be used
 * to uniquely identify a item within an image even between sessions.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_tattoo (gint32 item_ID,
                      gint   tattoo)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);
  g_value_set_uint (gimp_value_array_index (args, 1), tattoo);

  return_vals = gimp_run_procedure_with_array ("gimp-item-set-tattoo",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_attach_parasite:
 * @item_ID: The item.
 * @parasite: The parasite to attach to the item.
 *
 * Add a parasite to an item.
 *
 * This procedure attaches a parasite to an item. It has no return
 * values.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_attach_parasite (gint32              item_ID,
                           const GimpParasite *parasite)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          GIMP_TYPE_PARASITE,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);
  g_value_set_boxed (gimp_value_array_index (args, 1), parasite);

  return_vals = gimp_run_procedure_with_array ("gimp-item-attach-parasite",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_detach_parasite:
 * @item_ID: The item.
 * @name: The name of the parasite to detach from the item.
 *
 * Removes a parasite from an item.
 *
 * This procedure detaches a parasite from an item. It has no return
 * values.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_detach_parasite (gint32       item_ID,
                           const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);
  g_value_set_string (gimp_value_array_index (args, 1), name);

  return_vals = gimp_run_procedure_with_array ("gimp-item-detach-parasite",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_parasite:
 * @item_ID: The item.
 * @name: The name of the parasite to find.
 *
 * Look up a parasite in an item
 *
 * Finds and returns the parasite that is attached to an item.
 *
 * Returns: (transfer full): The found parasite.
 *
 * Since: 2.8
 **/
GimpParasite *
gimp_item_get_parasite (gint32       item_ID,
                        const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpParasite *parasite = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);
  g_value_set_string (gimp_value_array_index (args, 1), name);

  return_vals = gimp_run_procedure_with_array ("gimp-item-get-parasite",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    parasite = g_value_dup_boxed (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return parasite;
}

/**
 * gimp_item_get_parasite_list:
 * @item_ID: The item.
 * @num_parasites: (out): The number of attached parasites.
 *
 * List all parasites.
 *
 * Returns a list of all parasites currently attached the an item.
 *
 * Returns: (array length=num_parasites) (element-type gchar*)
 * (transfer full): The names of currently attached parasites. The
 * returned value must be freed with g_strfreev().
 *
 * Since: 2.8
 **/
gchar **
gimp_item_get_parasite_list (gint32  item_ID,
                             gint   *num_parasites)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar **parasites = NULL;

  args = gimp_value_array_new_from_types (GIMP_TYPE_ITEM_ID,
                                          G_TYPE_NONE);
  gimp_value_set_item_id (gimp_value_array_index (args, 0), item_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-item-get-parasite-list",
                                               args);
  gimp_value_array_unref (args);

  *num_parasites = 0;

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    {
      *num_parasites = g_value_get_int (gimp_value_array_index (return_vals, 1));
      parasites = gimp_value_dup_string_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return parasites;
}
