/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpplugin_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"

/**
 * _gimp_plugin_domain_register:
 * @domain_name: The name of the textdomain (must be unique).
 * @domain_path: The absolute path to the compiled message catalog (may be NULL).
 *
 * Registers a textdomain for localisation.
 *
 * This procedure adds a textdomain to the list of domains Gimp
 * searches for strings when translating its menu entries. There is no
 * need to call this function for plug-ins that have their strings
 * included in the 'gimp-std-plugins' domain as that is used by
 * default. If the compiled message catalog is not in the standard
 * location, you may specify an absolute path to another location. This
 * procedure can only be called in the query function of a plug-in and
 * it has to be called before any procedure is installed.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_plugin_domain_register (const gchar *domain_name,
                              const gchar *domain_path)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), domain_name);
  g_value_set_string (gimp_value_array_index (args, 1), domain_path);

  return_vals = gimp_run_procedure_with_array ("gimp-plugin-domain-register",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_plugin_help_register:
 * @domain_name: The XML namespace of the plug-in's help pages.
 * @domain_uri: The root URI of the plug-in's help pages.
 *
 * Register a help path for a plug-in.
 *
 * This procedure registers user documentation for the calling plug-in
 * with the GIMP help system. The domain_uri parameter points to the
 * root directory where the plug-in help is installed. For each
 * supported language there should be a file called 'gimp-help.xml'
 * that maps the help IDs to the actual help files.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_plugin_help_register (const gchar *domain_name,
                            const gchar *domain_uri)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), domain_name);
  g_value_set_string (gimp_value_array_index (args, 1), domain_uri);

  return_vals = gimp_run_procedure_with_array ("gimp-plugin-help-register",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_plugin_menu_branch_register:
 * @menu_path: The sub-menu's menu path.
 * @menu_name: The name of the sub-menu.
 *
 * Register a sub-menu.
 *
 * This procedure installs a sub-menu which does not belong to any
 * procedure. The menu-name should be the untranslated menu label. GIMP
 * will look up the translation in the textdomain registered for the
 * plug-in.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
_gimp_plugin_menu_branch_register (const gchar *menu_path,
                                   const gchar *menu_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), menu_path);
  g_value_set_string (gimp_value_array_index (args, 1), menu_name);

  return_vals = gimp_run_procedure_with_array ("gimp-plugin-menu-branch-register",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_plugin_menu_register:
 * @procedure_name: The procedure for which to install the menu path.
 * @menu_path: The procedure's additional menu path.
 *
 * Register an additional menu path for a plug-in procedure.
 *
 * This procedure installs an additional menu entry for the given
 * procedure.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
_gimp_plugin_menu_register (const gchar *procedure_name,
                            const gchar *menu_path)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), procedure_name);
  g_value_set_string (gimp_value_array_index (args, 1), menu_path);

  return_vals = gimp_run_procedure_with_array ("gimp-plugin-menu-register",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_plugin_icon_register:
 * @procedure_name: The procedure for which to install the icon.
 * @icon_type: The type of the icon.
 * @icon_data_length: The length of 'icon-data'.
 * @icon_data: (array length=icon_data_length) (element-type guint8): The procedure's icon. The format depends on the 'icon_type' parameter.
 *
 * Register an icon for a plug-in procedure.
 *
 * This procedure installs an icon for the given procedure.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
_gimp_plugin_icon_register (const gchar  *procedure_name,
                            GimpIconType  icon_type,
                            gint          icon_data_length,
                            const guint8 *icon_data)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_ICON_TYPE,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT8_ARRAY,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), procedure_name);
  g_value_set_enum (gimp_value_array_index (args, 1), icon_type);
  g_value_set_int (gimp_value_array_index (args, 2), icon_data_length);
  gimp_value_set_int8_array (gimp_value_array_index (args, 3), icon_data, icon_data_length);

  return_vals = gimp_run_procedure_with_array ("gimp-plugin-icon-register",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_plugin_set_pdb_error_handler:
 * @handler: Who is responsible for handling procedure call errors.
 *
 * Sets an error handler for procedure calls.
 *
 * This procedure changes the way that errors in procedure calls are
 * handled. By default GIMP will raise an error dialog if a procedure
 * call made by a plug-in fails. Using this procedure the plug-in can
 * change this behavior. If the error handler is set to
 * %GIMP_PDB_ERROR_HANDLER_PLUGIN, then the plug-in is responsible for
 * calling gimp_get_pdb_error() and handling the error whenever one if
 * its procedure calls fails. It can do this by displaying the error
 * message or by forwarding it in its own return values.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.6
 **/
gboolean
gimp_plugin_set_pdb_error_handler (GimpPDBErrorHandler handler)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_PDB_ERROR_HANDLER,
                                          G_TYPE_NONE);
  g_value_set_enum (gimp_value_array_index (args, 0), handler);

  return_vals = gimp_run_procedure_with_array ("gimp-plugin-set-pdb-error-handler",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_plugin_get_pdb_error_handler:
 *
 * Retrieves the active error handler for procedure calls.
 *
 * This procedure retrieves the currently active error handler for
 * procedure calls made by the calling plug-in. See
 * gimp_plugin_set_pdb_error_handler() for details.
 *
 * Returns: Who is responsible for handling procedure call errors.
 *
 * Since: 2.6
 **/
GimpPDBErrorHandler
gimp_plugin_get_pdb_error_handler (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpPDBErrorHandler handler = 0;

  args = gimp_value_array_new_from_types (G_TYPE_NONE);

  return_vals = gimp_run_procedure_with_array ("gimp-plugin-get-pdb-error-handler",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    handler = g_value_get_enum (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return handler;
}
