#
# Copyright 2019 Free Software Foundation, Inc.
#
# This file is part of GNU Radio
#
# SPDX-License-Identifier: GPL-3.0-or-later
#
#
""" testing the JSON files generated by gr-blocktool """

from __future__ import print_function
from __future__ import absolute_import
from __future__ import unicode_literals

import sys
import json
import jsonschema

from blocktool import RESULT_SCHEMA


def is_valid():
    """ Validate json file """

    with open(sys.argv[1], 'r') as json_file:
        data = json.load(json_file)
    try:
        print("Validating...")
        jsonschema.validate(data, RESULT_SCHEMA)
    except jsonschema.ValidationError as exception:
        print("Record JSON file # {}: NOT OK".format(sys.argv[1]))
        raise Exception(exception)
    else:
        print("Record JSON file # {}: OK".format(sys.argv[1]))


if __name__ == '__main__':
    if len(sys.argv) == 2:
        is_valid()
    else:
        raise Exception('Please input only one json file')
